/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.office.OfficeReader;
import writer2latex.util.Misc;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.IndexConverterHelper;
import writer2latex.xhtml.XhtmlBibliographyGenerator;
import writer2latex.xhtml.XhtmlConfig;

class BibliographyConverter
extends IndexConverterHelper {
    private XhtmlBibliographyGenerator bibGenerator;

    BibliographyConverter(OfficeReader ofr, XhtmlConfig config, Converter converter) {
        super(ofr, config, converter, "text:bibliography-source", "bibliography");
        this.bibGenerator = new XhtmlBibliographyGenerator(ofr, converter);
    }

    void handleBibliographyMark(Node onode, Node hnode) {
        String sKey = Misc.getAttribute(onode, "text:identifier");
        if (sKey != null) {
            Element anchor = this.converter.createLink("bib" + sKey);
            hnode.appendChild(anchor);
            anchor.appendChild(this.converter.createTextNode(this.bibGenerator.generateCitation(sKey)));
        }
    }

    @Override
    void populateIndex(Element source, Element container) {
        this.bibGenerator.populateBibliography(source, container);
    }
}

