/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.tasks;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.Scm;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.provider.Property;
import org.gradle.api.publication.maven.internal.VersionRangeMapper;
import org.gradle.api.publish.maven.MavenDependency;
import org.gradle.api.publish.maven.MavenPomCiManagement;
import org.gradle.api.publish.maven.MavenPomContributor;
import org.gradle.api.publish.maven.MavenPomDeveloper;
import org.gradle.api.publish.maven.MavenPomIssueManagement;
import org.gradle.api.publish.maven.MavenPomLicense;
import org.gradle.api.publish.maven.MavenPomMailingList;
import org.gradle.api.publish.maven.MavenPomOrganization;
import org.gradle.api.publish.maven.MavenPomRelocation;
import org.gradle.api.publish.maven.MavenPomScm;
import org.gradle.api.publish.maven.internal.dependencies.MavenDependencyInternal;
import org.gradle.api.publish.maven.internal.publication.MavenPomDistributionManagementInternal;
import org.gradle.api.publish.maven.internal.publication.MavenPomInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenProjectIdentity;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.util.GUtil;

public class MavenPomFileGenerator {
    private static final String POM_FILE_ENCODING = "UTF-8";
    private static final String POM_VERSION = "4.0.0";
    private final Model model = new Model();
    private XmlTransformer xmlTransformer = new XmlTransformer();
    private final VersionRangeMapper versionRangeMapper;

    public MavenPomFileGenerator(MavenProjectIdentity identity, VersionRangeMapper versionRangeMapper) {
        this.versionRangeMapper = versionRangeMapper;
        this.model.setModelVersion(POM_VERSION);
        this.model.setGroupId((String)identity.getGroupId().get());
        this.model.setArtifactId((String)identity.getArtifactId().get());
        this.model.setVersion((String)identity.getVersion().get());
    }

    public MavenPomFileGenerator configureFrom(MavenPomInternal pom) {
        this.model.setPackaging(pom.getPackaging());
        this.model.setName((String)pom.getName().getOrNull());
        this.model.setDescription((String)pom.getDescription().getOrNull());
        this.model.setUrl((String)pom.getUrl().getOrNull());
        this.model.setInceptionYear((String)pom.getInceptionYear().getOrNull());
        if (pom.getOrganization() != null) {
            this.model.setOrganization(this.convertOrganization(pom.getOrganization()));
        }
        if (pom.getScm() != null) {
            this.model.setScm(this.convertScm(pom.getScm()));
        }
        if (pom.getIssueManagement() != null) {
            this.model.setIssueManagement(this.convertIssueManagement(pom.getIssueManagement()));
        }
        if (pom.getCiManagement() != null) {
            this.model.setCiManagement(this.convertCiManagement(pom.getCiManagement()));
        }
        if (pom.getDistributionManagement() != null) {
            this.model.setDistributionManagement(this.convertDistributionManagement(pom.getDistributionManagement()));
        }
        for (MavenPomLicense license : pom.getLicenses()) {
            this.model.addLicense(this.convertLicense(license));
        }
        for (MavenPomDeveloper developer : pom.getDevelopers()) {
            this.model.addDeveloper(this.convertDeveloper(developer));
        }
        for (MavenPomContributor contributor : pom.getContributors()) {
            this.model.addContributor(this.convertContributor(contributor));
        }
        for (MavenPomMailingList mailingList : pom.getMailingLists()) {
            this.model.addMailingList(this.convertMailingList(mailingList));
        }
        return this;
    }

    private Organization convertOrganization(MavenPomOrganization source) {
        Organization target = new Organization();
        target.setName((String)source.getName().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        return target;
    }

    private License convertLicense(MavenPomLicense source) {
        License target = new License();
        target.setName((String)source.getName().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        target.setDistribution((String)source.getDistribution().getOrNull());
        target.setComments((String)source.getComments().getOrNull());
        return target;
    }

    private Developer convertDeveloper(MavenPomDeveloper source) {
        Developer target = new Developer();
        target.setId((String)source.getId().getOrNull());
        target.setName((String)source.getName().getOrNull());
        target.setEmail((String)source.getEmail().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        target.setOrganization((String)source.getOrganization().getOrNull());
        target.setOrganizationUrl((String)source.getOrganizationUrl().getOrNull());
        target.setRoles(new ArrayList((Collection)source.getRoles().get()));
        target.setTimezone((String)source.getTimezone().getOrNull());
        target.setProperties(this.convertProperties(source.getProperties()));
        return target;
    }

    private Contributor convertContributor(MavenPomContributor source) {
        Contributor target = new Contributor();
        target.setName((String)source.getName().getOrNull());
        target.setEmail((String)source.getEmail().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        target.setOrganization((String)source.getOrganization().getOrNull());
        target.setOrganizationUrl((String)source.getOrganizationUrl().getOrNull());
        target.setRoles(new ArrayList((Collection)source.getRoles().get()));
        target.setTimezone((String)source.getTimezone().getOrNull());
        target.setProperties(this.convertProperties(source.getProperties()));
        return target;
    }

    private Properties convertProperties(Property<Map<String, String>> source) {
        Properties target = new Properties();
        target.putAll((Map<?, ?>)((Map)source.getOrElse(Collections.emptyMap())));
        return target;
    }

    private Scm convertScm(MavenPomScm source) {
        Scm target = new Scm();
        target.setConnection((String)source.getConnection().getOrNull());
        target.setDeveloperConnection((String)source.getDeveloperConnection().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        target.setTag((String)source.getTag().getOrNull());
        return target;
    }

    private IssueManagement convertIssueManagement(MavenPomIssueManagement source) {
        IssueManagement target = new IssueManagement();
        target.setSystem((String)source.getSystem().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        return target;
    }

    private CiManagement convertCiManagement(MavenPomCiManagement source) {
        CiManagement target = new CiManagement();
        target.setSystem((String)source.getSystem().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        return target;
    }

    private DistributionManagement convertDistributionManagement(MavenPomDistributionManagementInternal source) {
        DistributionManagement target = new DistributionManagement();
        target.setDownloadUrl((String)source.getDownloadUrl().getOrNull());
        if (source.getRelocation() != null) {
            target.setRelocation(this.convertRelocation(source.getRelocation()));
        }
        return target;
    }

    private Relocation convertRelocation(MavenPomRelocation source) {
        Relocation target = new Relocation();
        target.setGroupId((String)source.getGroupId().getOrNull());
        target.setArtifactId((String)source.getArtifactId().getOrNull());
        target.setVersion((String)source.getVersion().getOrNull());
        target.setMessage((String)source.getMessage().getOrNull());
        return target;
    }

    private MailingList convertMailingList(MavenPomMailingList source) {
        MailingList target = new MailingList();
        target.setName((String)source.getName().getOrNull());
        target.setSubscribe((String)source.getSubscribe().getOrNull());
        target.setUnsubscribe((String)source.getUnsubscribe().getOrNull());
        target.setPost((String)source.getPost().getOrNull());
        target.setArchive((String)source.getArchive().getOrNull());
        target.setOtherArchives(new ArrayList((Collection)source.getOtherArchives().get()));
        return target;
    }

    public void addApiDependencyManagement(MavenDependency apiDependency) {
        this.addDependencyManagement(apiDependency, "compile");
    }

    public void addRuntimeDependencyManagement(MavenDependency dependency) {
        this.addDependencyManagement(dependency, "runtime");
    }

    public void addRuntimeDependency(MavenDependencyInternal dependency) {
        this.addDependency(dependency, "runtime");
    }

    public void addApiDependency(MavenDependencyInternal apiDependency) {
        this.addDependency(apiDependency, "compile");
    }

    private void addDependency(MavenDependencyInternal mavenDependency, String scope) {
        if (mavenDependency.getArtifacts().size() == 0) {
            this.addDependency(mavenDependency, mavenDependency.getArtifactId(), scope, null, null);
        } else {
            for (DependencyArtifact artifact : mavenDependency.getArtifacts()) {
                this.addDependency(mavenDependency, artifact.getName(), scope, artifact.getType(), artifact.getClassifier());
            }
        }
    }

    private void addDependency(MavenDependencyInternal dependency, String artifactId, String scope, String type, String classifier) {
        Dependency mavenDependency = new Dependency();
        mavenDependency.setGroupId(dependency.getGroupId());
        mavenDependency.setArtifactId(artifactId);
        mavenDependency.setVersion(this.mapToMavenSyntax(dependency.getVersion()));
        mavenDependency.setType(type);
        mavenDependency.setScope(scope);
        mavenDependency.setClassifier(classifier);
        for (ExcludeRule excludeRule : dependency.getExcludeRules()) {
            Exclusion exclusion = new Exclusion();
            exclusion.setGroupId((String)GUtil.elvis((Object)excludeRule.getGroup(), (Object)"*"));
            exclusion.setArtifactId((String)GUtil.elvis((Object)excludeRule.getModule(), (Object)"*"));
            mavenDependency.addExclusion(exclusion);
        }
        this.model.addDependency(mavenDependency);
    }

    private void addDependencyManagement(MavenDependency dependency, String scope) {
        Dependency mavenDependency = new Dependency();
        mavenDependency.setGroupId(dependency.getGroupId());
        mavenDependency.setArtifactId(dependency.getArtifactId());
        mavenDependency.setVersion(this.mapToMavenSyntax(dependency.getVersion()));
        mavenDependency.setScope(scope);
        DependencyManagement dependencyManagement = this.model.getDependencyManagement();
        if (dependencyManagement == null) {
            dependencyManagement = new DependencyManagement();
            this.model.setDependencyManagement(dependencyManagement);
        }
        dependencyManagement.addDependency(mavenDependency);
    }

    private String mapToMavenSyntax(String version) {
        return this.versionRangeMapper.map(version);
    }

    public MavenPomFileGenerator withXml(Action<XmlProvider> action) {
        this.xmlTransformer.addAction(action);
        return this;
    }

    public MavenPomFileGenerator writeTo(File file) {
        this.xmlTransformer.transform(file, POM_FILE_ENCODING, (Action)new Action<Writer>(){

            public void execute(Writer writer) {
                try {
                    new MavenXpp3Writer().write(writer, MavenPomFileGenerator.this.model);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        });
        return this;
    }
}

