/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference.impl.providers;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiFileSystemItemUtil {
    @Nullable
    public static String findRelativePath(PsiFileSystemItem src, PsiFileSystemItem dst) {
        VirtualFile srcFile = src != null ? src.getVirtualFile() : null;
        VirtualFile dstFile = dst != null ? dst.getVirtualFile() : null;
        return srcFile != null && dstFile != null ? VfsUtilCore.findRelativePath(srcFile, dstFile, '/') : null;
    }

    @Nullable
    public static String getRelativePathFromAncestor(PsiFileSystemItem file2, PsiFileSystemItem ancestor) {
        VirtualFile vFile = file2 != null ? file2.getVirtualFile() : null;
        VirtualFile ancestorVFile = ancestor != null ? ancestor.getVirtualFile() : null;
        return vFile != null && ancestorVFile != null ? VfsUtilCore.getRelativePath(vFile, ancestorVFile, '/') : null;
    }

    @Nullable
    private static PsiFileSystemItem getCommonAncestor(PsiFileSystemItem file1, PsiFileSystemItem file2) {
        PsiFileSystemItem parent1;
        if (file1 == file2) {
            return file1;
        }
        int depth1 = PsiFileSystemItemUtil.getDepth(file1);
        int depth2 = PsiFileSystemItemUtil.getDepth(file2);
        PsiFileSystemItem parent2 = file2;
        for (parent1 = file1; depth1 > depth2 && parent1 != null; parent1 = parent1.getParent(), --depth1) {
        }
        while (depth2 > depth1 && parent2 != null) {
            parent2 = parent2.getParent();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getParent();
            parent2 = parent2.getParent();
        }
        return parent1;
    }

    private static int getDepth(PsiFileSystemItem file2) {
        int depth = 0;
        while (file2 != null) {
            ++depth;
            file2 = file2.getParent();
        }
        return depth;
    }

    public static String getNotNullRelativePath(PsiFileSystemItem src, PsiFileSystemItem dst) throws IncorrectOperationException {
        String s = PsiFileSystemItemUtil.getRelativePath(src, dst);
        if (s == null) {
            throw new IncorrectOperationException("No way from " + src.getVirtualFile() + " to " + dst.getVirtualFile());
        }
        return s;
    }

    @Nullable
    public static String getRelativePath(PsiFileSystemItem src, PsiFileSystemItem dst) {
        PsiFileSystemItem commonAncestor = PsiFileSystemItemUtil.getCommonAncestor(src, dst);
        if (commonAncestor != null) {
            StringBuilder buffer = new StringBuilder();
            if (!src.equals(commonAncestor)) {
                while (!commonAncestor.equals(src.getParent())) {
                    buffer.append("..").append('/');
                    src = src.getParent();
                    assert (src != null);
                }
            }
            buffer.append(PsiFileSystemItemUtil.getRelativePathFromAncestor(dst, commonAncestor));
            return buffer.toString();
        }
        return null;
    }
}

