/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.codeInsight.BlockUtils;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiCatchSection;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiTryStatement;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;

public class PsiTryStatementImpl
extends CompositePsiElement
implements PsiTryStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiTryStatementImpl");
    private volatile PsiParameter[] myCachedCatchParameters;

    public PsiTryStatementImpl() {
        super(TRY_STATEMENT);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedCatchParameters = null;
    }

    @Override
    public PsiCodeBlock getTryBlock() {
        return (PsiCodeBlock)this.findChildByRoleAsPsiElement(48);
    }

    @Override
    @NotNull
    public PsiCodeBlock[] getCatchBlocks() {
        ASTNode tryBlock = SourceTreeToPsiMap.psiElementToTree(this.getTryBlock());
        if (tryBlock != null) {
            PsiCatchSection[] catchSections = this.getCatchSections();
            if (catchSections.length == 0) {
                if (PsiCodeBlock.EMPTY_ARRAY == null) {
                    PsiTryStatementImpl.$$$reportNull$$$0(0);
                }
                return PsiCodeBlock.EMPTY_ARRAY;
            }
            boolean lastIncomplete = catchSections[catchSections.length - 1].getCatchBlock() == null;
            PsiCodeBlock[] blocks = new PsiCodeBlock[lastIncomplete ? catchSections.length - 1 : catchSections.length];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = catchSections[i].getCatchBlock();
            }
            if (blocks == null) {
                PsiTryStatementImpl.$$$reportNull$$$0(1);
            }
            return blocks;
        }
        if (PsiCodeBlock.EMPTY_ARRAY == null) {
            PsiTryStatementImpl.$$$reportNull$$$0(2);
        }
        return PsiCodeBlock.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiParameter[] getCatchBlockParameters() {
        PsiParameter[] catchParameters = this.myCachedCatchParameters;
        if (catchParameters == null) {
            PsiCatchSection[] catchSections = this.getCatchSections();
            if (catchSections.length == 0) {
                if (PsiParameter.EMPTY_ARRAY == null) {
                    PsiTryStatementImpl.$$$reportNull$$$0(3);
                }
                return PsiParameter.EMPTY_ARRAY;
            }
            boolean lastIncomplete = catchSections[catchSections.length - 1].getCatchBlock() == null;
            int limit = lastIncomplete ? catchSections.length - 1 : catchSections.length;
            ArrayList<PsiParameter> parameters2 = new ArrayList<PsiParameter>();
            for (int i = 0; i < limit; ++i) {
                PsiParameter parameter = catchSections[i].getParameter();
                if (parameter == null) continue;
                parameters2.add(parameter);
            }
            catchParameters = parameters2.toArray(PsiParameter.EMPTY_ARRAY);
            this.myCachedCatchParameters = catchParameters;
        }
        if (catchParameters == null) {
            PsiTryStatementImpl.$$$reportNull$$$0(4);
        }
        return catchParameters;
    }

    @Override
    @NotNull
    public PsiCatchSection[] getCatchSections() {
        PsiCatchSection[] psiCatchSectionArray = (PsiCatchSection[])this.getChildrenAsPsiElements(CATCH_SECTION_BIT_SET, PsiCatchSection.ARRAY_FACTORY);
        if (psiCatchSectionArray == null) {
            PsiTryStatementImpl.$$$reportNull$$$0(5);
        }
        return psiCatchSectionArray;
    }

    @Override
    public PsiCodeBlock getFinallyBlock() {
        return (PsiCodeBlock)this.findChildByRoleAsPsiElement(52);
    }

    @Override
    public PsiResourceList getResourceList() {
        return PsiTreeUtil.getChildOfType(this, PsiResourceList.class);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 45: {
                return this.findChildByType(TRY_KEYWORD);
            }
            case 48: {
                return this.findChildByType(CODE_BLOCK);
            }
            case 47: {
                return this.findChildByType(FINALLY_KEYWORD);
            }
            case 52: 
        }
        ASTNode finallyKeyword = this.findChildByRole(47);
        if (finallyKeyword == null) {
            return null;
        }
        for (ASTNode child = finallyKeyword.getTreeNext(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != CODE_BLOCK) continue;
            return child;
        }
        return null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == TRY_KEYWORD) {
            return 45;
        }
        if (i == FINALLY_KEYWORD) {
            return 47;
        }
        if (i == CATCH_SECTION) {
            return 251;
        }
        if (child.getElementType() == CODE_BLOCK) {
            int role = this.getChildRole(child, 48);
            if (role != 0) {
                return role;
            }
            return this.getChildRole(child, 52);
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiTryStatementImpl.$$$reportNull$$$0(6);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitTryStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        PsiResourceList resourceList;
        if (processor2 == null) {
            PsiTryStatementImpl.$$$reportNull$$$0(7);
        }
        if (state2 == null) {
            PsiTryStatementImpl.$$$reportNull$$$0(8);
        }
        if (place == null) {
            PsiTryStatementImpl.$$$reportNull$$$0(9);
        }
        if ((resourceList = this.getResourceList()) != null && lastParent instanceof PsiCodeBlock && lastParent == this.getTryBlock()) {
            return PsiImplUtil.processDeclarationsInResourceList(resourceList, processor2, state2, lastParent);
        }
        return true;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiCodeBlock tryBlock;
        if (child == null) {
            PsiTryStatementImpl.$$$reportNull$$$0(10);
        }
        if (child.getPsi() instanceof PsiResourceList && this.getCatchBlocks().length == 0 && this.getFinallyBlock() == null && (tryBlock = this.getTryBlock()) != null) {
            BlockUtils.unwrapTryBlock(this);
            return;
        }
        super.deleteChildInternal(child);
    }

    @Override
    public String toString() {
        return "PsiTryStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCatchBlocks";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCatchBlockParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCatchSections";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

