/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.scope.processor;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodsProcessor;
import org.jetbrains.kotlin.com.intellij.psi.util.ImportsUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public class MethodCandidatesProcessor
extends MethodsProcessor {
    protected boolean myHasAccessibleStaticCorrectCandidate;

    public MethodCandidatesProcessor(@NotNull PsiElement place, PsiFile placeFile, @NotNull PsiConflictResolver[] resolvers, @NotNull List<CandidateInfo> container2) {
        if (place == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(0);
        }
        if (resolvers == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(1);
        }
        if (container2 == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(2);
        }
        super(resolvers, container2, place, placeFile);
    }

    public MethodCandidatesProcessor(@NotNull PsiElement place, PsiFile placeFile) {
        if (place == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(3);
        }
        super(new PsiConflictResolver[]{DuplicateConflictResolver.INSTANCE}, new SmartList<CandidateInfo>(), place, placeFile);
    }

    @Override
    public void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor2) {
        if (element == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(4);
        }
        if (substitutor2 == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            this.addMethod(method, substitutor2, this.isInStaticScope() && !method.hasModifierProperty("static"));
        }
    }

    public void addMethod(@NotNull PsiMethod method, PsiSubstitutor substitutor2, boolean staticProblem) {
        boolean isAccessible;
        if (method == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(6);
        }
        boolean bl = isAccessible = JavaResolveUtil.isAccessible(method, this.getContainingClass(method), method.getModifierList(), this.myPlace, this.myAccessClass, this.myCurrentFileContext, this.myPlaceFile) && !this.isShadowed(method);
        if (!(!this.isAccepted(method) || this.isInterfaceStaticMethodAccessibleThroughInheritance(method) && ImportsUtil.hasStaticImportOn(this.myPlace, method, true))) {
            PsiClass containingClass;
            if (!staticProblem && this.myAccessClass != null && method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && containingClass.isInterface() && !(this.myAccessClass instanceof PsiTypeParameter) && !containingClass.equals(this.myAccessClass)) {
                staticProblem = true;
            }
            this.add(this.createCandidateInfo(method, substitutor2, staticProblem, isAccessible, false));
            if (this.acceptVarargs() && method.isVarArgs() && PsiUtil.isLanguageLevel8OrHigher(this.myPlace)) {
                this.add(this.createCandidateInfo(method, substitutor2, staticProblem, isAccessible, true));
            }
            this.myHasAccessibleStaticCorrectCandidate |= isAccessible;
        }
    }

    private boolean isInterfaceStaticMethodAccessibleThroughInheritance(PsiMethod method) {
        if (method.hasModifierProperty("static") && !(this.myCurrentFileContext instanceof PsiImportStaticStatement) && this.myPlace instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)this.myPlace).getMethodExpression().getQualifierExpression() == null) {
            PsiClass containingClass = method.getContainingClass();
            return containingClass != null && containingClass.isInterface();
        }
        return false;
    }

    protected PsiClass getContainingClass(PsiMethod method) {
        return method.getContainingClass();
    }

    protected boolean acceptVarargs() {
        return false;
    }

    protected MethodCandidateInfo createCandidateInfo(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, boolean staticProblem, boolean accessible, final boolean varargs) {
        if (method == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(7);
        }
        if (substitutor2 == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(8);
        }
        final PsiExpressionList argumentList2 = this.getArgumentList();
        return new MethodCandidateInfo(method, substitutor2, !accessible, staticProblem, argumentList2, this.myCurrentFileContext, null, this.getTypeArguments(), this.getLanguageLevel()){
            private PsiType[] myExpressionTypes;

            @Override
            public PsiType[] getArgumentTypes() {
                if (this.myExpressionTypes == null && argumentList2 != null) {
                    PsiType[] expressionTypes = MethodCandidatesProcessor.getExpressionTypes(argumentList2);
                    if (MethodCandidateInfo.isOverloadCheck() || LambdaUtil.isLambdaParameterCheck()) {
                        return expressionTypes;
                    }
                    this.myExpressionTypes = expressionTypes;
                }
                return this.myExpressionTypes;
            }

            @Override
            public boolean isVarargs() {
                return varargs;
            }
        };
    }

    protected static PsiType[] getExpressionTypes(PsiExpressionList argumentList2) {
        return argumentList2 != null ? argumentList2.getExpressionTypes() : null;
    }

    protected boolean isAccepted(PsiMethod candidate2) {
        if (!this.isConstructor()) {
            return !candidate2.isConstructor() && candidate2.getName().equals(this.getName(ResolveState.initial()));
        }
        if (!candidate2.isConstructor()) {
            return false;
        }
        if (this.myAccessClass == null) {
            return true;
        }
        if (this.myAccessClass instanceof PsiAnonymousClass) {
            PsiClass containingClass = this.getContainingClass(candidate2);
            return containingClass != null && containingClass.equals(this.myAccessClass.getSuperClass());
        }
        return this.myAccessClass.isEquivalentTo(this.getContainingClass(candidate2));
    }

    protected boolean isShadowed(PsiMethod candidate2) {
        if (this.myCurrentFileContext instanceof PsiImportStaticStatement) {
            for (JavaResolveResult result2 : this.getResults()) {
                if (result2.getElement() == candidate2 || !result2.isAccessible() || result2.getCurrentFileResolveScope() instanceof PsiImportStaticStatement) continue;
                return true;
            }
        }
        return false;
    }

    public CandidateInfo[] getCandidates() {
        JavaResolveResult[] resolveResult = this.getResult();
        if (resolveResult.length == 0) {
            return CandidateInfo.EMPTY_ARRAY;
        }
        CandidateInfo[] infos2 = new CandidateInfo[resolveResult.length];
        System.arraycopy(resolveResult, 0, infos2, 0, resolveResult.length);
        return infos2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodCandidatesProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addMethod";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createCandidateInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

