/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.ConditionalTemplateOperation;
import org.gradle.buildinit.plugins.internal.ProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.internal.Factory;

public abstract class LanguageLibraryProjectInitDescriptor
implements ProjectInitDescriptor {
    protected final String language;
    protected final FileResolver fileResolver;
    protected final TemplateOperationFactory templateOperationFactory;
    protected final TemplateLibraryVersionProvider libraryVersionProvider;
    protected final ProjectInitDescriptor globalSettingsDescriptor;

    public LanguageLibraryProjectInitDescriptor(String language, TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider, ProjectInitDescriptor globalSettingsDescriptor) {
        this.language = language;
        this.fileResolver = fileResolver;
        this.templateOperationFactory = templateOperationFactory;
        this.libraryVersionProvider = libraryVersionProvider;
        this.globalSettingsDescriptor = globalSettingsDescriptor;
    }

    @Override
    public boolean supports(BuildInitDsl dsl) {
        return true;
    }

    protected TemplateOperation whenNoSourcesAvailable(TemplateOperation ... operations) {
        return new ConditionalTemplateOperation(new Factory<Boolean>(){

            public Boolean create() {
                return LanguageLibraryProjectInitDescriptor.this.fileResolver.resolveFilesAsTree(new Object[]{"src/main/" + LanguageLibraryProjectInitDescriptor.this.language}).isEmpty() || LanguageLibraryProjectInitDescriptor.this.fileResolver.resolveFilesAsTree(new Object[]{"src/test/" + LanguageLibraryProjectInitDescriptor.this.language}).isEmpty();
            }
        }, operations);
    }

    protected TemplateOperation fromClazzTemplate(String clazzTemplate, String sourceSetName) {
        return this.fromClazzTemplate(clazzTemplate, sourceSetName, this.language);
    }

    protected TemplateOperation fromClazzTemplate(String clazzTemplate, String sourceSetName, String language) {
        String targetFileName = clazzTemplate.substring(clazzTemplate.lastIndexOf("/") + 1).replace(".template", "");
        return this.fromClazzTemplate(clazzTemplate, sourceSetName, language, targetFileName);
    }

    protected TemplateOperation fromClazzTemplate(String clazzTemplate, String sourceSetName, String language, String targetFileName) {
        return this.templateOperationFactory.newTemplateOperation().withTemplate(clazzTemplate).withTarget("src/" + sourceSetName + "/" + language + "/" + targetFileName).create();
    }
}

