/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.recomp.AnnotationProcessorChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.ClasspathEntryChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.InputChangeAction;
import org.gradle.api.internal.tasks.compile.incremental.recomp.JavaChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceToNameConverter;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.file.FileType;
import org.gradle.internal.util.Alignment;

public class RecompilationSpecProvider {
    private final SourceToNameConverter sourceToNameConverter;

    public RecompilationSpecProvider(SourceToNameConverter sourceToNameConverter) {
        this.sourceToNameConverter = sourceToNameConverter;
    }

    public RecompilationSpec provideRecompilationSpec(CurrentCompilation current, PreviousCompilation previous) {
        RecompilationSpec spec = new RecompilationSpec();
        this.processClasspathChanges(current, previous, spec);
        this.processOtherChanges(current, previous, spec);
        spec.getClassesToProcess().addAll(previous.getTypesToReprocess());
        return spec;
    }

    private void processClasspathChanges(CurrentCompilation current, PreviousCompilation previous, RecompilationSpec spec) {
        ClasspathEntryChangeProcessor classpathEntryChangeProcessor = new ClasspathEntryChangeProcessor(current.getClasspathSnapshot(), previous);
        Map<File, ClasspathEntrySnapshot> previousCompilationSnapshots = previous.getSnapshots();
        ClasspathSnapshot currentSnapshots = current.getClasspathSnapshot();
        Set<File> previousCompilationEntries = previousCompilationSnapshots.keySet();
        Set<File> currentCompilationEntries = currentSnapshots.getEntries();
        List<Alignment<File>> alignment = Alignment.align(currentCompilationEntries.toArray(new File[0]), previousCompilationEntries.toArray(new File[0]));
        for (Alignment<File> fileAlignment : alignment) {
            switch (fileAlignment.getKind()) {
                case added: {
                    classpathEntryChangeProcessor.processChange((InputFileDetails)FileChange.added((String)fileAlignment.getCurrentValue().getAbsolutePath(), (String)"classpathEntry", (FileType)FileType.RegularFile), spec);
                    break;
                }
                case removed: {
                    classpathEntryChangeProcessor.processChange((InputFileDetails)FileChange.removed((String)fileAlignment.getPreviousValue().getAbsolutePath(), (String)"classpathEntry", (FileType)FileType.RegularFile), spec);
                    break;
                }
                case transformed: {
                    spec.setFullRebuildCause("Classpath has been changed", null);
                    return;
                }
                case identical: {
                    File key = fileAlignment.getPreviousValue();
                    ClasspathEntrySnapshot previousSnapshot = previousCompilationSnapshots.get(key);
                    ClasspathEntrySnapshot snapshot = currentSnapshots.getSnapshot(key);
                    if (snapshot.getHash().equals((Object)previousSnapshot.getHash())) break;
                    classpathEntryChangeProcessor.processChange((InputFileDetails)FileChange.modified((String)key.getAbsolutePath(), (String)"classpathEntry", (FileType)FileType.RegularFile, (FileType)FileType.RegularFile), spec);
                }
            }
        }
    }

    private void processOtherChanges(CurrentCompilation current, PreviousCompilation previous, RecompilationSpec spec) {
        JavaChangeProcessor javaChangeProcessor = new JavaChangeProcessor(previous, this.sourceToNameConverter);
        AnnotationProcessorChangeProcessor annotationProcessorChangeProcessor = new AnnotationProcessorChangeProcessor(current, previous);
        InputChangeAction action = new InputChangeAction(spec, javaChangeProcessor, annotationProcessorChangeProcessor);
        current.visitChanges(action);
    }
}

