/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.UniqueIdFormat;

@API(status=API.Status.STABLE, since="1.0")
public class UniqueId
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ENGINE_SEGMENT_TYPE = "engine";
    private final UniqueIdFormat uniqueIdFormat;
    private final List<Segment> segments;

    public static UniqueId parse(String uniqueId) throws JUnitException {
        Preconditions.notBlank((String)uniqueId, (String)"Unique ID string must not be null or blank");
        return UniqueIdFormat.getDefault().parse(uniqueId);
    }

    public static UniqueId forEngine(String engineId) {
        Preconditions.notBlank((String)engineId, (String)"engineId must not be null or blank");
        return UniqueId.root(ENGINE_SEGMENT_TYPE, engineId);
    }

    public static UniqueId root(String segmentType, String value) {
        Preconditions.notBlank((String)segmentType, (String)"segmentType must not be null or blank");
        Preconditions.notBlank((String)value, (String)"value must not be null or blank");
        return new UniqueId(UniqueIdFormat.getDefault(), new Segment(segmentType, value));
    }

    private UniqueId(UniqueIdFormat uniqueIdFormat, Segment segment) {
        this.uniqueIdFormat = uniqueIdFormat;
        this.segments = Collections.singletonList(segment);
    }

    UniqueId(UniqueIdFormat uniqueIdFormat, List<Segment> segments) {
        this.uniqueIdFormat = uniqueIdFormat;
        this.segments = Collections.unmodifiableList(segments);
    }

    final Optional<Segment> getRoot() {
        return this.segments.isEmpty() ? Optional.empty() : Optional.of(this.segments.get(0));
    }

    public final Optional<String> getEngineId() {
        return this.getRoot().filter(segment -> segment.getType().equals(ENGINE_SEGMENT_TYPE)).map(Segment::getValue);
    }

    public final List<Segment> getSegments() {
        return this.segments;
    }

    public final UniqueId append(String segmentType, String value) {
        Preconditions.notBlank((String)segmentType, (String)"segmentType must not be null or blank");
        Preconditions.notBlank((String)value, (String)"value must not be null or blank");
        ArrayList<Segment> baseSegments = new ArrayList<Segment>(this.segments);
        baseSegments.add(new Segment(segmentType, value));
        return new UniqueId(this.uniqueIdFormat, baseSegments);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniqueId that = (UniqueId)o;
        return this.segments.equals(that.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public String toString() {
        return this.uniqueIdFormat.format(this);
    }

    @API(status=API.Status.STABLE, since="1.0")
    public static class Segment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String type;
        private final String value;

        Segment(String type, String value) {
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Segment that = (Segment)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("type", (Object)this.type).append("value", (Object)this.value).toString();
        }
    }
}

