/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.List;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.internal.GradleInternal;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.execution.TaskExecutionGraphInternal;
import org.gradle.execution.TaskSelector;
import org.gradle.execution.commandline.CommandLineTaskParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskNameResolvingBuildConfigurationAction
implements BuildConfigurationAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskNameResolvingBuildConfigurationAction.class);
    private final CommandLineTaskParser commandLineTaskParser;

    public TaskNameResolvingBuildConfigurationAction(CommandLineTaskParser commandLineTaskParser) {
        this.commandLineTaskParser = commandLineTaskParser;
    }

    @Override
    public void configure(BuildExecutionContext context) {
        GradleInternal gradle = context.getGradle();
        TaskExecutionGraphInternal taskGraph = gradle.getTaskGraph();
        List taskParameters = gradle.getStartParameter().getTaskRequests();
        for (TaskExecutionRequest taskParameter : taskParameters) {
            List<TaskSelector.TaskSelection> taskSelections = this.commandLineTaskParser.parseTasks(taskParameter);
            for (TaskSelector.TaskSelection taskSelection : taskSelections) {
                LOGGER.info("Selected primary task '{}' from project {}", (Object)taskSelection.getTaskName(), (Object)taskSelection.getProjectPath());
                taskGraph.addTasks(taskSelection.getTasks());
            }
        }
        context.proceed();
    }
}

