/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import com.google.common.collect.ImmutableCollection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.execution.taskgraph.LocalTaskInfo;
import org.gradle.execution.taskgraph.TaskDependencyResolver;
import org.gradle.execution.taskgraph.TaskInfo;
import org.gradle.execution.taskgraph.WorkInfo;
import org.gradle.internal.build.BuildState;

public class TaskInfoFactory {
    private final Map<Task, TaskInfo> nodes = new HashMap<Task, TaskInfo>();
    private final IncludedBuildTaskGraph taskGraph;
    private final GradleInternal thisBuild;
    private final BuildIdentifier currentBuildId;

    public TaskInfoFactory(GradleInternal thisBuild, IncludedBuildTaskGraph taskGraph) {
        this.thisBuild = thisBuild;
        this.currentBuildId = ((BuildState)thisBuild.getServices().get(BuildState.class)).getBuildIdentifier();
        this.taskGraph = taskGraph;
    }

    public Set<Task> getTasks() {
        return this.nodes.keySet();
    }

    public TaskInfo getOrCreateNode(Task task) {
        TaskInfo node = this.nodes.get(task);
        if (node == null) {
            node = task.getProject().getGradle() == this.thisBuild ? new LocalTaskInfo((TaskInternal)task) : new TaskInAnotherBuild((TaskInternal)task, this.currentBuildId, this.taskGraph);
            this.nodes.put(task, node);
        }
        return node;
    }

    public void clear() {
        this.nodes.clear();
    }

    private static class TaskInAnotherBuild
    extends TaskInfo {
        private final BuildIdentifier thisBuild;
        private final IncludedBuildTaskGraph taskGraph;
        private final BuildIdentifier targetBuild;
        private final TaskInternal task;
        private IncludedBuildTaskResource.State state = IncludedBuildTaskResource.State.WAITING;

        TaskInAnotherBuild(TaskInternal task, BuildIdentifier thisBuild, IncludedBuildTaskGraph taskGraph) {
            this.thisBuild = thisBuild;
            this.task = task;
            this.taskGraph = taskGraph;
            this.targetBuild = ((BuildState)((ProjectInternal)task.getProject()).getServices().get(BuildState.class)).getBuildIdentifier();
            this.doNotRequire();
        }

        @Override
        public void collectTaskInto(ImmutableCollection.Builder<Task> builder) {
            builder.add((Object)this.task);
        }

        @Override
        public Throwable getWorkFailure() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void rethrowFailure() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void prepareForExecution() {
            this.taskGraph.addTask(this.thisBuild, this.targetBuild, this.task.getPath());
        }

        @Override
        public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<WorkInfo> processHardSuccessor) {
        }

        @Override
        public void require() {
        }

        @Override
        public boolean isSuccessful() {
            return this.state == IncludedBuildTaskResource.State.SUCCESS;
        }

        @Override
        public boolean isFailed() {
            return this.state == IncludedBuildTaskResource.State.FAILED;
        }

        @Override
        public boolean isComplete() {
            if (this.state != IncludedBuildTaskResource.State.WAITING) {
                return true;
            }
            this.state = this.taskGraph.getTaskState(this.targetBuild, this.task.getPath());
            return this.state != IncludedBuildTaskResource.State.WAITING;
        }

        @Override
        public int compareTo(WorkInfo other) {
            if (this.getClass() != other.getClass()) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            TaskInAnotherBuild taskInfo = (TaskInAnotherBuild)other;
            return this.task.getIdentityPath().compareTo(taskInfo.task.getIdentityPath());
        }

        @Override
        public String toString() {
            return this.task.getIdentityPath().toString();
        }
    }
}

