/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.file.BasicFileResolver;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.EnabledOnlyBooleanBuildOption;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.StringBuildOption;

public class BuildLayoutParametersBuildOptions {
    private static List<BuildOption<BuildLayoutParameters>> options;

    public static List<BuildOption<BuildLayoutParameters>> get() {
        return options;
    }

    private BuildLayoutParametersBuildOptions() {
    }

    static {
        ArrayList<Object> options = new ArrayList<Object>();
        options.add((Object)new GradleUserHomeOption());
        options.add((Object)new ProjectDirOption());
        options.add((Object)new NoSearchUpwardsOption());
        BuildLayoutParametersBuildOptions.options = Collections.unmodifiableList(options);
    }

    public static class NoSearchUpwardsOption
    extends EnabledOnlyBooleanBuildOption<BuildLayoutParameters> {
        private static final String LONG_OPTION = "no-search-upward";
        private static final String SHORT_OPTION = "u";

        public NoSearchUpwardsOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)SHORT_OPTION, (String)"Don't search in parent folders for a settings file.")});
        }

        public void applyTo(BuildLayoutParameters settings, Origin origin) {
            settings.setSearchUpwards(false);
            settings.addDeprecation(String.format("--%s/-%s", LONG_OPTION, SHORT_OPTION));
        }
    }

    public static class ProjectDirOption
    extends StringBuildOption<BuildLayoutParameters> {
        public ProjectDirOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"project-dir", (String)"p", (String)"Specifies the start directory for Gradle. Defaults to current directory.")});
        }

        public void applyTo(String value, BuildLayoutParameters settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setProjectDir((File)resolver.transform(value));
        }
    }

    public static class GradleUserHomeOption
    extends StringBuildOption<BuildLayoutParameters> {
        public GradleUserHomeOption() {
            super("gradle.user.home", new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"gradle-user-home", (String)"g", (String)"Specifies the gradle user home directory.")});
        }

        public void applyTo(String value, BuildLayoutParameters settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setGradleUserHomeDir((File)resolver.transform(value));
        }
    }
}

