/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;

public abstract class TransformingClassLoader
extends VisitableURLClassLoader {
    public TransformingClassLoader(ClassLoader parent, ClassPath classPath) {
        super(parent, classPath);
    }

    public TransformingClassLoader(ClassLoader parent, Collection<URL> urls) {
        super(parent, urls);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        CodeSource codeSource;
        byte[] bytes;
        if (!this.shouldTransform(name)) {
            return super.findClass(name);
        }
        String resourceName = name.replace('.', '/') + ".class";
        URL resource = this.findResource(resourceName);
        try {
            if (resource != null) {
                bytes = this.loadBytecode(resource);
                bytes = this.transform(name, bytes);
                URL codeBase = ClasspathUtil.getClasspathForResource(resource, resourceName).toURI().toURL();
                codeSource = new CodeSource(codeBase, (Certificate[])null);
            } else {
                bytes = this.generateMissingClass(name);
                codeSource = null;
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not load class '%s' from %s.", name, resource), e);
        }
        if (bytes == null) {
            throw new ClassNotFoundException(name);
        }
        String packageName = StringUtils.substringBeforeLast((String)name, (String)".");
        Package p = this.getPackage(packageName);
        if (p == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        return this.defineClass(name, bytes, 0, bytes.length, codeSource);
    }

    @Nullable
    protected byte[] generateMissingClass(String name) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadBytecode(URL resource) throws IOException {
        InputStream inputStream = resource.openStream();
        try {
            byte[] byArray = ByteStreams.toByteArray((InputStream)inputStream);
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    protected boolean shouldTransform(String className) {
        return true;
    }

    protected abstract byte[] transform(String var1, byte[] var2);

    static {
        try {
            ClassLoader.registerAsParallelCapable();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }
}

