/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.gradle.internal.Cast;

public class MethodDescription {
    private String owner;
    private String name;
    private String returnType;
    private Iterable<String> parameterTypes;

    public MethodDescription(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.returnType != null) {
            sb.append(this.returnType).append(" ");
        }
        if (this.owner != null) {
            sb.append(this.owner).append("#");
        }
        sb.append(this.name);
        if (this.parameterTypes != null) {
            sb.append("(");
            Joiner.on((String)", ").appendTo(sb, this.parameterTypes);
            sb.append(")");
        }
        return sb.toString();
    }

    public static MethodDescription name(String name) {
        return new MethodDescription(name);
    }

    public static MethodDescription of(Method method) {
        return MethodDescription.name(method.getName()).owner(method.getDeclaringClass()).returns(method.getGenericReturnType()).takes(method.getGenericParameterTypes());
    }

    public static MethodDescription of(Constructor<?> constructor) {
        return MethodDescription.name("<init>").owner(constructor.getDeclaringClass()).takes(constructor.getGenericParameterTypes());
    }

    private String typeName(Type type) {
        if (type == null) {
            return null;
        }
        return type instanceof Class ? Cast.cast(Class.class, type).getName() : type.toString();
    }

    public MethodDescription returns(Type returnType) {
        this.returnType = this.typeName(returnType);
        return this;
    }

    public MethodDescription owner(Class<?> owner) {
        this.owner = this.typeName(owner);
        return this;
    }

    public MethodDescription takes(Type[] parameterTypes) {
        this.parameterTypes = Iterables.transform(Arrays.asList(parameterTypes), (Function)new Function<Type, String>(){

            public String apply(Type input) {
                return MethodDescription.this.typeName(input);
            }
        });
        return this;
    }
}

