/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

class TreeTableModelAdapter
extends NodeTableModel {
    private JTree tree;
    private NodeTableModel nodeTableModel;

    public TreeTableModelAdapter(JTree jTree, NodeTableModel nodeTableModel) {
        this.tree = jTree;
        this.nodeTableModel = nodeTableModel;
        Listener listener = new Listener();
        this.tree.addTreeExpansionListener(listener);
        this.tree.getModel().addTreeModelListener(listener);
        this.nodeTableModel.addTableModelListener(listener);
    }

    @Override
    public void setNodes(Node[] nodeArray) {
        this.nodeTableModel.setNodes(nodeArray);
    }

    @Override
    public void setProperties(Node.Property[] propertyArray) {
        this.nodeTableModel.setProperties(propertyArray);
    }

    @Override
    protected Node.Property getPropertyFor(Node node, Node.Property property) {
        return this.nodeTableModel.getPropertyFor(node, property);
    }

    @Override
    Node nodeForRow(int n) {
        return Visualizer.findNode(this.tree.getPathForRow(n).getLastPathComponent());
    }

    @Override
    Node.Property propertyForColumn(int n) {
        return this.nodeTableModel.propertyForColumn(n - 1);
    }

    @Override
    public int getColumnCount() {
        return this.nodeTableModel.getColumnCount() + 1;
    }

    @Override
    public String getColumnName(int n) {
        return n == 0 ? Visualizer.findNode(this.tree.getModel().getRoot()).getDisplayName() : this.nodeTableModel.getColumnName(n - 1);
    }

    @Override
    public Class getColumnClass(int n) {
        return n == 0 ? TreeTableModelAdapter.class : this.nodeTableModel.getColumnClass(n - 1);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            TreePath treePath = this.tree.getPathForRow(n);
            if (treePath == null) {
                throw new IndexOutOfBoundsException("row " + n + " vs. count " + this.tree.getRowCount() + " with UI " + this.tree.getUI());
            }
            return treePath.getLastPathComponent();
        }
        return this.nodeTableModel.getPropertyFor(this.nodeForRow(n), this.propertyForColumn(n2));
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return true;
        }
        Object object = this.getValueAt(n, n2);
        if (object == null) {
            return false;
        }
        if (object instanceof Node.Property) {
            return ((Node.Property)object).canWrite();
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    class Listener
    implements TreeExpansionListener,
    TreeModelListener,
    TableModelListener,
    Runnable {
        TreePath[] tps = null;

        Listener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this.updateNodes();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            this.updateNodes();
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            this.delayedUpdateNodes(treeModelEvent);
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            this.delayedUpdateNodes(treeModelEvent);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.delayedUpdateNodes(treeModelEvent);
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            this.tps = TreeTableModelAdapter.this.tree.getSelectionPaths();
            if (treeModelEvent.getPath().length == 1 && !treeModelEvent.getTreePath().equals(treeModelEvent.getPath()[0])) {
                this.tps = null;
            }
            this.delayedUpdateNodes(treeModelEvent);
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getColumn();
            int n2 = n == -1 ? -1 : n + 1;
            TreeTableModelAdapter.this.fireTableChanged(new TableModelEvent(TreeTableModelAdapter.this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n2, tableModelEvent.getType()));
        }

        protected void delayedUpdateNodes(TreeModelEvent treeModelEvent) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            this.updateNodes();
        }

        private void updateNodes() {
            Node[] nodeArray = new Node[TreeTableModelAdapter.this.tree.getRowCount()];
            for (int i = 0; i < TreeTableModelAdapter.this.tree.getRowCount(); ++i) {
                nodeArray[i] = Visualizer.findNode(TreeTableModelAdapter.this.tree.getPathForRow(i).getLastPathComponent());
            }
            TreeTableModelAdapter.this.setNodes(nodeArray);
            if (this.tps != null) {
                TreeTableModelAdapter.this.tree.setSelectionPaths(this.tps);
                this.tps = null;
            }
        }
    }
}

