/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.plaf.synth.SynthTreeUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerRowSorter;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTableModel;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;

public class ProfilerTreeTable
extends ProfilerTable {
    private static final boolean DISABLE_TREEUI_FIX = Boolean.getBoolean("ProfilerTreeTable.disableTreeUIFix");
    private final TableModelImpl model = (TableModelImpl)this.getModel();
    private final ProfilerTreeTableTree tree = this.model.getTree();

    public ProfilerTreeTable(ProfilerTreeTableModel profilerTreeTableModel, boolean bl, boolean bl2, int[] nArray) {
        super(new TableModelImpl(profilerTreeTableModel), bl, bl2, nArray);
        Adapter adapter = new Adapter();
        this.tree.addTreeSelectionListener(adapter);
        this.tree.addTreeExpansionListener(adapter);
        this.tree.addTreeWillExpandListener(adapter);
        this.tree.getModel().addTreeModelListener(adapter);
        this.getSelectionModel().addListSelectionListener(adapter);
        this.tree.setRowHeight(this.rowHeight);
        this.setDefaultRenderer(JTree.class, this.tree);
    }

    TreePath getRootPath() {
        return new TreePath(this.model.treeModel.getRoot());
    }

    TreePath getSelectionPath() {
        return this.tree.getSelectionPath();
    }

    TreePath getNextPath(TreePath treePath) {
        return this.getNextPath(treePath, true);
    }

    TreePath getNextPath(TreePath treePath, boolean bl) {
        SortedFilteredTreeModel sortedFilteredTreeModel = this.model.treeModel;
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (bl && sortedFilteredTreeModel.getChildCount(treeNode) > 0) {
            return treePath.pathByAddingChild(sortedFilteredTreeModel.getChild(treeNode, 0));
        }
        TreePath treePath2 = treePath.getParentPath();
        if (!bl && treePath2 == null) {
            return treePath.pathByAddingChild(sortedFilteredTreeModel.getChild(treeNode, 0));
        }
        TreeNode treeNode2 = (TreeNode)treePath2.getLastPathComponent();
        int n = sortedFilteredTreeModel.getIndexOfChild(treeNode2, treeNode) + 1;
        if (sortedFilteredTreeModel.getChildCount(treeNode2) > n) {
            return treePath2.pathByAddingChild(sortedFilteredTreeModel.getChild(treeNode2, n));
        }
        if (!bl && treePath2.getParentPath() == null) {
            return treePath2.pathByAddingChild(sortedFilteredTreeModel.getChild(treeNode2, 0));
        }
        return this.getNextPath(treePath2, false);
    }

    TreePath getPreviousPath(TreePath treePath) {
        return this.getPreviousPath(treePath, true);
    }

    TreePath getPreviousPath(TreePath treePath, boolean bl) {
        TreeNode treeNode;
        int n;
        SortedFilteredTreeModel sortedFilteredTreeModel = this.model.treeModel;
        TreeNode treeNode2 = (TreeNode)treePath.getLastPathComponent();
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            treePath2 = treePath;
        }
        int n2 = n = (treeNode = (TreeNode)treePath2.getLastPathComponent()) == treeNode2 ? treeNode.getChildCount() : sortedFilteredTreeModel.getIndexOfChild(treeNode, treeNode2);
        if (n == 0) {
            if (treeNode != this.model.treeModel.getRoot()) {
                return treePath2;
            }
            n = treeNode.getChildCount();
        }
        treeNode2 = (TreeNode)sortedFilteredTreeModel.getChild(treeNode, n - 1);
        treePath = treePath2.pathByAddingChild(treeNode2);
        if (bl) {
            while (sortedFilteredTreeModel.getChildCount(treeNode2) != 0) {
                treeNode2 = (TreeNode)sortedFilteredTreeModel.getChild(treeNode2, sortedFilteredTreeModel.getChildCount(treeNode2) - 1);
                treePath = treePath.pathByAddingChild(treeNode2);
            }
        }
        return treePath;
    }

    public void selectPath(TreePath treePath, boolean bl) {
        Rectangle rectangle;
        this.internal = true;
        this.markExpansionTransaction();
        try {
            this.tree.setSelectionPath(treePath);
            this.tree.setSelectionPath(null);
            this.tree.setSelectionPath(treePath);
        }
        finally {
            this.clearExpansionTransaction();
            this.internal = false;
        }
        if (bl && (rectangle = this.tree.getPathBounds(treePath)) != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public TreePath getPathForRow(int n) {
        return this.tree.getPathForRow(n);
    }

    @Override
    public TreeNode getValueForRow(int n) {
        if (n == -1) {
            return null;
        }
        return this.model.nodeForRow(n);
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null) {
            this.tree.setRowHeight(n);
        }
    }

    public void setShowsRootHandles(boolean bl) {
        if (this.tree != null) {
            this.tree.setShowsRootHandles(bl);
        }
    }

    public boolean getShowsRootHandles() {
        return this.tree != null ? this.tree.getShowsRootHandles() : false;
    }

    public void setRootVisible(boolean bl) {
        if (this.tree != null) {
            this.tree.setRootVisible(bl);
        }
    }

    public boolean isRootVisible() {
        return this.tree != null ? this.tree.isRootVisible() : false;
    }

    private void markExpansionTransaction() {
        this.tree.putClientProperty("expansion_transaction", Boolean.TRUE);
    }

    private void clearExpansionTransaction() {
        this.tree.putClientProperty("expansion_transaction", null);
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        this.model.fireTableDataChanged();
        this.tree.setSelectionPaths(treePathArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collapseChildren(int n) {
        if (this.tree != null) {
            try {
                this.markExpansionTransaction();
                TreePath treePath = this.tree.getPathForRow(n);
                if (treePath == null || this.tree.isCollapsed(treePath)) {
                    return;
                }
                TreeModel treeModel = this.tree.getModel();
                Object object = treePath.getLastPathComponent();
                int n2 = treeModel.getChildCount(object);
                for (int i = 0; i < n2; ++i) {
                    this.tree.collapsePath(treePath.pathByAddingChild(treeModel.getChild(object, i)));
                }
            }
            finally {
                this.clearExpansionTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collapseChildren(TreePath treePath) {
        if (this.tree != null) {
            try {
                this.markExpansionTransaction();
                if (treePath == null || this.tree.isCollapsed(treePath)) {
                    return;
                }
                TreeModel treeModel = this.tree.getModel();
                Object object = treePath.getLastPathComponent();
                int n = treeModel.getChildCount(object);
                for (int i = 0; i < n; ++i) {
                    TreePath treePath2 = treePath.pathByAddingChild(treeModel.getChild(object, i));
                    this.tree.collapsePath(treePath2);
                }
            }
            finally {
                this.clearExpansionTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collapseAll() {
        if (this.tree != null) {
            try {
                this.markExpansionTransaction();
                TreePath treePath = this.tree.getSelectionPath();
                if (treePath != null && treePath.getPathCount() > 2) {
                    this.tree.setSelectionPath(new TreePath(new Object[]{treePath.getPathComponent(0), treePath.getPathComponent(1)}));
                }
                TreeModel treeModel = this.tree.getModel();
                Object object = treeModel.getRoot();
                int n = treeModel.getChildCount(object);
                for (int i = 0; i < n; ++i) {
                    this.tree.collapsePath(new TreePath(new Object[]{object, treeModel.getChild(object, i)}));
                }
                this.tree.resetExpandedNodes();
            }
            finally {
                this.clearExpansionTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandPlainPath(int n, int n2) {
        if (this.tree != null) {
            try {
                this.markExpansionTransaction();
                TreePath treePath = this.tree.getPathForRow(n);
                if (treePath == null) {
                    return;
                }
                TreeModel treeModel = this.tree.getModel();
                int n3 = treeModel.getChildCount(treePath.getLastPathComponent());
                while (n3 > 0 && n3 <= n2) {
                    treePath = treePath.pathByAddingChild(treeModel.getChild(treePath.getLastPathComponent(), 0));
                    n3 = treeModel.getChildCount(treePath.getLastPathComponent());
                }
                this.tree.putClientProperty("auto_expanding", Boolean.TRUE);
                try {
                    this.tree.expandPath(treePath);
                    this.selectPath(treePath, true);
                }
                finally {
                    this.tree.putClientProperty("auto_expanding", null);
                }
            }
            finally {
                this.clearExpansionTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandFirstPath(int n) {
        if (this.tree != null) {
            try {
                this.markExpansionTransaction();
                TreePath treePath = this.tree.getPathForRow(n);
                if (treePath == null) {
                    return;
                }
                TreeModel treeModel = this.tree.getModel();
                while (treeModel.getChildCount(treePath.getLastPathComponent()) > 0) {
                    treePath = treePath.pathByAddingChild(treeModel.getChild(treePath.getLastPathComponent(), 0));
                }
                this.tree.putClientProperty("auto_expanding", Boolean.TRUE);
                try {
                    this.selectPath(treePath, true);
                }
                finally {
                    this.tree.putClientProperty("auto_expanding", null);
                }
            }
            finally {
                this.clearExpansionTransaction();
            }
        }
    }

    public void expandPath(TreePath treePath) {
        if (this.tree != null) {
            try {
                this.markExpansionTransaction();
                this.tree.putClientProperty("auto_expanding", Boolean.TRUE);
                try {
                    this.tree.expandPath(treePath);
                }
                finally {
                    this.tree.putClientProperty("auto_expanding", null);
                }
            }
            finally {
                this.clearExpansionTransaction();
            }
        }
    }

    public void expandRow(int n) {
        if (this.tree != null) {
            try {
                this.markExpansionTransaction();
                this.tree.putClientProperty("auto_expanding", Boolean.TRUE);
                try {
                    this.tree.expandRow(n);
                }
                finally {
                    this.tree.putClientProperty("auto_expanding", null);
                }
            }
            finally {
                this.clearExpansionTransaction();
            }
        }
    }

    public void makeTreeAutoExpandable(int n) {
        if (this.tree != null) {
            UIUtils.makeTreeAutoExpandable((JTree)this.tree, n);
        }
    }

    protected void nodeExpanding(TreeNode treeNode) {
    }

    protected void nodeExpanded(TreeNode treeNode) {
    }

    protected void nodeCollapsing(TreeNode treeNode) {
    }

    protected void nodeCollapsed(TreeNode treeNode) {
    }

    public void setForgetPreviouslyExpanded(boolean bl) {
        this.tree.setForgetPreviouslyExpanded(bl);
    }

    public Enumeration<TreePath> getExpandedNodes() {
        return this.tree == null ? null : this.tree.getExpandedDescendants(new TreePath(this.tree.getModel().getRoot()));
    }

    public void clearExpandedNodes(Enumeration<TreePath> enumeration) {
        if (this.tree != null) {
            this.tree.removeDescendantToggledPaths(enumeration);
            this.tree.updateUI();
        }
    }

    public void resetExpandedNodes() {
        if (this.tree != null) {
            this.tree.resetExpandedNodes();
        }
    }

    public void resetPath(TreePath treePath) {
        if (this.tree != null) {
            ((SortedFilteredTreeModel)this.tree.getModel()).clearPath(treePath);
        }
    }

    public DefaultTreeModel getTreeModel() {
        return this.tree == null ? null : (DefaultTreeModel)this.tree.getModel();
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        if (this.tree != null) {
            this.tree.setCellRenderer(treeCellRenderer);
            this.model.setRenderer(treeCellRenderer);
        }
    }

    public void setTreeCellRenderer(ProfilerRenderer profilerRenderer) {
        this.setCellRenderer(ProfilerTreeTable.createTreeCellRenderer(profilerRenderer));
    }

    public static TreeCellRenderer createTreeCellRenderer(ProfilerRenderer profilerRenderer) {
        return new ProfilerRendererWrapper(profilerRenderer);
    }

    @Override
    Component getRenderer(TableCellRenderer tableCellRenderer, int n, int n2, boolean bl) {
        Component component = super.getRenderer(tableCellRenderer, n, n2, bl);
        if (bl && JTree.class.equals(this.getColumnClass(n2))) {
            Rectangle rectangle = this.tree.getRowBounds(n);
            component.setBounds(rectangle.x, 0, rectangle.width, component.getHeight());
        }
        return component;
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        this.tree.dispatchEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n;
        Rectangle rectangle;
        Point point;
        int n2;
        MouseEvent mouseEvent2 = null;
        if (mouseEvent != null && (n2 = this.columnAtPoint(point = mouseEvent.getPoint())) != -1 && this.getColumnClass(n2) == JTree.class && (rectangle = this.tree.getRowBounds(n = this.rowAtPoint(point))) != null) {
            Rectangle rectangle2 = this.getCellRect(n, n2, true);
            int n3 = this.convertColumnIndexToModel(n2);
            int n4 = point.x - rectangle2.x + this.getColumnOffset(n3);
            if (n4 > rectangle.x) {
                n4 = rectangle.x + rectangle.width / 2;
            }
            mouseEvent2 = new MouseEvent(this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n4, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            TreeNode treeNode = this.getValueForRow(n);
            if (treeNode instanceof TreeNode && !treeNode.isLeaf()) {
                mouseEvent = ProfilerTreeTable.clearClicks(mouseEvent);
            }
        }
        super.processMouseEvent(mouseEvent);
        if (mouseEvent2 != null) {
            this.tree.dispatchEvent(mouseEvent2);
        }
    }

    @Override
    public void addRowFilter(RowFilter rowFilter) {
        super.addRowFilter(rowFilter);
        this.refreshFilter();
    }

    @Override
    public void removeRowFilter(RowFilter rowFilter) {
        super.removeRowFilter(rowFilter);
        this.refreshFilter();
    }

    @Override
    public void setRowFilter(RowFilter rowFilter) {
        super.setRowFilter(rowFilter);
        this.refreshFilter();
    }

    private void refreshFilter() {
        this.model.filter(this._getRowSorter().getRowFilter());
    }

    public Comparator getCurrentComparator() {
        return this.model.getComparator();
    }

    public String getStringValue(TreeNode treeNode, int n) {
        Object object = this.model.getValueAt(treeNode, this.convertColumnIndexToModel(n));
        if (this.getColumnClass(n) == JTree.class) {
            TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
            treeCellRenderer.getTreeCellRendererComponent(this.tree, object, false, false, false, -1, false);
            return treeCellRenderer.toString();
        }
        TableCellRenderer tableCellRenderer = this.getCellRenderer(-1, n);
        if (tableCellRenderer instanceof ProfilerRenderer) {
            ((ProfilerRenderer)((Object)tableCellRenderer)).setValue(object, -1);
        } else {
            tableCellRenderer.getTableCellRendererComponent(this, object, false, false, -1, n);
        }
        return tableCellRenderer.toString();
    }

    @Override
    protected TableRowSorter createRowSorter() {
        ProfilerTreeTableSorter profilerTreeTableSorter = new ProfilerTreeTableSorter(this.getModel()){

            @Override
            public void allRowsChanged() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfilerTreeTable.this.updateColumnsPreferredWidth();
                    }
                });
            }

            @Override
            protected void setSortKeysImpl(List list) {
                ProfilerTreeTable.this.willBeSorted(Collections.unmodifiableList(list));
                super.setSortKeysImpl(list);
            }
        };
        profilerTreeTableSorter.setDefaultSortOrder(SortOrder.DESCENDING);
        profilerTreeTableSorter.setDefaultSortOrder(0, SortOrder.ASCENDING);
        return profilerTreeTableSorter;
    }

    protected void willBeSorted(List<? extends RowSorter.SortKey> list) {
    }

    @Override
    protected void saveSelection() {
    }

    @Override
    protected void restoreSelection() {
    }

    static UIState getUIState(JTree jTree) {
        TreePath[] treePathArray = jTree.getSelectionPaths();
        TreePath treePath = new TreePath(jTree.getModel().getRoot());
        Enumeration<TreePath> enumeration = jTree.getExpandedDescendants(treePath);
        return new UIState(treePathArray, enumeration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void restoreExpandedNodes(JTree jTree, UIState uIState) {
        try {
            jTree.putClientProperty("expansion_transaction", Boolean.TRUE);
            Enumeration enumeration = uIState.getExpandedPaths();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    TreePath treePath = (TreePath)enumeration.nextElement();
                    jTree.expandPath(ProfilerTreeTable.getSimilarPath(treePath, jTree.getModel()));
                }
            }
        }
        catch (Exception exception) {
            System.err.println(">>> Exception in ProfilerTreeTable.restoreExpandedNodes: " + exception.getMessage());
            exception.printStackTrace();
        }
        finally {
            jTree.putClientProperty("expansion_transaction", null);
        }
    }

    static void restoreSelectedNodes(JTree jTree, UIState uIState) {
        try {
            TreePath[] treePathArray = uIState.getSelectedPaths();
            if (treePathArray != null) {
                for (int i = 0; i < treePathArray.length; ++i) {
                    treePathArray[i] = ProfilerTreeTable.getSimilarPath(treePathArray[i], jTree.getModel());
                }
            }
            jTree.setSelectionPaths(treePathArray);
        }
        catch (Exception exception) {
            System.err.println(">>> Exception in ProfilerTreeTable.restoreSelectedNodes: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    protected UIState getUIState() {
        return this.tree == null ? null : ProfilerTreeTable.getUIState(this.tree);
    }

    protected void restoreExpandedNodes(UIState uIState) {
        if (this.tree != null) {
            ProfilerTreeTable.restoreExpandedNodes(this.tree, uIState);
        }
    }

    protected void restoreSelectedNodes(UIState uIState) {
        if (this.tree != null) {
            ProfilerTreeTable.restoreSelectedNodes(this.tree, uIState);
        }
    }

    private static TreePath getSimilarPath(TreePath treePath, TreeModel treeModel) {
        if (treePath == null || treePath.getPathCount() < 1) {
            return null;
        }
        Object object = treeModel.getRoot();
        if (!object.equals(treePath.getPathComponent(0))) {
            return null;
        }
        TreePath treePath2 = new TreePath(object);
        Object[] objectArray = treePath.getPath();
        Object object2 = object;
        for (int i = 1; i < objectArray.length; ++i) {
            Object object3 = null;
            for (int j = 0; j < treeModel.getChildCount(object2); ++j) {
                Object object4 = treeModel.getChild(object2, j);
                if (!object4.equals(objectArray[i])) continue;
                object3 = object4;
                break;
            }
            if (object3 == null) {
                return null;
            }
            object2 = object3;
            treePath2 = treePath2.pathByAddingChild(object2);
        }
        return treePath2;
    }

    private static class SynthLikeTreeUI
    extends BasicTreeUI {
        private static final Icon[] ICONS = new Icon[4];
        private boolean isSelected;

        private SynthLikeTreeUI() {
        }

        void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        @Override
        public Icon getExpandedIcon() {
            return this.isSelected ? ICONS[1] : ICONS[0];
        }

        @Override
        public Icon getCollapsedIcon() {
            return this.isSelected ? ICONS[3] : ICONS[2];
        }

        @Override
        protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        }

        @Override
        protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        }

        static {
            final BufferedImage[] bufferedImageArray = new BufferedImage[1];
            BufferedImage bufferedImage = new BufferedImage(50, 50, 2);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
            defaultMutableTreeNode.add(new DefaultMutableTreeNode());
            JTree jTree = new JTree(defaultMutableTreeNode);
            jTree.setRootVisible(true);
            jTree.setShowsRootHandles(true);
            jTree.setSize(50, 50);
            jTree.setUI(new SynthTreeUI(){

                @Override
                protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
                    int n3 = icon.getIconWidth();
                    int n4 = icon.getIconHeight();
                    bufferedImageArray[0] = new BufferedImage(n3, n4, 2);
                    super.drawCentered(component, bufferedImageArray[0].getGraphics(), icon, n3 / 2, n4 / 2);
                }
            });
            jTree.expandRow(0);
            jTree.clearSelection();
            jTree.paint(bufferedImage.getGraphics());
            SynthLikeTreeUI.ICONS[0] = new ImageIcon(bufferedImageArray[0]);
            jTree.expandRow(0);
            jTree.setSelectionRow(0);
            jTree.paint(bufferedImage.getGraphics());
            SynthLikeTreeUI.ICONS[1] = new ImageIcon(bufferedImageArray[0]);
            jTree.collapseRow(0);
            jTree.clearSelection();
            jTree.paint(bufferedImage.getGraphics());
            SynthLikeTreeUI.ICONS[2] = new ImageIcon(bufferedImageArray[0]);
            jTree.collapseRow(0);
            jTree.setSelectionRow(0);
            jTree.paint(bufferedImage.getGraphics());
            SynthLikeTreeUI.ICONS[3] = new ImageIcon(bufferedImageArray[0]);
        }
    }

    private static class ProfilerTreeTableTree
    extends JTree
    implements TableCellRenderer,
    Accessible {
        private int currentX;
        private int currentWidth;
        private int currentRowOffset;
        private boolean currentFirst;
        private boolean currentFocused;
        private boolean currentSelected;
        private boolean customRendering;
        private SynthLikeTreeUI synthLikeUI;
        private boolean workaroundVerticalLines;
        private boolean forgetPreviouslyExpanded;
        private final Dimension prefSize = new Dimension();
        private boolean changingModel;

        ProfilerTreeTableTree(SortedFilteredTreeModel sortedFilteredTreeModel) {
            super(sortedFilteredTreeModel);
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.getSelectionModel().setSelectionMode(1);
            this.setCellRenderer(new ProfilerRendererWrapper(new LabelRenderer()));
            this.setLargeModel(true);
        }

        @Override
        public void setUI(TreeUI treeUI) {
            if (treeUI instanceof SynthTreeUI) {
                super.setUI(treeUI);
                SynthTreeUI synthTreeUI = (SynthTreeUI)treeUI;
                int n = synthTreeUI.getLeftChildIndent();
                int n2 = synthTreeUI.getRightChildIndent();
                this.synthLikeUI = new SynthLikeTreeUI();
                super.setUI(this.synthLikeUI);
                boolean bl = UIUtils.isNimbusLookAndFeel();
                this.synthLikeUI.setLeftChildIndent(n + (bl ? 4 : 6));
                this.synthLikeUI.setRightChildIndent(n2);
            } else {
                this.synthLikeUI = null;
                super.setUI(treeUI);
                if (!DISABLE_TREEUI_FIX && treeUI instanceof BasicTreeUI) {
                    this.workaroundVerticalLines = UIManager.getBoolean("Tree.paintLines");
                }
            }
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public boolean hasFocus() {
            return this.currentFocused;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ProfilerTable profilerTable = (ProfilerTable)jTable;
            this.currentRowOffset = n * this.rowHeight;
            this.currentFirst = n2 == 0 || this.isFirstColumn(jTable.getColumnModel(), n2);
            this.currentFocused = !profilerTable.shadesUnfocusedSelection() || bl2 || jTable.hasFocus();
            this.currentSelected = bl;
            Rectangle rectangle = this.getRowBounds(n);
            if (rectangle == null) {
                this.currentX = 0;
                this.currentWidth = 0;
            } else {
                this.currentX = rectangle.x;
                this.currentWidth = rectangle.width;
            }
            this.customRendering = profilerTable.isCustomRendering();
            if (this.synthLikeUI != null) {
                this.synthLikeUI.setSelected(bl);
            }
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            this.prefSize.setSize(this.currentX + this.currentWidth, this.rowHeight);
            return this.prefSize;
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(this.getBackground());
            int n = this.currentSelected || this.customRendering || !this.currentFirst ? 0 : this.currentX;
            graphics.fillRect(n, 0, this.getWidth() - n, this.rowHeight);
            graphics.translate(this.customRendering ? -this.currentX : 0, -this.currentRowOffset);
            if (this.workaroundVerticalLines && !this.rootVisible && this.currentRowOffset > 0) {
                this.rootVisible = true;
                super.paint(graphics);
                this.rootVisible = false;
            } else {
                super.paint(graphics);
            }
        }

        private boolean isFirstColumn(TableColumnModel tableColumnModel, int n) {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 += tableColumnModel.getColumn(i).getWidth();
            }
            return n2 == 0;
        }

        @Override
        public void setAnchorSelectionPath(TreePath treePath) {
        }

        void setForgetPreviouslyExpanded(boolean bl) {
            this.forgetPreviouslyExpanded = bl;
        }

        @Override
        public boolean hasBeenExpanded(TreePath treePath) {
            return this.forgetPreviouslyExpanded ? false : super.hasBeenExpanded(treePath);
        }

        @Override
        public void fireTreeCollapsed(TreePath treePath) {
            super.fireTreeCollapsed(treePath);
            if (this.forgetPreviouslyExpanded) {
                super.removeDescendantToggledPaths(Collections.enumeration(Collections.singletonList(treePath)));
                ((SortedFilteredTreeModel)this.getModel()).clearPath(treePath);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfilerTreeTableTree.this.updateUI();
                    }
                });
            }
        }

        @Override
        protected void removeDescendantToggledPaths(Enumeration<TreePath> enumeration) {
            super.removeDescendantToggledPaths(enumeration);
        }

        void resetExpandedNodes() {
            this.clearToggledPaths();
            this.updateUI();
        }

        @Override
        public Enumeration<TreePath> getExpandedDescendants(TreePath treePath) {
            return Boolean.TRUE.equals(this.getClientProperty("auto_expanding")) ? null : super.getExpandedDescendants(treePath);
        }

        @Override
        public void expandPath(TreePath treePath) {
            if (this.changingModel) {
                treePath = this.getSimilarPath(treePath);
            }
            super.expandPath(treePath);
        }

        @Override
        public void setSelectionPath(TreePath treePath) {
            if (this.changingModel) {
                treePath = this.getSimilarPath(treePath);
            }
            super.setSelectionPath(treePath);
        }

        @Override
        public void setSelectionPaths(TreePath[] treePathArray) {
            if (this.changingModel && treePathArray != null) {
                ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
                for (int i = 0; i < treePathArray.length; ++i) {
                    TreePath treePath = this.getSimilarPath(treePathArray[i]);
                    if (treePath == null) continue;
                    arrayList.add(treePath);
                }
                super.setSelectionPaths(arrayList.toArray(new TreePath[0]));
            } else {
                super.setSelectionPaths(treePathArray);
            }
        }

        private TreePath getSimilarPath(TreePath treePath) {
            if (treePath == null || treePath.getPathCount() < 1) {
                return null;
            }
            TreeModel treeModel = this.getModel();
            Object object = treeModel.getRoot();
            if (!object.equals(treePath.getPathComponent(0))) {
                return null;
            }
            TreePath treePath2 = new TreePath(object);
            Object[] objectArray = treePath.getPath();
            Object object2 = object;
            for (int i = 1; i < objectArray.length; ++i) {
                Object object3 = null;
                for (int j = 0; j < treeModel.getChildCount(object2); ++j) {
                    Object object4 = treeModel.getChild(object2, j);
                    if (!object4.equals(objectArray[i])) continue;
                    object3 = object4;
                    break;
                }
                if (object3 == null) {
                    return null;
                }
                object2 = object3;
                treePath2 = treePath2.pathByAddingChild(object2);
            }
            return treePath2;
        }

        private void setChangingModel(boolean bl) {
            this.changingModel = bl;
        }

        boolean isChangingModel() {
            return this.changingModel;
        }

        @Override
        public String toString() {
            return this.getCellRenderer().toString();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            return treeCellRenderer instanceof Accessible ? ((Accessible)((Object)treeCellRenderer)).getAccessibleContext() : new JComponent.AccessibleJComponent(){};
        }
    }

    private class Adapter
    implements TreeModelListener,
    TreeExpansionListener,
    TreeWillExpandListener,
    TreeSelectionListener,
    ListSelectionListener {
        private boolean internal;

        private Adapter() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this.notifyTable();
            Object object = treeExpansionEvent.getPath().getLastPathComponent();
            if (object instanceof TreeNode) {
                ProfilerTreeTable.this.nodeExpanded((TreeNode)object);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            this.notifyTable();
            Object object = treeExpansionEvent.getPath().getLastPathComponent();
            if (object instanceof TreeNode) {
                ProfilerTreeTable.this.nodeCollapsed((TreeNode)object);
            }
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            Object object = treeExpansionEvent.getPath().getLastPathComponent();
            if (object instanceof TreeNode) {
                ProfilerTreeTable.this.nodeExpanding((TreeNode)object);
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            Object object = treeExpansionEvent.getPath().getLastPathComponent();
            if (object instanceof TreeNode) {
                ProfilerTreeTable.this.nodeCollapsing((TreeNode)object);
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            this.notifyTable();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            this.notifyTable();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.notifyTable();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            ProfilerTreeTable.this.tree.setChangingModel(true);
            try {
                this.notifyTable();
            }
            finally {
                ProfilerTreeTable.this.tree.setChangingModel(false);
            }
        }

        private void notifyTable() {
            if (ProfilerTreeTable.this.tree.isChangingModel()) {
                return;
            }
            if (ProfilerTreeTable.this.tree.getClientProperty("expansion_transaction") != null) {
                return;
            }
            TreePath[] treePathArray = ProfilerTreeTable.this.tree.getSelectionPaths();
            ProfilerTreeTable.this.model.fireTableDataChanged();
            ProfilerTreeTable.this.tree.setSelectionPaths(treePathArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (this.internal) {
                return;
            }
            TreePath treePath = treeSelectionEvent.getPath();
            if (!Objects.equals(treePath, ProfilerTreeTable.this.tree.getSelectionPath())) {
                return;
            }
            int n = treePath == null ? -1 : ProfilerTreeTable.this.tree.getRowForPath(treePath);
            try {
                this.internal = true;
                if (n != -1) {
                    ProfilerTreeTable.this.selectRow(n, !ProfilerTreeTable.this.tree.isChangingModel());
                } else {
                    ProfilerTreeTable.this.clearSelection();
                }
            }
            finally {
                this.internal = false;
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.internal) {
                return;
            }
            int n = ProfilerTreeTable.this.getSelectedRow();
            try {
                this.internal = true;
                if (n != -1) {
                    ProfilerTreeTable.this.tree.setSelectionRow(n);
                } else {
                    ProfilerTreeTable.this.tree.clearSelection();
                }
                ProfilerTreeTable.this.repaint();
            }
            finally {
                this.internal = false;
            }
        }
    }

    protected static class UIState {
        private final TreePath[] selectedPaths;
        private final Enumeration<TreePath> expandedPaths;

        UIState(TreePath[] treePathArray, Enumeration<TreePath> enumeration) {
            this.selectedPaths = treePathArray;
            this.expandedPaths = enumeration;
        }

        public TreePath[] getSelectedPaths() {
            return this.selectedPaths;
        }

        public Enumeration getExpandedPaths() {
            return this.expandedPaths;
        }
    }

    private static final class TreePathKey {
        private final TreeNode[] pathToRoot;
        private int hashCode;

        TreePathKey(TreeNode[] treeNodeArray) {
            this.pathToRoot = treeNodeArray;
            this.hashCode = 1;
            for (TreeNode treeNode : this.pathToRoot) {
                this.hashCode = 31 * this.hashCode + treeNode.hashCode();
            }
        }

        public final int hashCode() {
            return this.hashCode;
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof TreePathKey)) {
                return false;
            }
            TreeNode[] treeNodeArray = ((TreePathKey)object).pathToRoot;
            if (this.pathToRoot.length != treeNodeArray.length) {
                return false;
            }
            for (int i = this.pathToRoot.length - 1; i >= 0; --i) {
                if (this.pathToRoot[i].equals(treeNodeArray[i])) continue;
                return false;
            }
            return true;
        }
    }

    private static class SortedFilteredTreeModel
    extends FilteredTreeModel {
        private Comparator comparator;
        private Map<TreePathKey, int[]> viewToModel;

        SortedFilteredTreeModel(TreeNode treeNode, TreeCellRenderer treeCellRenderer, Comparator comparator, RowFilter rowFilter) {
            super(treeNode, treeCellRenderer, rowFilter);
            this.comparator = comparator;
        }

        void setComparator(Comparator comparator) {
            this.comparator = comparator;
            this.reload();
        }

        Comparator getComparator() {
            return this.comparator;
        }

        @Override
        public Object getChild(Object object, int n) {
            if (this.comparator == null) {
                return super.getChild(object, n);
            }
            return super.getChild(object, this.viewToModel(object)[n]);
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            if (this.comparator == null) {
                return super.getIndexOfChild(object, object2);
            }
            int n = super.getIndexOfChild(object, object2);
            int[] nArray = this.viewToModel(object);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                return i;
            }
            return -1;
        }

        @Override
        protected void clearKey(TreePathKey treePathKey) {
            super.clearKey(treePathKey);
            this.viewToModel = null;
        }

        @Override
        protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            this.viewToModel = null;
            super.fireTreeStructureChanged(object, objectArray, nArray, objectArray2);
        }

        private int[] viewToModel(Object object) {
            TreePathKey treePathKey;
            int[] nArray;
            if (this.viewToModel == null) {
                this.viewToModel = new HashMap<TreePathKey, int[]>();
            }
            if ((nArray = this.viewToModel.get(treePathKey = new TreePathKey(this.getPathToRoot((TreeNode)object)))) == null) {
                int n;
                Object[] objectArray = new Object[super.getChildCount(object)];
                for (n = 0; n < objectArray.length; ++n) {
                    objectArray[n] = super.getChild(object, n);
                }
                Arrays.sort(objectArray, this.comparator);
                nArray = new int[objectArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = super.getIndexOfChild(object, objectArray[n]);
                }
                this.viewToModel.put(treePathKey, nArray);
            }
            return nArray;
        }
    }

    private static final class FilterEntry
    extends RowFilter.Entry {
        private Object value;
        private Object identifier;

        FilterEntry(Object object, Object object2) {
            this.value = object;
            this.identifier = object2;
        }

        void setContext(Object object, Object object2) {
            this.value = object;
            this.identifier = object2;
        }

        @Override
        public Object getValue(int n) {
            return this.value;
        }

        public Object getModel() {
            return null;
        }

        @Override
        public int getValueCount() {
            return 1;
        }

        public Object getIdentifier() {
            return this.identifier;
        }
    }

    private static class FilteredTreeModel
    extends DefaultTreeModel {
        private TreeCellRenderer renderer;
        private RowFilter filter;
        private Map<TreePathKey, List> cache;

        FilteredTreeModel(TreeNode treeNode, TreeCellRenderer treeCellRenderer, RowFilter rowFilter) {
            super(treeNode);
            this.renderer = treeCellRenderer;
            this.filter = rowFilter;
        }

        void setRenderer(TreeCellRenderer treeCellRenderer) {
            this.renderer = treeCellRenderer;
            this.reload();
        }

        TreeCellRenderer getRenderer() {
            return this.renderer;
        }

        void setFilter(RowFilter rowFilter) {
            this.filter = rowFilter;
            this.reload();
        }

        RowFilter getFilter() {
            return this.filter;
        }

        @Override
        public Object getChild(Object object, int n) {
            if (this.renderer == null || this.filter == null) {
                return super.getChild(object, n);
            }
            return this.filteredChildren(object).get(n);
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            if (this.renderer == null || this.filter == null) {
                return super.getIndexOfChild(object, object2);
            }
            return this.filteredChildren(object).indexOf(object2);
        }

        @Override
        public int getChildCount(Object object) {
            if (this.renderer == null || this.filter == null) {
                return super.getChildCount(object);
            }
            return this.filteredChildren(object).size();
        }

        void clearPath(TreePath treePath) {
            this.clearKey(null);
        }

        protected void clearKey(TreePathKey treePathKey) {
            this.cache = null;
        }

        @Override
        protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            this.cache = null;
            super.fireTreeStructureChanged(object, objectArray, nArray, objectArray2);
        }

        private List filteredChildren(Object object) {
            TreeNode treeNode;
            TreePathKey treePathKey;
            ArrayList<Object> arrayList;
            if (this.cache == null) {
                this.cache = new HashMap<TreePathKey, List>();
            }
            if ((arrayList = this.cache.get(treePathKey = new TreePathKey(this.getPathToRoot(treeNode = (TreeNode)object)))) == null) {
                Object object2;
                FilterEntry filterEntry = null;
                arrayList = new ArrayList<Object>(treeNode.getChildCount());
                CCTNode cCTNode = null;
                Enumeration<? extends TreeNode> enumeration = treeNode.children();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        object2 = enumeration.nextElement();
                        this.renderer.getTreeCellRendererComponent(null, object2, false, false, false, -1, false);
                        if (filterEntry == null) {
                            filterEntry = new FilterEntry(this.renderer.toString(), object2);
                        } else {
                            filterEntry.setContext(this.renderer.toString(), object2);
                        }
                        if (this.filter.include(filterEntry)) {
                            arrayList.add(object2);
                            continue;
                        }
                        if (!(object instanceof CCTNode)) continue;
                        if (cCTNode == null) {
                            cCTNode = ((CCTNode)object2).createFilteredNode();
                            continue;
                        }
                        cCTNode.merge((CCTNode)object2);
                    }
                }
                if (cCTNode != null) {
                    object2 = this.filteredChildren(cCTNode);
                    if (!((CCTNode)object).isFiltered()) {
                        arrayList.add(cCTNode);
                    } else if (!arrayList.isEmpty()) {
                        arrayList.add(cCTNode);
                    } else {
                        arrayList.addAll((Collection<Object>)object2);
                    }
                }
                this.cache.put(treePathKey, arrayList);
            }
            return arrayList;
        }
    }

    private static class TableModelImpl
    extends AbstractTableModel {
        private final ProfilerTreeTableTree tree;
        private SortedFilteredTreeModel treeModel;
        private final ProfilerTreeTableModel treeTableModel;

        TableModelImpl(ProfilerTreeTableModel profilerTreeTableModel) {
            this.treeTableModel = profilerTreeTableModel;
            this.treeModel = this.treeModelImpl(profilerTreeTableModel.getRoot(), null, null);
            profilerTreeTableModel.addListener(new ProfilerTreeTableModel.Adapter(){

                @Override
                public void dataChanged() {
                    TableModelImpl.this.fireTableDataChanged();
                }

                @Override
                public void structureChanged() {
                    TableModelImpl.this.treeModel.reload();
                }

                @Override
                public void childrenChanged(TreeNode treeNode) {
                    TableModelImpl.this.treeModel.reload(treeNode);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void rootChanged(TreeNode treeNode, TreeNode treeNode2) {
                    TableModelImpl.this.tree.setChangingModel(true);
                    try {
                        UIState uIState = ProfilerTreeTable.getUIState(TableModelImpl.this.tree);
                        Comparator comparator = TableModelImpl.this.treeModel != null ? TableModelImpl.this.treeModel.getComparator() : null;
                        RowFilter rowFilter = TableModelImpl.this.treeModel != null ? TableModelImpl.this.treeModel.getFilter() : null;
                        TableModelImpl.this.treeModel = TableModelImpl.this.treeModelImpl(treeNode2, comparator, rowFilter);
                        TableModelImpl.this.tree.setModel(TableModelImpl.this.treeModel);
                        if (uIState != null) {
                            ProfilerTreeTable.restoreExpandedNodes(TableModelImpl.this.tree, uIState);
                        }
                        TableModelImpl.this.fireTableDataChanged();
                        if (uIState != null) {
                            ProfilerTreeTable.restoreSelectedNodes(TableModelImpl.this.tree, uIState);
                        }
                    }
                    finally {
                        TableModelImpl.this.tree.setChangingModel(false);
                    }
                }
            });
            this.tree = new ProfilerTreeTableTree(this.treeModel);
        }

        private SortedFilteredTreeModel treeModelImpl(TreeNode treeNode, Comparator comparator, RowFilter rowFilter) {
            return new SortedFilteredTreeModel(treeNode, this.tree == null ? null : this.tree.getCellRenderer(), comparator, rowFilter){

                @Override
                protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
                    UIState uIState = TableModelImpl.this.tree == null ? null : ProfilerTreeTable.getUIState(TableModelImpl.this.tree);
                    super.fireTreeStructureChanged(object, objectArray, nArray, objectArray2);
                    if (uIState != null) {
                        ProfilerTreeTable.restoreExpandedNodes(TableModelImpl.this.tree, uIState);
                    }
                    TableModelImpl.this.fireTableDataChanged();
                    if (uIState != null) {
                        ProfilerTreeTable.restoreSelectedNodes(TableModelImpl.this.tree, uIState);
                    }
                }
            };
        }

        void sort(Comparator comparator) {
            this.treeModel.setComparator(comparator);
        }

        Comparator getComparator() {
            return this.treeModel.getComparator();
        }

        void filter(RowFilter rowFilter) {
            this.treeModel.setFilter(rowFilter);
        }

        RowFilter getFilter() {
            return this.treeModel.getFilter();
        }

        void setRenderer(TreeCellRenderer treeCellRenderer) {
            this.treeModel.setRenderer(treeCellRenderer);
        }

        ProfilerTreeTableTree getTree() {
            return this.tree;
        }

        TreeNode nodeForRow(int n) {
            TreePath treePath = this.tree.getPathForRow(n);
            return treePath == null ? null : (TreeNode)treePath.getLastPathComponent();
        }

        @Override
        public int getRowCount() {
            return this.tree.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.treeTableModel.getColumnCount();
        }

        @Override
        public String getColumnName(int n) {
            return this.treeTableModel.getColumnName(n);
        }

        public Class getColumnClass(int n) {
            return this.treeTableModel.getColumnClass(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            TreeNode treeNode = this.nodeForRow(n);
            return treeNode == null ? false : this.treeTableModel.isCellEditable(treeNode, n2);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TreeNode treeNode = this.nodeForRow(n);
            return treeNode == null ? null : this.treeTableModel.getValueAt(treeNode, n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            TreeNode treeNode = this.nodeForRow(n);
            if (treeNode != null) {
                this.treeTableModel.setValueAt(object, treeNode, n2);
            }
        }

        Object getValueAt(TreeNode treeNode, int n) {
            return this.treeTableModel.getValueAt(treeNode, n);
        }
    }

    private static class ProfilerTreeTableSorter
    extends ProfilerRowSorter {
        private final TableModelImpl model;
        private List<RowSorter.SortKey> sortKeys;
        private boolean sorting;

        ProfilerTreeTableSorter(TableModel tableModel) {
            super(tableModel);
            this.model = (TableModelImpl)tableModel;
        }

        @Override
        public int convertRowIndexToModel(int n) {
            return n;
        }

        @Override
        public int convertRowIndexToView(int n) {
            return n;
        }

        @Override
        public int getViewRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public int getModelRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public void sort() {
            this.sorting = true;
            super.sort();
            this.sorting = false;
        }

        @Override
        public RowFilter getRowFilter() {
            return this.sorting ? null : super.getRowFilter();
        }

        @Override
        protected void setSortKeysImpl(List list) {
            this.sortKeys = list == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(list));
            this.model.sort(this.createComparator(list));
        }

        @Override
        public List<? extends RowSorter.SortKey> getSortKeys() {
            return this.sortKeys;
        }

        protected Comparator createComparator(List<RowSorter.SortKey> list) {
            if (list == null || list.isEmpty()) {
                return null;
            }
            RowSorter.SortKey sortKey = list.get(0);
            SortOrder sortOrder = sortKey.getSortOrder();
            if (SortOrder.UNSORTED.equals((Object)sortOrder)) {
                return null;
            }
            final boolean bl = SortOrder.ASCENDING.equals((Object)sortOrder);
            final int n = sortKey.getColumn();
            Class clazz = this.model.getColumnClass(n);
            final Comparator comparator = JTree.class.equals((Object)clazz) ? null : (Comparable.class.isAssignableFrom(clazz) ? new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((Comparable)object).compareTo(object2);
                }
            } : this.getComparator(n));
            return new Comparator(){

                public int compare(Object object, Object object2) {
                    int n2;
                    if (object instanceof CCTNode.FixedPosition) {
                        n2 = object instanceof CCTNode.AlwaysFirst ? -1 : 1;
                        n2 = bl ? n2 : -n2;
                    } else if (object2 instanceof CCTNode.FixedPosition) {
                        n2 = object2 instanceof CCTNode.AlwaysFirst ? 1 : -1;
                        n2 = bl ? n2 : -n2;
                    } else {
                        Object object3;
                        Object object4;
                        n2 = comparator == null ? object.toString().compareTo(object2.toString()) : ((object4 = ProfilerTreeTableSorter.this.model.getValueAt((TreeNode)object, n)) == (object3 = ProfilerTreeTableSorter.this.model.getValueAt((TreeNode)object2, n)) ? 0 : (object4 == null ? -1 : (object3 == null ? 1 : comparator.compare(object4, object3))));
                    }
                    return bl ? n2 : n2 * -1;
                }
            };
        }
    }

    private static class ProfilerRendererWrapper
    implements TreeCellRenderer,
    ProfilerRenderer {
        private final ProfilerRenderer renderer;

        ProfilerRendererWrapper(ProfilerRenderer profilerRenderer) {
            this.renderer = profilerRenderer;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.setValue(object, n);
            JComponent jComponent = this.getComponent();
            jComponent.setOpaque(false);
            if (jTree != null) {
                jComponent.setForeground(jTree.getForeground());
                jComponent.setBackground(jTree.getBackground());
            }
            return jComponent;
        }

        @Override
        public void setValue(Object object, int n) {
            this.renderer.setValue(object, n);
        }

        @Override
        public int getHorizontalAlignment() {
            return this.renderer.getHorizontalAlignment();
        }

        @Override
        public JComponent getComponent() {
            return this.renderer.getComponent();
        }

        @Override
        public void move(int n, int n2) {
            this.renderer.move(n, n2);
        }

        public String toString() {
            return this.renderer.toString();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this.renderer.getAccessibleContext();
        }
    }

    public static abstract class NodeExpansionEvaluator {
        public abstract Boolean hasBeenExpanded(TreePath var1);
    }
}

