# for-in [![NPM version](https://img.shields.io/npm/v/for-in.svg?style=flat)](https://www.npmjs.com/package/for-in) [![NPM downloads](https://img.shields.io/npm/dm/for-in.svg?style=flat)](https://npmjs.org/package/for-in) [![Build Status](https://img.shields.io/travis/jonschlinkert/for-in.svg?style=flat)](https://travis-ci.org/jonschlinkert/for-in)

> Iterate over the own and inherited enumerable properties of an object, and return an object with properties that evaluate to true from the callback. Exit early by returning `false`. JavaScript/Node.js

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install for-in --save
```

## Usage

```js
var forIn = require('for-in');

var obj = {a: 'foo', b: 'bar', c: 'baz'};
var values = [];
var keys = [];

forIn(obj, function (value, key, o) {
  keys.push(key);
  values.push(value);
});

console.log(keys);
//=> ['a', 'b', 'c'];

console.log(values);
//=> ['foo', 'bar', 'baz'];
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/for-in/issues/new).

## Building docs

Generate readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install verb && npm run docs
```

Or, if [verb](https://github.com/verbose/verb) is installed globally:

```sh
$ verb
```

## Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

## Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/for-in/blob/master/LICENSE).

***

_This file was generated by [verb](https://github.com/verbose/verb), v, on March 27, 2016._
