/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.DisplayTokenHandler;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.SyntaxUtilities;

@Deprecated
class BufferPrintable
implements Printable {
    private static Color headerColor = Color.lightGray;
    private static Color headerTextColor = Color.black;
    private static Color footerColor = Color.lightGray;
    private static Color footerTextColor = Color.black;
    private static Color lineNumberColor = Color.gray;
    private static Color textColor = Color.black;
    private PrinterJob job;
    private Object format;
    private View view;
    private Buffer buffer;
    private Font font;
    private SyntaxStyle[] styles;
    private boolean header;
    private boolean footer;
    private boolean lineNumbers;
    private int currentPage;
    private int currentPageStart;
    private int currentPhysicalLine;
    private boolean end;
    private LineMetrics lm;
    private final List<Chunk> lineList;
    private FontRenderContext frc;
    private DisplayTokenHandler tokenHandler;

    BufferPrintable(PrinterJob printerJob, Object object, View view, Buffer buffer, Font font, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.job = printerJob;
        this.format = object;
        this.view = view;
        this.buffer = buffer;
        this.font = font;
        this.header = bl;
        this.footer = bl2;
        this.lineNumbers = bl3;
        this.styles = SyntaxUtilities.loadStyles(jEdit.getProperty("print.font"), jEdit.getIntegerProperty("print.fontsize", 10), bl4);
        this.styles[0] = new SyntaxStyle(textColor, null, font);
        for (int i = 0; i < this.styles.length; ++i) {
            SyntaxStyle syntaxStyle = this.styles[i];
            if (!syntaxStyle.getForegroundColor().equals(Color.WHITE) || syntaxStyle.getBackgroundColor() != null) continue;
            this.styles[i] = new SyntaxStyle(Color.BLACK, this.styles[i].getBackgroundColor(), this.styles[i].getFont());
        }
        this.lineList = new ArrayList<Chunk>();
        this.tokenHandler = new DisplayTokenHandler();
    }

    public void print() {
        try {
            if (this.format == null) {
                this.job.print();
            } else {
                Method method = PrinterJob.class.getMethod("print", Class.forName("javax.print.attribute.PrintRequestAttributeSet"));
                method.invoke((Object)this.job, this.format);
            }
        }
        catch (PrinterAbortException printerAbortException) {
            Log.log(1, this, printerAbortException);
        }
        catch (Exception exception) {
            Log.log(9, this, exception);
            final String[] stringArray = new String[]{exception.toString()};
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GUIUtilities.error(BufferPrintable.this.view, "print-error", stringArray);
                }
            });
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (this.frc == null) {
            this.frc = ((Graphics2D)graphics).getFontRenderContext();
        }
        if (n > this.currentPage) {
            for (int i = this.currentPage; i < n; ++i) {
                this.currentPhysicalLine = this.currentPageStart;
                this.printPage(graphics, pageFormat, i, true);
            }
            this.currentPage = n - 1;
        }
        if (n == this.currentPage + 1) {
            if (this.end) {
                return 1;
            }
            this.currentPageStart = this.currentPhysicalLine;
            this.currentPage = n;
        } else if (n == this.currentPage) {
            this.currentPhysicalLine = this.currentPageStart;
        }
        this.printPage(graphics, pageFormat, n, true);
        return 0;
    }

    private void printPage(Graphics graphics, PageFormat pageFormat, int n, boolean bl) {
        double d;
        int n2;
        char[] cArray;
        int n3;
        double d2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(this.font);
        double d3 = pageFormat.getImageableX();
        double d4 = pageFormat.getImageableY();
        double d5 = pageFormat.getImageableWidth();
        double d6 = pageFormat.getImageableHeight();
        if (this.header) {
            d2 = this.paintHeader(graphics2D, d3, d4, d5, bl);
            d4 += d2;
            d6 -= d2;
        }
        if (this.footer) {
            d2 = this.paintFooter(graphics2D, d3, d4, d5, d6, n, bl);
            d6 -= d2;
        }
        boolean bl2 = jEdit.getBooleanProperty("print.glyphVector");
        if (this.lineNumbers) {
            n3 = (int)Math.ceil(Math.log(this.buffer.getLineCount() + 1) / Math.log(10.0)) + 1;
            cArray = new char[n3];
            for (n2 = 0; n2 < cArray.length; ++n2) {
                cArray[n2] = 32;
            }
            d = this.font.getStringBounds(cArray, 0, n3, this.frc).getWidth();
        } else {
            d = 0.0;
        }
        n3 = jEdit.getIntegerProperty("print.tabSize", 8);
        cArray = new char[n3];
        for (n2 = 0; n2 < cArray.length; ++n2) {
            cArray[n2] = 32;
        }
        double d7 = this.font.getStringBounds(cArray, 0, n3, this.frc).getWidth();
        PrintTabExpander printTabExpander = new PrintTabExpander(d7);
        this.lm = this.font.getLineMetrics("gGyYX", this.frc);
        double d8 = 0.0;
        while (true) {
            if (this.currentPhysicalLine == this.buffer.getLineCount()) {
                Log.log(1, this, "Finished buffer");
                this.end = true;
                break;
            }
            if (!jEdit.getBooleanProperty("print.folds", true) && !this.view.getTextArea().getDisplayManager().isLineVisible(this.currentPhysicalLine)) {
                Log.log(1, this, "Skipping invisible line");
                ++this.currentPhysicalLine;
                continue;
            }
            this.lineList.clear();
            this.tokenHandler.init(this.styles, this.frc, printTabExpander, this.lineList, (float)(d5 - d), -1);
            this.buffer.markTokens(this.currentPhysicalLine, this.tokenHandler);
            if (this.lineList.isEmpty()) {
                this.lineList.add(null);
            }
            if (d8 + (double)(this.lm.getHeight() * (float)this.lineList.size()) >= d6) {
                Log.log(1, this, "Finished page before line " + this.currentPhysicalLine);
                break;
            }
            if (this.lineNumbers && bl) {
                graphics2D.setFont(this.font);
                graphics2D.setColor(lineNumberColor);
                graphics2D.drawString(String.valueOf(this.currentPhysicalLine + 1), (float)d3, (float)(d4 + d8 + (double)this.lm.getHeight()));
            }
            for (Chunk chunk : this.lineList) {
                d8 += (double)this.lm.getHeight();
                Chunk chunk2 = chunk;
                if (chunk2 == null || !bl) continue;
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                Chunk.paintChunkBackgrounds(chunk2, graphics2D, (float)(d3 + d), (float)(d4 + d8), fontMetrics.getHeight());
                Chunk.paintChunkList(chunk2, graphics2D, (float)(d3 + d), (float)(d4 + d8), bl2);
            }
            ++this.currentPhysicalLine;
        }
    }

    private double paintHeader(Graphics2D graphics2D, double d, double d2, double d3, boolean bl) {
        String string = jEdit.getProperty("print.headerText", new String[]{this.buffer.getName()});
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        this.lm = this.font.getLineMetrics(string, fontRenderContext);
        Rectangle2D rectangle2D = this.font.getStringBounds(string, fontRenderContext);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, rectangle2D.getHeight());
        if (bl) {
            graphics2D.setColor(headerColor);
            graphics2D.fill(double_);
            graphics2D.setColor(headerTextColor);
            graphics2D.drawString(string, (float)(d + (d3 - rectangle2D.getWidth()) / 2.0), (float)(d2 + (double)this.lm.getAscent()));
        }
        return ((RectangularShape)double_).getHeight();
    }

    private double paintFooter(Graphics2D graphics2D, double d, double d2, double d3, double d4, int n, boolean bl) {
        String string = jEdit.getProperty("print.footerText", new Object[]{new Date(), n + 1});
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        this.lm = this.font.getLineMetrics(string, fontRenderContext);
        Rectangle2D rectangle2D = this.font.getStringBounds(string, fontRenderContext);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2 + d4 - rectangle2D.getHeight(), d3, rectangle2D.getHeight());
        if (bl) {
            graphics2D.setColor(footerColor);
            graphics2D.fill(double_);
            graphics2D.setColor(footerTextColor);
            graphics2D.drawString(string, (float)(d + (d3 - rectangle2D.getWidth()) / 2.0), (float)(d2 + d4 - rectangle2D.getHeight() + (double)this.lm.getAscent()));
        }
        return ((RectangularShape)double_).getHeight();
    }

    static class PrintTabExpander
    implements TabExpander {
        private double tabWidth;

        PrintTabExpander(double d) {
            this.tabWidth = d;
        }

        @Override
        public float nextTabStop(float f, int n) {
            int n2 = (int)((double)(f + 1.0f) / this.tabWidth);
            return (float)((double)(n2 + 1) * this.tabWidth);
        }
    }
}

