/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transport.actions.stats;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class WatcherStatsRequest
extends BaseNodesRequest<WatcherStatsRequest> {
    private boolean includeCurrentWatches;
    private boolean includeQueuedWatches;
    private boolean includeStats;

    public boolean includeCurrentWatches() {
        return this.includeCurrentWatches;
    }

    public void includeCurrentWatches(boolean currentWatches) {
        this.includeCurrentWatches = currentWatches;
    }

    public boolean includeQueuedWatches() {
        return this.includeQueuedWatches;
    }

    public void includeQueuedWatches(boolean includeQueuedWatches) {
        this.includeQueuedWatches = includeQueuedWatches;
    }

    public boolean includeStats() {
        return this.includeStats;
    }

    public void includeStats(boolean includeStats) {
        this.includeStats = includeStats;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.includeCurrentWatches = in.readBoolean();
        this.includeQueuedWatches = in.readBoolean();
        this.includeStats = in.getVersion().onOrAfter(Version.V_6_3_0) ? in.readBoolean() : false;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.includeCurrentWatches);
        out.writeBoolean(this.includeQueuedWatches);
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeBoolean(this.includeStats);
        }
    }

    public String toString() {
        return "watcher_stats";
    }

    public static class Node
    extends BaseNodeRequest {
        private boolean includeCurrentWatches;
        private boolean includeQueuedWatches;
        private boolean includeStats;

        public Node() {
        }

        public Node(WatcherStatsRequest request, String nodeId) {
            super(nodeId);
            this.includeCurrentWatches = request.includeCurrentWatches();
            this.includeQueuedWatches = request.includeQueuedWatches();
            this.includeStats = request.includeStats();
        }

        public boolean includeCurrentWatches() {
            return this.includeCurrentWatches;
        }

        public boolean includeQueuedWatches() {
            return this.includeQueuedWatches;
        }

        public boolean includeStats() {
            return this.includeStats;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.includeCurrentWatches = in.readBoolean();
            this.includeQueuedWatches = in.readBoolean();
            this.includeStats = in.getVersion().onOrAfter(Version.V_6_3_0) ? in.readBoolean() : false;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.includeCurrentWatches);
            out.writeBoolean(this.includeQueuedWatches);
            if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
                out.writeBoolean(this.includeStats);
            }
        }
    }
}

