/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Objects;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.LeafExpression;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;
import org.elasticsearch.xpack.sql.type.DataTypes;

public class Literal
extends LeafExpression {
    public static final Literal TRUE = Literal.of(Location.EMPTY, Boolean.TRUE);
    public static final Literal FALSE = Literal.of(Location.EMPTY, Boolean.FALSE);
    private final Object value;
    private final DataType dataType;

    public Literal(Location location, Object value, DataType dataType) {
        super(location);
        this.dataType = dataType;
        this.value = DataTypeConversion.convert(value, dataType);
    }

    @Override
    protected NodeInfo<Literal> info() {
        return NodeInfo.create(this, Literal::new, this.value, this.dataType);
    }

    public Object value() {
        return this.value;
    }

    @Override
    public boolean foldable() {
        return true;
    }

    @Override
    public boolean nullable() {
        return this.value == null;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public boolean resolved() {
        return true;
    }

    @Override
    public Object fold() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.dataType);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Literal other = (Literal)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.dataType, other.dataType);
    }

    @Override
    public String toString() {
        return Objects.toString(this.value);
    }

    public static Literal of(Location loc, Object value) {
        if (value instanceof Literal) {
            return (Literal)value;
        }
        return new Literal(loc, value, DataTypes.fromJava(value));
    }

    public static Literal of(Expression foldable) {
        if (foldable instanceof Literal) {
            return (Literal)foldable;
        }
        if (!foldable.foldable()) {
            throw new SqlIllegalArgumentException("Foldable expression required for Literal creation; received unfoldable " + foldable);
        }
        return new Literal(foldable.location(), foldable.fold(), foldable.dataType());
    }
}

