/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support;

import java.lang.reflect.Array;
import java.util.Iterator;

public class ArrayObjectIterator
implements Iterator<Object> {
    private final Object array;
    private final int length;
    private int index;

    public ArrayObjectIterator(Object array) {
        this.array = array;
        this.length = Array.getLength(array);
        this.index = 0;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.length;
    }

    @Override
    public Object next() {
        return Array.get(this.array, this.index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("array iterator does not support removing elements");
    }

    public static class Iterable
    implements java.lang.Iterable<Object> {
        private Object array;

        public Iterable(Object array) {
            this.array = array;
        }

        @Override
        public Iterator<Object> iterator() {
            return new ArrayObjectIterator(this.array);
        }
    }
}

