#############################################################################
##
#W  grppcext.gd                 GAP library                      Bettina Eick
##
#Y  Copyright (C)  1997,  Lehrstuhl D für Mathematik,  RWTH Aachen, Germany
#Y  (C) 1998 School Math and Comp. Sci., University of St Andrews, Scotland
#Y  Copyright (C) 2002 The GAP Group
##

#############################################################################
##
#I  InfoCompPairs
#I  InfoExtReps
##
DeclareInfoClass( "InfoCompPairs" );
DeclareInfoClass( "InfoExtReps");

#############################################################################
##
#F  MappedPcElement( <elm>, <pcgs>, <list> )
##
##  <ManSection>
##  <Func Name="MappedPcElement" Arg='elm, pcgs, list'/>
##
##  <Description>
##  returns the image of <A>elm</A> when mapping the pcgs <A>pcgs</A> onto <A>list</A>
##  homomorphically.
##  </Description>
##  </ManSection>
##
DeclareGlobalFunction("MappedPcElement");

#############################################################################
##
#F  TracedPointPcElement( <elm>, <pcgs>, <list>, <pt> )
##
##  <ManSection>
##  <Func Name="TracedPointPcElement" Arg='elm, pcgs, list,pt'/>
##
##  <Description>
##  returns the image of <A>pt</A> under the permutation image of <A>elm</A> when mapping the pcgs <A>pcgs</A> onto <A>list</A>
##  homomorphically.
##  </Description>
##  </ManSection>
##
DeclareGlobalFunction("TracedPointPcElement");

#############################################################################
##
#F  ExtensionSQ( <C>, <G>, <M>, <c> )
##
##  <ManSection>
##  <Func Name="ExtensionSQ" Arg='C, G, M, c'/>
##
##  <Description>
##  </Description>
##  </ManSection>
##
DeclareGlobalFunction( "ExtensionSQ" );

#############################################################################
##
#F  FpGroupPcGroupSQ( <G> )
##
##  <ManSection>
##  <Func Name="FpGroupPcGroupSQ" Arg='G'/>
##
##  <Description>
##  </Description>
##  </ManSection>
##
DeclareGlobalFunction( "FpGroupPcGroupSQ" );

#############################################################################
##
#F  EXPermutationActionPairs( <D> )
##
##  <ManSection>
##  <Func Name="EXPermutationActionPairs" Arg='D'/>
##
##  <Description>
##  Let <A>D</A> be a direct product of automorphism group and matrix group as
##  used by <C>CompatiblePairs</C>. This function calculates a faithful
##  permutation representation of <A>D</A>, which can be used to speed up
##  stabilizer calculations. It returns a record with components <C>pairgens</C>:
##  Generators of <A>D</A>, <C>permgens</C>: corresponding permutations, <C>permgroup</C>:
##  the group generated by <C>permgens</C>, <C>isomorphism</C>: An isomorphism from
##  the permutation group to <A>D</A>. This isomorphism can be used to map
##  permutations, but it would be hard to get the preimage of a pair in <A>D</A>
##  as a permutation.
##  The routine may return  <K>false</K> if somehow such a representation could
##  not be found.
##  </Description>
##  </ManSection>
##
DeclareGlobalFunction( "EXPermutationActionPairs" );

#############################################################################
##
#F  EXReducePermutationActionPairs( <r> )
##
##  <ManSection>
##  <Func Name="EXReducePermutationActionPairs" Arg='r'/>
##
##  <Description>
##  Let <A>r</A> be a record as returned by <C>EXPermutationActionPairs</C>. This
##  function tries to reduce the underlying permutation representation (and
##  changes the record accordingly). It is of use when stepping to a
##  subgroup of all pairs.
##  </Description>
##  </ManSection>
##
DeclareGlobalFunction( "EXReducePermutationActionPairs" );

#############################################################################
##
#F  CompatiblePairs( <G>, <M>[, <D>] )
##
##  <#GAPDoc Label="CompatiblePairs">
##  <ManSection>
##  <Func Name="CompatiblePairs" Arg='G, M[, D]'/>
##
##  <Description>
##  returns the group of compatible pairs of the group <A>G</A> with the 
##  <A>G</A>-module <A>M</A> as subgroup of the direct product
##  Aut(<A>G</A>) <M>\times</M> Aut(<A>M</A>).
##  Here Aut(<A>M</A>) is considered as subgroup of a general linear group.
##  The optional argument <A>D</A> should be a subgroup of
##  Aut(<A>G</A>) <M>\times</M> Aut(<A>M</A>).
##  If it is given, then only the compatible pairs in <A>D</A> are computed.
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareGlobalFunction( "CompatiblePairs" );

#############################################################################
##
#O  Extension( <G>, <M>, <c> )
#O  ExtensionNC( <G>, <M>, <c> )
##
##  <#GAPDoc Label="Extension">
##  <ManSection>
##  <Oper Name="Extension" Arg='G, M, c'/>
##  <Oper Name="ExtensionNC" Arg='G, M, c'/>
##
##  <Description>
##  returns the extension of <A>G</A> by the <A>G</A>-module <A>M</A>
##  via the cocycle <A>c</A> as pc groups.
##  The <C>NC</C> version does not check the resulting group for consistence.
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareOperation( "Extension", [ CanEasilyComputePcgs, IsObject, IsVector ] );
DeclareOperation( "ExtensionNC", [ CanEasilyComputePcgs, IsObject, IsVector ] );

#############################################################################
##
#O  Extensions( <G>, <M> )
##
##  <#GAPDoc Label="Extensions">
##  <ManSection>
##  <Oper Name="Extensions" Arg='G, M'/>
##
##  <Description>
##  returns all extensions of <A>G</A> by the <A>G</A>-module <A>M</A>
##  up to equivalence as pc groups.
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareOperation( "Extensions", [ CanEasilyComputePcgs, IsObject ] );

#############################################################################
##
#O  ExtensionRepresentatives( <G>, <M>, <P> )
##
##  <#GAPDoc Label="ExtensionRepresentatives">
##  <ManSection>
##  <Oper Name="ExtensionRepresentatives" Arg='G, M, P'/>
##
##  <Description>
##  returns all extensions of <A>G</A> by the <A>G</A>-module <A>M</A> up to
##  equivalence under action of <A>P</A> where <A>P</A> has to be a subgroup
##  of the group of compatible pairs of <A>G</A> with <A>M</A>.
##  <Example><![CDATA[
##  gap> G := SmallGroup( 4, 2 );;
##  gap> mats := List( Pcgs( G ), x -> IdentityMat( 1, GF(2) ) );;
##  gap> M := GModuleByMats( mats, GF(2) );;
##  gap> A := AutomorphismGroup( G );;
##  gap> B := GL( 1, 2 );;
##  gap> D := DirectProduct( A, B );; Size(D);
##  6
##  gap> P := CompatiblePairs( G, M, D );
##  <group of size 6 with 2 generators>
##  gap> ExtensionRepresentatives( G, M, P );
##  [ <pc group of size 8 with 3 generators>, 
##    <pc group of size 8 with 3 generators>, 
##    <pc group of size 8 with 3 generators>, 
##    <pc group of size 8 with 3 generators> ]
##  gap> Extensions( G, M );
##  [ <pc group of size 8 with 3 generators>, 
##    <pc group of size 8 with 3 generators>, 
##    <pc group of size 8 with 3 generators>, 
##    <pc group of size 8 with 3 generators>, 
##    <pc group of size 8 with 3 generators>, 
##    <pc group of size 8 with 3 generators>, 
##    <pc group of size 8 with 3 generators>, 
##    <pc group of size 8 with 3 generators> ]
##  ]]></Example>
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareOperation( "ExtensionRepresentatives", 
                    [CanEasilyComputePcgs, IsObject, IsObject] );

#############################################################################
##
#O  SplitExtension( <G>, <M> )
#O  SplitExtension( <G>, <aut>, <N> )
##
##  <ManSection>
##  <Oper Name="SplitExtension" Arg='G, M'/>
##  <Oper Name="SplitExtension" Arg='G, aut, N'/>
##
##  <Description>
##  returns the split extension of <A>G</A> by the <A>G</A>-module <A>M</A>. In the second
##  form it returns the split extension of <A>G</A> by the arbitrary finite group
##  <A>N</A> where <A>aut</A> is a homomorphism of <A>G</A> into Aut(<A>N</A>).
##  </Description>
##  </ManSection>
##
DeclareOperation( "SplitExtension", [CanEasilyComputePcgs, IsObject] );

#############################################################################
##
#O  TopExtensionsByAutomorphism( <G>, <aut>, <p> )
##
##  <ManSection>
##  <Oper Name="TopExtensionsByAutomorphism" Arg='G, aut, p'/>
##
##  <Description>
##  </Description>
##  </ManSection>
##
DeclareOperation( "TopExtensionsByAutomorphism",
                               [CanEasilyComputePcgs, IsObject, IsInt] );

#############################################################################
##
#O  CyclicTopExtensions( <G>, <p> )
##
##  <ManSection>
##  <Oper Name="CyclicTopExtensions" Arg='G, p'/>
##
##  <Description>
##  </Description>
##  </ManSection>
##
DeclareOperation( "CyclicTopExtensions", 
                       [CanEasilyComputePcgs, IsInt] );

#############################################################################
##
#A  SocleComplement(<G>)
##
##  <ManSection>
##  <Attr Name="SocleComplement" Arg='G'/>
##
##  <Description>
##  </Description>
##  </ManSection>
##
DeclareAttribute( "SocleComplement", IsGroup );

#############################################################################
##
#A  SocleDimensions(<G>)
##
##  <ManSection>
##  <Attr Name="SocleDimensions" Arg='G'/>
##
##  <Description>
##  </Description>
##  </ManSection>
##
DeclareAttribute( "SocleDimensions", IsGroup );

#############################################################################
##
#A  ModuleOfExtension( < G > );
##
##  <ManSection>
##  <Attr Name="ModuleOfExtension" Arg='G'/>
##
##  <Description>
##  </Description>
##  </ManSection>
##
DeclareAttribute( "ModuleOfExtension", IsGroup );


#############################################################################
##
#E

