/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.resource;

import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.simpleframework.http.Address;
import org.simpleframework.http.Path;
import org.simpleframework.http.resource.FileIndex;
import org.simpleframework.http.resource.Index;
import org.simpleframework.http.resource.Indexer;

class FileIndexer
implements Indexer {
    private ResourceBundle resolver;
    private Cache cache = new Cache();
    private File base;

    public FileIndexer(File base) {
        this.base = base;
    }

    public Index getIndex(String target) {
        Index index = (Index)this.cache.get(target);
        if (index == null) {
            index = this.getIndex(this, target);
        }
        return index;
    }

    public Index getIndex(Indexer indexer, String target) {
        FileIndex index = new FileIndex(indexer, target);
        if (target.indexOf(63) < 0) {
            this.cache.put(target, index);
        }
        return index;
    }

    public File getFile(Address target) {
        return this.getFile(target.getPath());
    }

    public Path getPath(Address target) {
        return target.getPath();
    }

    private File getFile(Path path) {
        String file = ((Object)path).toString();
        if (file != null) {
            file = file.replace('/', File.separatorChar);
        }
        return new File(this.base, file);
    }

    public String getContentType(Address target) {
        return this.getContentType(target.getPath());
    }

    private String getContentType(Path path) {
        String ext = path.getExtension();
        String target = path.getPath();
        return this.getContentType(target, ext);
    }

    private String getContentType(String path, String ext) {
        try {
            ResourceBundle bundle = this.getBundle();
            if (bundle != null) {
                return bundle.getString(ext);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return "application/octetstream";
    }

    private ResourceBundle getBundle() {
        if (this.resolver == null) {
            this.resolver = this.getClassBundle();
        }
        return this.resolver;
    }

    private ResourceBundle getClassBundle() {
        Class<FileIndexer> type = FileIndexer.class;
        String name = type.getName();
        return ResourceBundle.getBundle(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Cache
    extends ConcurrentHashMap<String, Index> {
    }
}

