/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.util.GUtil;

public class DefaultBuildActionParameters
implements BuildActionParameters,
Serializable {
    private final File currentDir;
    private final LogLevel logLevel;
    private final Map<String, String> systemProperties;
    private final Map<String, String> envVariables;
    private final boolean useDaemon;
    private final boolean continuous;
    private final boolean interactive;
    private final ClassPath injectedPluginClasspath;

    public DefaultBuildActionParameters(Map<?, ?> systemProperties, Map<String, String> envVariables, File currentDir, LogLevel logLevel, boolean useDaemon, boolean continuous, boolean interactive, ClassPath injectedPluginClasspath) {
        this.currentDir = currentDir;
        this.logLevel = logLevel;
        this.useDaemon = useDaemon;
        this.continuous = continuous;
        assert (systemProperties != null);
        assert (envVariables != null);
        this.systemProperties = new HashMap<String, String>();
        GUtil.addToMap(this.systemProperties, systemProperties);
        this.envVariables = new HashMap<String, String>(envVariables);
        this.interactive = interactive;
        this.injectedPluginClasspath = injectedPluginClasspath;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public Map<String, String> getEnvVariables() {
        return this.envVariables;
    }

    @Override
    public File getCurrentDir() {
        return this.currentDir;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public String toString() {
        return "DefaultBuildActionParameters{, currentDir=" + this.currentDir + ", systemProperties size=" + this.systemProperties.size() + ", envVariables size=" + this.envVariables.size() + ", logLevel=" + this.logLevel + ", useDaemon=" + this.useDaemon + ", continuous=" + this.continuous + ", interactive=" + this.interactive + ", injectedPluginClasspath=" + this.injectedPluginClasspath + '}';
    }

    @Override
    public boolean isUseDaemon() {
        return this.useDaemon;
    }

    @Override
    public boolean isContinuous() {
        return this.continuous;
    }

    @Override
    public boolean isInteractive() {
        return this.interactive;
    }

    @Override
    public ClassPath getInjectedPluginClasspath() {
        return this.injectedPluginClasspath;
    }
}

