#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: clash-prelude
version: 0.99.3
id: clash-prelude-0.99.3-J43mTvoGQn82zXMuXyjkl8
key: clash-prelude-0.99.3-J43mTvoGQn82zXMuXyjkl8
license: BSD-2-Clause
copyright: Copyright © 2013-2016, University of Twente,
           2016-2017, Myrtle Software Ltd,
           2017     , QBayLogic, Google Inc.
maintainer: Christiaan Baaij <christiaan.baaij@gmail.com>
author: Christiaan Baaij
homepage: http://www.clash-lang.org/
synopsis: CAES Language for Synchronous Hardware - Prelude library
description:
    CλaSH (pronounced ‘clash’) is a functional hardware description language that
    borrows both its syntax and semantics from the functional programming language
    Haskell. The CλaSH compiler transforms these high-level descriptions to
    low-level synthesizable VHDL, Verilog, or SystemVerilog.
    .
    Features of CλaSH:
    .
    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.
    .
    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.
    .
    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.
    .
    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.
    .
    * Support for multiple clock domains, with type safe clock domain crossing.
    .
    .
    This package provides:
    .
    * Prelude library containing datatypes and functions for circuit design
    .
    To use the library:
    .
    * Import "Clash.Prelude"
    .
    * Alternatively, if you want to explicitly route clock and reset ports,
    for more straightforward multi-clock designs, you can import the
    "Clash.Explicit.Prelude" module. Note that you should not import
    "Clash.Prelude" and "Clash.Explicit.Prelude" at the same time as they
    have overlapping definitions.
    .
    A preliminary version of a tutorial can be found in "Clash.Tutorial", for a
    general overview of the library you should however check out "Clash.Prelude".
    Some circuit examples can be found in "Clash.Examples".
category: Hardware
abi: c4ef39260ebb55cb181e0257f0512c7f
exposed: True
exposed-modules:
    Clash.Annotations.Primitive Clash.Annotations.TopEntity
    Clash.Class.BitPack Clash.Class.Num Clash.Class.Resize
    Clash.Examples Clash.Explicit.BlockRam Clash.Explicit.BlockRam.File
    Clash.Explicit.DDR Clash.Explicit.Mealy Clash.Explicit.Moore
    Clash.Explicit.Prelude Clash.Explicit.Prelude.Safe
    Clash.Explicit.RAM Clash.Explicit.ROM Clash.Explicit.ROM.File
    Clash.Explicit.Signal Clash.Explicit.Signal.Delayed
    Clash.Explicit.Synchronizer Clash.Explicit.Testbench Clash.Hidden
    Clash.Intel.ClockGen Clash.Intel.DDR Clash.NamedTypes Clash.Prelude
    Clash.Prelude.BitIndex Clash.Prelude.BitReduction
    Clash.Prelude.BlockRam Clash.Prelude.BlockRam.File
    Clash.Prelude.DataFlow Clash.Prelude.Mealy Clash.Prelude.Moore
    Clash.Prelude.RAM Clash.Prelude.ROM Clash.Prelude.ROM.File
    Clash.Prelude.Safe Clash.Prelude.Testbench Clash.Promoted.Nat
    Clash.Promoted.Nat.Literals Clash.Promoted.Nat.TH
    Clash.Promoted.Nat.Unsafe Clash.Promoted.Symbol Clash.Signal
    Clash.Signal.Bundle Clash.Signal.Delayed Clash.Signal.Internal
    Clash.Sized.BitVector Clash.Sized.Fixed Clash.Sized.Index
    Clash.Sized.Internal.BitVector Clash.Sized.Internal.Index
    Clash.Sized.Internal.Signed Clash.Sized.Internal.Unsigned
    Clash.Sized.RTree Clash.Sized.Signed Clash.Sized.Unsigned
    Clash.Sized.Vector Clash.Tutorial Clash.XException
    Clash.Xilinx.ClockGen Clash.Xilinx.DDR
hidden-modules: Clash.Class.BitPack.Internal
                Clash.Signal.Bundle.Internal
import-dirs: /usr/lib/ghc-8.4.3/site-local/clash-prelude-0.99.3
library-dirs: /usr/lib/ghc-8.4.3/site-local/clash-prelude-0.99.3
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/clash-prelude-0.99.3
hs-libraries: HSclash-prelude-0.99.3-J43mTvoGQn82zXMuXyjkl8
depends:
    array-0.5.2.0 base-4.11.1.0 bifunctors-5.5.3-B2s1kTwvG5P67s9a0vFF69
    constraints-0.10.1-CEnPsKsdbKYBiMqIEWeYRg
    data-binary-ieee754-0.4.4-GMEnBfyxjqq6rJmTySXper
    data-default-0.7.1.1-ANph70WEdAe9A1H2IGNxHn integer-gmp-1.0.2.0
    deepseq-1.4.3.0 ghc-prim-0.5.2.0
    ghc-typelits-extra-0.3-Fu4ROSONlGO65NyLLszh0N
    ghc-typelits-knownnat-0.6-2l65EuMUsdqFInKH66lzYd
    ghc-typelits-natnormalise-0.6.2-EIVHJpQRDQbDkaHy66XoaR
    half-0.3-Bv0S7Tgl5PTHWUni6OzIYh lens-4.17-4C4gMEkWPox35sMHxQ6P7t
    QuickCheck-2.11.3-58QsvdIMmwDDNaUIIDmLAr
    reflection-2.1.4-ET4Qfoy5lmWBopRK3ezJIQ
    singletons-2.4.1-3k4uXLAH8ZwHDV1pRAwku3 template-haskell-2.13.0.0
    transformers-0.5.5.0 vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq
abi-depends: array-0.5.2.0=dc85b03ee806d784249cc791da6109c3
             base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             bifunctors-5.5.3-B2s1kTwvG5P67s9a0vFF69=8adb81346affd1af6f03238f8ca73e7f
             constraints-0.10.1-CEnPsKsdbKYBiMqIEWeYRg=3db016d4e9141803cbc68c03ed2d4a23
             data-binary-ieee754-0.4.4-GMEnBfyxjqq6rJmTySXper=d66971a5e33e6c01a2e11481d8e08c1d
             data-default-0.7.1.1-ANph70WEdAe9A1H2IGNxHn=02e9419e0e877fc1db7c56d6f64866aa
             integer-gmp-1.0.2.0=9ea484dc1eeb054803bb4cf8d65c934d
             deepseq-1.4.3.0=34da2d42d10eacba0aad99c95b538637
             ghc-prim-0.5.2.0=387aa7e78e4e6c49e51798e4d6763c3f
             ghc-typelits-extra-0.3-Fu4ROSONlGO65NyLLszh0N=57a52c07f2d43eaf6be51f9611bac869
             ghc-typelits-knownnat-0.6-2l65EuMUsdqFInKH66lzYd=65a99784148690104913d2bc9039187e
             ghc-typelits-natnormalise-0.6.2-EIVHJpQRDQbDkaHy66XoaR=ed21f943764f1838268a3e51ae0a64b5
             half-0.3-Bv0S7Tgl5PTHWUni6OzIYh=3f272ff59e75eab0bf61536c0a9b26f4
             lens-4.17-4C4gMEkWPox35sMHxQ6P7t=4cb9fc45e7308a0ad354f525c2839895
             QuickCheck-2.11.3-58QsvdIMmwDDNaUIIDmLAr=59a035869ce3bae16d8c8360447f600f
             reflection-2.1.4-ET4Qfoy5lmWBopRK3ezJIQ=37ee6153039d91a8a0a308b6c7631d8e
             singletons-2.4.1-3k4uXLAH8ZwHDV1pRAwku3=bf55039c2d90db2b1bb9ddcb795e06b2
             template-haskell-2.13.0.0=ac7dfd04924d4ebfa90a119ad22a36cc
             transformers-0.5.5.0=4f41484af13f560f1d83ed79e1be4572
             vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq=8ec9732a4c43da9ed60d7a7b8971b540
haddock-interfaces: /usr/share/doc/haskell-clash-prelude/html/clash-prelude.haddock
haddock-html: /usr/share/doc/haskell-clash-prelude/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

