/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import org.gjt.sp.jedit.bsh.BshClassManager;
import org.gjt.sp.jedit.bsh.BshMethod;
import org.gjt.sp.jedit.bsh.CallStack;
import org.gjt.sp.jedit.bsh.ClassGenerator;
import org.gjt.sp.jedit.bsh.ClassIdentifier;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.InterpreterError;
import org.gjt.sp.jedit.bsh.LHS;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.Primitive;
import org.gjt.sp.jedit.bsh.Reflect;
import org.gjt.sp.jedit.bsh.ReflectError;
import org.gjt.sp.jedit.bsh.SimpleNode;
import org.gjt.sp.jedit.bsh.StringUtil;
import org.gjt.sp.jedit.bsh.This;
import org.gjt.sp.jedit.bsh.Types;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.bsh.UtilTargetError;

class Name
implements Serializable {
    public NameSpace namespace;
    String value = null;
    private String evalName;
    private String lastEvalName;
    private static String FINISHED = null;
    private Object evalBaseObject;
    private int callstackDepth;
    Class asClass;
    Class classOfStaticMethod;

    private void reset() {
        this.evalName = this.value;
        this.evalBaseObject = null;
        this.callstackDepth = 0;
    }

    Name(NameSpace nameSpace, String string) {
        this.namespace = nameSpace;
        this.value = string;
    }

    public Object toObject(CallStack callStack, Interpreter interpreter) throws UtilEvalError {
        return this.toObject(callStack, interpreter, false);
    }

    public synchronized Object toObject(CallStack callStack, Interpreter interpreter, boolean bl) throws UtilEvalError {
        this.reset();
        Object object = null;
        while (this.evalName != null) {
            object = this.consumeNextObjectField(callStack, interpreter, bl, false);
        }
        if (object == null) {
            throw new InterpreterError("null value in toObject()");
        }
        return object;
    }

    private Object completeRound(String string, String string2, Object object) {
        if (object == null) {
            throw new InterpreterError("lastEvalName = " + string);
        }
        this.lastEvalName = string;
        this.evalName = string2;
        this.evalBaseObject = object;
        return object;
    }

    private Object consumeNextObjectField(CallStack callStack, Interpreter interpreter, boolean bl, boolean bl2) throws UtilEvalError {
        Object object;
        Object object2;
        Object object3;
        if (this.evalBaseObject == null && !Name.isCompound(this.evalName) && !bl && (object3 = this.resolveThisFieldReference(callStack, this.namespace, interpreter, this.evalName, false)) != Primitive.VOID) {
            return this.completeRound(this.evalName, FINISHED, object3);
        }
        object3 = Name.prefix(this.evalName, 1);
        if ((this.evalBaseObject == null || this.evalBaseObject instanceof This) && !bl) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("trying to resolve variable: " + (String)object3);
            }
            if ((object2 = this.evalBaseObject == null ? this.resolveThisFieldReference(callStack, this.namespace, interpreter, (String)object3, false) : this.resolveThisFieldReference(callStack, ((This)this.evalBaseObject).namespace, interpreter, (String)object3, true)) != Primitive.VOID) {
                if (Interpreter.DEBUG) {
                    Interpreter.debug("resolved variable: " + (String)object3 + " in namespace: " + this.namespace);
                }
                return this.completeRound((String)object3, Name.suffix(this.evalName), object2);
            }
        }
        if (this.evalBaseObject == null) {
            int n;
            if (Interpreter.DEBUG) {
                Interpreter.debug("trying class: " + this.evalName);
            }
            object2 = null;
            object = null;
            for (n = 1; n <= Name.countParts(this.evalName) && (object2 = this.namespace.getClass((String)(object = Name.prefix(this.evalName, n)))) == null; ++n) {
            }
            if (object2 != null) {
                return this.completeRound((String)object, Name.suffix(this.evalName, Name.countParts(this.evalName) - n), new ClassIdentifier((Class)object2));
            }
            if (Interpreter.DEBUG) {
                Interpreter.debug("not a class, trying var prefix " + this.evalName);
            }
        }
        if ((this.evalBaseObject == null || this.evalBaseObject instanceof This) && !bl && bl2) {
            object2 = this.evalBaseObject == null ? this.namespace : ((This)this.evalBaseObject).namespace;
            This this_ = new NameSpace((NameSpace)object2, "auto: " + (String)object3).getThis(interpreter);
            ((NameSpace)object2).setVariable((String)object3, this_, false);
            return this.completeRound((String)object3, Name.suffix(this.evalName), this_);
        }
        if (this.evalBaseObject == null) {
            if (!Name.isCompound(this.evalName)) {
                return this.completeRound(this.evalName, FINISHED, Primitive.VOID);
            }
            throw new UtilEvalError("Class or variable not found: " + this.evalName);
        }
        if (this.evalBaseObject == Primitive.NULL) {
            throw new UtilTargetError(new NullPointerException("Null Pointer while evaluating: " + this.value));
        }
        if (this.evalBaseObject == Primitive.VOID) {
            throw new UtilEvalError("Undefined variable or class name while evaluating: " + this.value);
        }
        if (this.evalBaseObject instanceof Primitive) {
            throw new UtilEvalError("Can't treat primitive like an object. Error while evaluating: " + this.value);
        }
        if (this.evalBaseObject instanceof ClassIdentifier) {
            String string;
            Class clazz;
            String string2;
            block28: {
                object2 = ((ClassIdentifier)this.evalBaseObject).getTargetClass();
                string2 = Name.prefix(this.evalName, 1);
                if (string2.equals("this")) {
                    for (object = this.namespace; object != null; object = ((NameSpace)object).getParent()) {
                        if (((NameSpace)object).classInstance == null || ((NameSpace)object).classInstance.getClass() != object2) continue;
                        return this.completeRound(string2, Name.suffix(this.evalName), ((NameSpace)object).classInstance);
                    }
                    throw new UtilEvalError("Can't find enclosing 'this' instance of class: " + object2);
                }
                object = null;
                try {
                    if (Interpreter.DEBUG) {
                        Interpreter.debug("Name call to getStaticFieldValue, class: " + object2 + ", field:" + string2);
                    }
                    object = Reflect.getStaticFieldValue((Class)object2, string2);
                }
                catch (ReflectError reflectError) {
                    if (!Interpreter.DEBUG) break block28;
                    Interpreter.debug("field reflect error: " + reflectError);
                }
            }
            if (object == null && (clazz = this.namespace.getClass(string = ((Class)object2).getName() + "$" + string2)) != null) {
                object = new ClassIdentifier(clazz);
            }
            if (object == null) {
                throw new UtilEvalError("No static field or inner class: " + string2 + " of " + object2);
            }
            return this.completeRound(string2, Name.suffix(this.evalName), object);
        }
        if (bl) {
            throw new UtilEvalError(this.value + " does not resolve to a class name.");
        }
        object2 = Name.prefix(this.evalName, 1);
        if (((String)object2).equals("length") && this.evalBaseObject.getClass().isArray()) {
            Primitive primitive = new Primitive(Array.getLength(this.evalBaseObject));
            return this.completeRound((String)object2, Name.suffix(this.evalName), primitive);
        }
        try {
            Object object4 = Reflect.getObjectFieldValue(this.evalBaseObject, (String)object2);
            return this.completeRound((String)object2, Name.suffix(this.evalName), object4);
        }
        catch (ReflectError reflectError) {
            throw new UtilEvalError("Cannot access field: " + (String)object2 + ", on object: " + this.evalBaseObject);
        }
    }

    Object resolveThisFieldReference(CallStack callStack, NameSpace nameSpace, Interpreter interpreter, String string, boolean bl) throws UtilEvalError {
        if (string.equals("this")) {
            if (bl) {
                throw new UtilEvalError("Redundant to call .this on This type");
            }
            This this_ = nameSpace.getThis(interpreter);
            nameSpace = this_.getNameSpace();
            Object object = this_;
            NameSpace nameSpace2 = Name.getClassNameSpace(nameSpace);
            if (nameSpace2 != null) {
                object = Name.isCompound(this.evalName) ? nameSpace2.getThis(interpreter) : nameSpace2.getClassInstance();
            }
            return object;
        }
        if (string.equals("super")) {
            This this_ = nameSpace.getSuper(interpreter);
            if ((nameSpace = this_.getNameSpace()).getParent() != null && nameSpace.getParent().isClass) {
                this_ = nameSpace.getParent().getThis(interpreter);
            }
            return this_;
        }
        Object object = null;
        if (string.equals("global")) {
            object = nameSpace.getGlobal(interpreter);
        }
        if (object == null && bl) {
            if (string.equals("namespace")) {
                object = nameSpace;
            } else if (string.equals("variables")) {
                object = nameSpace.getVariableNames();
            } else if (string.equals("methods")) {
                object = nameSpace.getMethodNames();
            } else if (string.equals("interpreter")) {
                if (this.lastEvalName.equals("this")) {
                    object = interpreter;
                } else {
                    throw new UtilEvalError("Can only call .interpreter on literal 'this'");
                }
            }
        }
        if (object == null && bl && string.equals("caller")) {
            if (this.lastEvalName.equals("this") || this.lastEvalName.equals("caller")) {
                if (callStack == null) {
                    throw new InterpreterError("no callstack");
                }
            } else {
                throw new UtilEvalError("Can only call .caller on literal 'this' or literal '.caller'");
            }
            object = callStack.get(++this.callstackDepth).getThis(interpreter);
            return object;
        }
        if (object == null && bl && string.equals("callstack")) {
            if (this.lastEvalName.equals("this")) {
                if (callStack == null) {
                    throw new InterpreterError("no callstack");
                }
                object = callStack;
            } else {
                throw new UtilEvalError("Can only call .callstack on literal 'this'");
            }
        }
        if (object == null) {
            object = nameSpace.getVariable(string);
        }
        if (object == null) {
            throw new InterpreterError("null this field ref:" + string);
        }
        return object;
    }

    static NameSpace getClassNameSpace(NameSpace nameSpace) {
        if (nameSpace.isClass) {
            return nameSpace;
        }
        if (nameSpace.isMethod && nameSpace.getParent() != null && nameSpace.getParent().isClass) {
            return nameSpace.getParent();
        }
        return null;
    }

    public synchronized Class toClass() throws ClassNotFoundException, UtilEvalError {
        if (this.asClass != null) {
            return this.asClass;
        }
        this.reset();
        if (this.evalName.equals("var")) {
            this.asClass = null;
            return null;
        }
        Class clazz = this.namespace.getClass(this.evalName);
        if (clazz == null) {
            Object object = null;
            try {
                object = this.toObject(null, null, true);
            }
            catch (UtilEvalError utilEvalError) {
                // empty catch block
            }
            if (object instanceof ClassIdentifier) {
                clazz = ((ClassIdentifier)object).getTargetClass();
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Class: " + this.value + " not found in namespace");
        }
        this.asClass = clazz;
        return this.asClass;
    }

    public synchronized LHS toLHS(CallStack callStack, Interpreter interpreter) throws UtilEvalError {
        this.reset();
        if (!Name.isCompound(this.evalName)) {
            if (this.evalName.equals("this")) {
                throw new UtilEvalError("Can't assign to 'this'.");
            }
            LHS lHS = new LHS(this.namespace, this.evalName, false);
            return lHS;
        }
        Object object = null;
        try {
            while (this.evalName != null && Name.isCompound(this.evalName)) {
                object = this.consumeNextObjectField(callStack, interpreter, false, true);
            }
        }
        catch (UtilEvalError utilEvalError) {
            throw new UtilEvalError("LHS evaluation: " + utilEvalError.getMessage());
        }
        if (this.evalName == null && object instanceof ClassIdentifier) {
            throw new UtilEvalError("Can't assign to class: " + this.value);
        }
        if (object == null) {
            throw new UtilEvalError("Error in LHS: " + this.value);
        }
        if (object instanceof This) {
            if (this.evalName.equals("namespace") || this.evalName.equals("variables") || this.evalName.equals("methods") || this.evalName.equals("caller")) {
                throw new UtilEvalError("Can't assign to special variable: " + this.evalName);
            }
            Interpreter.debug("found This reference evaluating LHS");
            boolean bl = !this.lastEvalName.equals("super");
            return new LHS(((This)object).namespace, this.evalName, bl);
        }
        if (this.evalName != null) {
            try {
                if (object instanceof ClassIdentifier) {
                    Class clazz = ((ClassIdentifier)object).getTargetClass();
                    LHS lHS = Reflect.getLHSStaticField(clazz, this.evalName);
                    return lHS;
                }
                LHS lHS = Reflect.getLHSObjectField(object, this.evalName);
                return lHS;
            }
            catch (ReflectError reflectError) {
                throw new UtilEvalError("Field access: " + reflectError);
            }
        }
        throw new InterpreterError("Internal error in lhs...");
    }

    public Object invokeMethod(Interpreter interpreter, Object[] objectArray, CallStack callStack, SimpleNode simpleNode) throws UtilEvalError, EvalError, ReflectError, InvocationTargetException {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        String string = Name.suffix(this.value, 1);
        BshClassManager bshClassManager = interpreter.getClassManager();
        NameSpace nameSpace = callStack.top();
        if (this.classOfStaticMethod != null) {
            return Reflect.invokeStaticMethod(bshClassManager, this.classOfStaticMethod, string, objectArray);
        }
        if (!Name.isCompound(this.value)) {
            return this.invokeLocalMethod(interpreter, objectArray, callStack, simpleNode);
        }
        String string2 = Name.prefix(this.value);
        if (string2.equals("super") && Name.countParts(this.value) == 2 && (serializable2 = Name.getClassNameSpace((NameSpace)(object = ((This)(serializable = nameSpace.getThis(interpreter))).getNameSpace()))) != null) {
            Object object2 = serializable2.getClassInstance();
            return ClassGenerator.getClassGenerator().invokeSuperclassMethod(bshClassManager, object2, string, objectArray);
        }
        serializable = nameSpace.getNameResolver(string2);
        object = ((Name)serializable).toObject(callStack, interpreter);
        if (object == Primitive.VOID) {
            throw new UtilEvalError("Attempt to resolve method: " + string + "() on undefined variable or class name: " + serializable);
        }
        if (!(object instanceof ClassIdentifier)) {
            if (object instanceof Primitive) {
                if (object == Primitive.NULL) {
                    throw new UtilTargetError(new NullPointerException("Null Pointer in Method Invocation"));
                }
                if (Interpreter.DEBUG) {
                    Interpreter.debug("Attempt to access method on primitive... allowing bsh.Primitive to peek through for debugging");
                }
            }
            return Reflect.invokeObjectMethod(object, string, objectArray, interpreter, callStack, simpleNode);
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("invokeMethod: trying static - " + serializable);
        }
        serializable2 = ((ClassIdentifier)object).getTargetClass();
        this.classOfStaticMethod = serializable2;
        if (serializable2 != null) {
            return Reflect.invokeStaticMethod(bshClassManager, (Class)serializable2, string, objectArray);
        }
        throw new UtilEvalError("invokeMethod: unknown target: " + serializable);
    }

    private Object invokeLocalMethod(Interpreter interpreter, Object[] objectArray, CallStack callStack, SimpleNode simpleNode) throws EvalError {
        Object object;
        if (Interpreter.DEBUG) {
            Interpreter.debug("invokeLocalMethod: " + this.value);
        }
        if (interpreter == null) {
            throw new InterpreterError("invokeLocalMethod: interpreter = null");
        }
        String string = this.value;
        Class[] classArray = Types.getTypes(objectArray);
        BshMethod bshMethod = null;
        try {
            bshMethod = this.namespace.getMethod(string, classArray);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError("Local method invocation", simpleNode, callStack);
        }
        if (bshMethod != null) {
            return bshMethod.invoke(objectArray, interpreter, callStack, simpleNode);
        }
        BshClassManager bshClassManager = interpreter.getClassManager();
        try {
            object = this.namespace.getCommand(string, classArray, interpreter);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError("Error loading command: ", simpleNode, callStack);
        }
        if (object == null) {
            BshMethod bshMethod2 = null;
            try {
                bshMethod2 = this.namespace.getMethod("invoke", new Class[]{null, null});
            }
            catch (UtilEvalError utilEvalError) {
                throw utilEvalError.toEvalError("Local method invocation", simpleNode, callStack);
            }
            if (bshMethod2 != null) {
                return bshMethod2.invoke(new Object[]{string, objectArray}, interpreter, callStack, simpleNode);
            }
            throw new EvalError("Command not found: " + StringUtil.methodString(string, classArray), simpleNode, callStack);
        }
        if (object instanceof BshMethod) {
            return ((BshMethod)object).invoke(objectArray, interpreter, callStack, simpleNode);
        }
        if (object instanceof Class) {
            try {
                return Reflect.invokeCompiledCommand((Class)object, objectArray, interpreter, callStack);
            }
            catch (UtilEvalError utilEvalError) {
                throw utilEvalError.toEvalError("Error invoking compiled command: ", simpleNode, callStack);
            }
        }
        throw new InterpreterError("invalid command type");
    }

    public static boolean isCompound(String string) {
        return string.indexOf(46) != -1;
    }

    static int countParts(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(46, n2 + 1)) != -1) {
            ++n;
        }
        return n + 1;
    }

    static String prefix(String string) {
        if (!Name.isCompound(string)) {
            return null;
        }
        return Name.prefix(string, Name.countParts(string) - 1);
    }

    static String prefix(String string, int n) {
        if (n < 1) {
            return null;
        }
        int n2 = 0;
        int n3 = -1;
        while ((n3 = string.indexOf(46, n3 + 1)) != -1 && ++n2 < n) {
        }
        return n3 == -1 ? string : string.substring(0, n3);
    }

    static String suffix(String string) {
        if (!Name.isCompound(string)) {
            return null;
        }
        return Name.suffix(string, Name.countParts(string) - 1);
    }

    public static String suffix(String string, int n) {
        if (n < 1) {
            return null;
        }
        int n2 = 0;
        int n3 = string.length() + 1;
        while ((n3 = string.lastIndexOf(46, n3 - 1)) != -1 && ++n2 < n) {
        }
        return n3 == -1 ? string : string.substring(n3 + 1);
    }

    public String toString() {
        return this.value;
    }
}

