/*
 * Decompiled with CFR 0.152.
 */
package com.mentorgen.tools.profile.instrument;

import com.mentorgen.tools.profile.Controller;
import org.objectweb.asm.jip.Label;
import org.objectweb.asm.jip.MethodAdapter;
import org.objectweb.asm.jip.MethodVisitor;

public class PerfMethodAdapter
extends MethodAdapter {
    private String _className;
    private String _methodName;
    private boolean _clinit = false;
    private boolean _init = false;

    public PerfMethodAdapter(MethodVisitor methodVisitor, String string, String string2) {
        super(methodVisitor);
        this._className = string;
        this._methodName = string2;
        if (string2.equals("<clinit>")) {
            this._clinit = true;
        } else if (string2.startsWith("<init>")) {
            this._init = true;
        }
    }

    public void visitCode() {
        if (this._clinit) {
            super.visitCode();
            return;
        }
        if (Controller._trackObjectAlloc && this._init) {
            this.visitLdcInsn(this._className);
            this.visitMethodInsn(184, Controller._profiler, "alloc", "(Ljava/lang/String;)V");
        }
        this.visitLdcInsn(this._className);
        this.visitLdcInsn(this._methodName);
        this.visitMethodInsn(184, Controller._profiler, "start", "(Ljava/lang/String;Ljava/lang/String;)V");
        super.visitCode();
    }

    public void visitInsn(int n) {
        if (this._clinit) {
            super.visitInsn(n);
            return;
        }
        switch (n) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                this.visitLdcInsn(this._className);
                this.visitLdcInsn(this._methodName);
                this.visitMethodInsn(184, Controller._profiler, "end", "(Ljava/lang/String;Ljava/lang/String;)V");
                break;
            }
        }
        if (194 == n) {
            this.visitLdcInsn(this._className);
            this.visitLdcInsn(this._methodName);
            this.visitMethodInsn(184, Controller._profiler, "beginWait", "(Ljava/lang/String;Ljava/lang/String;)V");
            super.visitInsn(n);
            this.visitLdcInsn(this._className);
            this.visitLdcInsn(this._methodName);
            this.visitMethodInsn(184, Controller._profiler, "endWait", "(Ljava/lang/String;Ljava/lang/String;)V");
        } else {
            super.visitInsn(n);
        }
    }

    public void visitMethodInsn(int n, String string, String string2, String string3) {
        if (PerfMethodAdapter.isWaitInsn(n, string, string2, string3)) {
            this.visitLdcInsn(this._className);
            this.visitLdcInsn(this._methodName);
            this.visitMethodInsn(184, Controller._profiler, "beginWait", "(Ljava/lang/String;Ljava/lang/String;)V");
            super.visitMethodInsn(n, string, string2, string3);
            this.visitLdcInsn(this._className);
            this.visitLdcInsn(this._methodName);
            this.visitMethodInsn(184, Controller._profiler, "endWait", "(Ljava/lang/String;Ljava/lang/String;)V");
        } else {
            super.visitMethodInsn(n, string, string2, string3);
        }
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        super.visitTryCatchBlock(label, label2, label3, string);
        if (string != null && !this._clinit) {
            label3.info = new ExceptionInfo(string);
        }
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        if (label.info instanceof ExceptionInfo) {
            this.visitLdcInsn(this._className);
            this.visitLdcInsn(this._methodName);
            this.visitLdcInsn(((ExceptionInfo)label.info).type);
            this.visitMethodInsn(184, Controller._profiler, "unwind", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
        }
    }

    private static boolean isWaitInsn(int n, String string, String string2, String string3) {
        boolean bl;
        boolean bl2 = bl = n == 182 && "java/lang/Object".equals(string) && "wait".equals(string2) && ("()V".equals(string3) || "(J)V".equals(string3) || "(JI)V".equals(string3));
        if (bl) {
            return true;
        }
        boolean bl3 = bl = n == 182 && "java/lang/Thread".equals(string) && "join".equals(string2) && ("()V".equals(string3) || "(J)V".equals(string3) || "(JI)V".equals(string3));
        if (bl) {
            return true;
        }
        boolean bl4 = bl = n == 184 && "java/lang/Thread".equals(string) && "sleep".equals(string2) && ("(J)V".equals(string3) || "(JI)V".equals(string3));
        if (bl) {
            return true;
        }
        boolean bl5 = bl = n == 184 && "java/lang/Thread".equals(string) && "yield".equals(string2) && "()V".equals(string3);
        if (bl) {
            return true;
        }
        return bl;
    }

    class ExceptionInfo {
        String type;

        ExceptionInfo(String string) {
            this.type = string;
        }
    }
}

