/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.server;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import sbt.CommandSource;
import sbt.Def$;
import sbt.Keys$;
import sbt.StandardMain$;
import sbt.State;
import sbt.State$;
import sbt.Task;
import sbt.internal.CommandChannel;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.MixedAnalyzingCompiler$;
import sbt.internal.langserver.ErrorCodes$;
import sbt.internal.langserver.Location;
import sbt.internal.langserver.Location$;
import sbt.internal.langserver.Position$;
import sbt.internal.langserver.Range$;
import sbt.internal.langserver.TextDocumentPositionParams;
import sbt.internal.langserver.codec.JsonProtocol$;
import sbt.internal.protocol.JsonRpcResponseError;
import sbt.internal.protocol.JsonRpcResponseError$;
import sbt.internal.protocol.codec.JsonRPCProtocol$;
import sbt.internal.server.Definition$AnalysesAccess$;
import sbt.internal.server.Definition$textProcessor$;
import sbt.internal.util.AList$;
import sbt.internal.util.Init;
import sbt.io.IO$;
import sbt.std.FullInstance$;
import sbt.util.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.ParSeq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scalacache.Cache;
import scalacache.Flags;
import scalacache.Flags$;
import scalacache.Mode;
import scalacache.modes;
import sjsonnew.JsonFormat;
import sjsonnew.JsonReader;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.scalajson.unsafe.CompactPrinter$;
import sjsonnew.support.scalajson.unsafe.Converter$;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.Setup;

public final class Definition$ {
    public static Definition$ MODULE$;

    static {
        new Definition$();
    }

    public <A> void send(CommandSource source, String execId, A params, JsonFormat<A> evidence$1) {
        StandardMain$.MODULE$.exchange().channels().collectFirst((PartialFunction)new scala.Serializable(source){
            public static final long serialVersionUID = 0L;
            private final CommandSource source$1;

            public final <A1 extends CommandChannel, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                String string = A1.name();
                String string2 = this.source$1.channelName();
                Object object = !(string != null ? !string.equals(string2) : string2 != null) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(CommandChannel x1) {
                CommandChannel commandChannel = x1;
                String string = commandChannel.name();
                String string2 = this.source$1.channelName();
                boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                return bl;
            }
            {
                this.source$1 = source$1;
            }
        }).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            channel.publishEvent(params, Option$.MODULE$.apply((Object)execId), evidence$1);
            return BoxedUnit.UNIT;
        });
    }

    private Option<TextDocumentPositionParams> getDefinition(JValue jsonDefinition) {
        return Converter$.MODULE$.fromJson((Object)jsonDefinition, (JsonReader)JsonProtocol$.MODULE$.TextDocumentPositionParamsFormat()).toOption();
    }

    public Option<Analysis> sbt$internal$server$Definition$$storeAnalysis(File cacheFile, boolean useBinary) {
        return JavaInterfaceUtil$.MODULE$.EnrichOptional(MixedAnalyzingCompiler$.MODULE$.staticCachedStore(cacheFile, !useBinary).get()).toOption().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getAnalysis()).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends CompileAnalysis, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                Analysis analysis;
                A1 A1 = x10;
                Object object = A1 instanceof Analysis ? (analysis = (Analysis)A1) : function1.apply(x10);
                return (B1)object;
            }

            public final boolean isDefinedAt(CompileAnalysis x10) {
                CompileAnalysis compileAnalysis = x10;
                boolean bl = compileAnalysis instanceof Analysis;
                return bl;
            }
        });
    }

    public <F> F updateCache(Cache<Object> cache, String cacheFile, boolean useBinary, Mode<F> mode, Flags flags) {
        return (F)mode.M().flatMap(Definition$AnalysesAccess$.MODULE$.getFrom(cache, mode, flags), (Function1 & Serializable & scala.Serializable)x0$6 -> {
            Object f;
            Option option = x0$6;
            if (None$.MODULE$.equals(option)) {
                f = Definition$AnalysesAccess$.MODULE$.putIn(cache, (scala.collection.immutable.Set<Tuple2<Tuple2<String, Object>, Option<Analysis>>>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cacheFile), (Object)BoxesRunTime.boxToBoolean((boolean)useBinary))), (Object)None$.MODULE$)}))), (Option<Duration>)Option$.MODULE$.apply((Object)Duration$.MODULE$.Inf()), mode, flags);
            } else if (option instanceof Some) {
                Some some = (Some)option;
                scala.collection.immutable.Set set = (scala.collection.immutable.Set)some.value();
                scala.collection.immutable.Set newSet = (scala.collection.immutable.Set)((SetLike)set.filterNot((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)Definition$.$anonfun$updateCache$2(cacheFile, x0$7)))).$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cacheFile), (Object)BoxesRunTime.boxToBoolean((boolean)useBinary))), (Object)None$.MODULE$));
                f = Definition$AnalysesAccess$.MODULE$.putIn(cache, (scala.collection.immutable.Set<Tuple2<Tuple2<String, Object>, Option<Analysis>>>)newSet, (Option<Duration>)Option$.MODULE$.apply((Object)Duration$.MODULE$.Inf()), mode, flags);
            } else {
                throw new MatchError((Object)option);
            }
            return f;
        });
    }

    public Init.Initialize<Task<Object>> collectAnalysesTask() {
        return (Init.Initialize)FullInstance$.MODULE$.app((Object)new Tuple3(Keys$.MODULE$.state(), (Object)Def$.MODULE$.toITask(Keys$.MODULE$.enableBinaryCompileAnalysis()), Keys$.MODULE$.compileIncSetup()), (Function1 & Serializable & scala.Serializable)$p$macro$159 -> {
            State state = (State)$p$macro$159._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)$p$macro$159._2());
            Setup setup = (Setup)$p$macro$159._3();
            String cacheFile = setup.cacheFile().getAbsolutePath();
            boolean useBinary = bl;
            State s = state;
            State$.MODULE$.stateOps(s).log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("analysis location ").append(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cacheFile), (Object)BoxesRunTime.boxToBoolean((boolean)useBinary))).toString());
            return MODULE$.updateCache(StandardMain$.MODULE$.cache(), cacheFile, useBinary, modes.sync$.MODULE$.mode(), Flags$.MODULE$.defaultFlags());
        }, AList$.MODULE$.tuple3());
    }

    public Future<Seq<Analysis>> getAnalyses() {
        return ((Future)Definition$AnalysesAccess$.MODULE$.getFrom(StandardMain$.MODULE$.cache(), modes.scalaFuture$.MODULE$.mode(ExecutionContext.Implicits$.MODULE$.global()), Flags$.MODULE$.defaultFlags())).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Option<scala.collection.immutable.Set<Tuple2<Tuple2<String, Object>, Option<Analysis>>>>, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x11;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    scala.collection.immutable.Set a = (scala.collection.immutable.Set)some.value();
                    object = a;
                } else {
                    object = function1.apply(x11);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<scala.collection.immutable.Set<Tuple2<Tuple2<String, Object>, Option<Analysis>>>> x11) {
                Option<scala.collection.immutable.Set<Tuple2<Tuple2<String, Object>, Option<Analysis>>>> option = x11;
                boolean bl = option instanceof Some;
                return bl;
            }
        }, ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)caches -> {
            Tuple2 tuple2 = caches.partition((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)Definition$.$anonfun$getAnalyses$2(x0$8)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Set working = (scala.collection.immutable.Set)tuple2._1();
            scala.collection.immutable.Set uninitialized = (scala.collection.immutable.Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)working, (Object)uninitialized);
            Tuple2 tuple23 = tuple22;
            scala.collection.immutable.Set working2 = (scala.collection.immutable.Set)tuple23._1();
            scala.collection.immutable.Set uninitialized2 = (scala.collection.immutable.Set)tuple23._2();
            scala.collection.immutable.Set addToCache = (scala.collection.immutable.Set)uninitialized2.collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<Tuple2<String, Object>, Option<Analysis>>, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                    Object object;
                    Tuple2 title;
                    A1 A1 = x12;
                    if (A1 != null && (title = (Tuple2)A1._1()) != null) {
                        String file = (String)title._1();
                        boolean useBinary = title._2$mcZ$sp();
                        if (Files.exists(Paths.get(file, new String[0]), new LinkOption[0])) {
                            object = new Tuple2((Object)title, Definition$.MODULE$.sbt$internal$server$Definition$$storeAnalysis(Paths.get(file, new String[0]).toFile(), !useBinary));
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x12);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<Tuple2<String, Object>, Option<Analysis>> x12) {
                    String file;
                    Tuple2 title;
                    Tuple2<Tuple2<String, Object>, Option<Analysis>> tuple2 = x12;
                    boolean bl = tuple2 != null && (title = (Tuple2)tuple2._1()) != null && Files.exists(Paths.get(file = (String)title._1(), new String[0]), new LinkOption[0]);
                    return bl;
                }
            }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
            scala.collection.immutable.Set validCaches = (scala.collection.immutable.Set)working2.$plus$plus((GenTraversableOnce)addToCache);
            Object object = addToCache.nonEmpty() ? Definition$AnalysesAccess$.MODULE$.putIn(StandardMain$.MODULE$.cache(), (scala.collection.immutable.Set<Tuple2<Tuple2<String, Object>, Option<Analysis>>>)validCaches, (Option<Duration>)Option$.MODULE$.apply((Object)Duration$.MODULE$.Inf()), modes.scalaFuture$.MODULE$.mode(ExecutionContext.Implicits$.MODULE$.global()), Flags$.MODULE$.defaultFlags()) : BoxedUnit.UNIT;
            return (Seq)validCaches.toSeq().collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<Tuple2<String, Object>, Option<Analysis>>, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                    Object object;
                    Option option;
                    A1 A1 = x13;
                    if (A1 != null && (option = (Option)A1._2()) instanceof Some) {
                        Some some = (Some)option;
                        Analysis analysis = (Analysis)some.value();
                        object = analysis;
                    } else {
                        object = function1.apply(x13);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<Tuple2<String, Object>, Option<Analysis>> x13) {
                    Option option;
                    Tuple2<Tuple2<String, Object>, Option<Analysis>> tuple2 = x13;
                    boolean bl = tuple2 != null && (option = (Option)tuple2._2()) instanceof Some;
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<BoxedUnit> lspDefinition(JValue jsonDefinition, String requestId, CommandSource commandSource, Logger log, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LazyRef analyses$lzy = new LazyRef();
            String LspDefinitionLogHead = "lsp-definition";
            String jsonDefinitionString = CompactPrinter$.MODULE$.apply(jsonDefinition);
            log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append(LspDefinitionLogHead).append(" json request: ").append(jsonDefinitionString).toString());
            Option option = MODULE$.getDefinition(jsonDefinition).flatMap((Function1 & Serializable & scala.Serializable)definition -> {
                URI uri = URI.create(definition.textDocument().uri());
                return JavaInterfaceUtil$.MODULE$.EnrichOptional(Files.lines(Paths.get(uri)).skip(definition.position().line()).findFirst()).toOption().flatMap((Function1 & Serializable & scala.Serializable)line -> {
                    log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append(LspDefinitionLogHead).append(" found line: ").append((String)line).toString());
                    return Definition$textProcessor$.MODULE$.identifier((String)line, (int)definition.position().character());
                });
            });
            if (option instanceof Some) {
                Some some = (Some)option;
                String sym = (String)some.value();
                log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("symbol ").append(sym).toString());
                Definition$.analyses$1(analyses$lzy).map((Function1 & Serializable & scala.Serializable)analyses -> {
                    Definition$.$anonfun$lspDefinition$7(requestId, commandSource, log, LspDefinitionLogHead, sym, analyses);
                    return BoxedUnit.UNIT;
                }, ec).recover((PartialFunction)new scala.Serializable(requestId, commandSource, log, jsonDefinitionString){
                    public static final long serialVersionUID = 0L;
                    private final String requestId$1;
                    private final CommandSource commandSource$1;
                    private final Logger log$1;
                    private final String jsonDefinitionString$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x15, Function1<A1, B1> function1) {
                        A1 A1 = x15;
                        this.log$1.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Problem with processing analyses ").append(A1).append(" for ").append($this.jsonDefinitionString$1).toString());
                        JsonRpcResponseError rsp = JsonRpcResponseError$.MODULE$.apply(ErrorCodes$.MODULE$.InternalError(), "Problem with processing analyses.", (Option)None$.MODULE$);
                        Definition$.MODULE$.send(this.commandSource$1, this.requestId$1, rsp, JsonRPCProtocol$.MODULE$.JsonRpcResponseErrorFormat());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return (B1)boxedUnit;
                    }

                    public final boolean isDefinedAt(Throwable x15) {
                        Throwable throwable = x15;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        this.requestId$1 = requestId$1;
                        this.commandSource$1 = commandSource$1;
                        this.log$1 = log$1;
                        this.jsonDefinitionString$1 = jsonDefinitionString$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(sbt.internal.server.Definition$$anonfun$$nestedInanonfun$lspDefinition$1$1 java.lang.Throwable )}, serializedLambda);
                    }
                }, ec);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Symbol not found in definition request ").append(jsonDefinitionString).toString());
                MODULE$.send(commandSource, requestId, (Object)Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Location.class)), (JsonFormat)JsonProtocol$.MODULE$.arrayFormat(JsonProtocol$.MODULE$.LocationFormat(), ClassTag$.MODULE$.apply(Location.class)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }, ec);
    }

    public static final /* synthetic */ boolean $anonfun$updateCache$2(String cacheFile$2, Tuple2 x0$7) {
        String file;
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$7;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
            throw new MatchError((Object)tuple22);
        }
        String string = file = (String)tuple2._1();
        String string2 = cacheFile$2;
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getAnalyses$2(Tuple2 x0$8) {
        Option option;
        boolean bl;
        Option option2;
        Tuple2 tuple2 = x0$8;
        if (tuple2 != null && (option2 = (Option)tuple2._2()) instanceof Some) {
            bl = true;
        } else if (tuple2 != null && None$.MODULE$.equals(option = (Option)tuple2._2())) {
            bl = false;
        } else {
            throw new MatchError((Object)tuple2);
        }
        return bl;
    }

    private static final /* synthetic */ Future analyses$lzycompute$1(LazyRef analyses$lzy$1) {
        Future future;
        LazyRef lazyRef = analyses$lzy$1;
        synchronized (lazyRef) {
            future = analyses$lzy$1.initialized() ? (Future)analyses$lzy$1.value() : (Future)analyses$lzy$1.initialize(MODULE$.getAnalyses());
        }
        return future;
    }

    private static final Future analyses$1(LazyRef analyses$lzy$1) {
        return analyses$lzy$1.initialized() ? (Future)analyses$lzy$1.value() : Definition$.analyses$lzycompute$1(analyses$lzy$1);
    }

    public static final /* synthetic */ void $anonfun$lspDefinition$7(String requestId$1, CommandSource commandSource$1, Logger log$1, String LspDefinitionLogHead$1, String sym$2, Seq analyses) {
        Seq locations = (Seq)((ParIterableLike)((ParIterableLike)analyses.par()).flatMap((Function1 & Serializable & scala.Serializable)analysis -> {
            PartialFunction<String, String> selectPotentials = Definition$textProcessor$.MODULE$.potentialClsOrTraitOrObj(sym$2);
            Set classes = (Set)analysis.apis().allInternalClasses().$plus$plus((GenTraversableOnce)analysis.apis().allExternals()).collect(selectPotentials, Set$.MODULE$.canBuildFrom());
            log$1.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append(LspDefinitionLogHead$1).append(" potentials: ").append(classes).toString());
            return (Set)((TraversableLike)classes.flatMap((Function1 & Serializable & scala.Serializable)className -> (scala.collection.immutable.Set)analysis.relations().definesClass(className).$plus$plus((GenTraversableOnce)analysis.relations().libraryDefinesClass(className)), Set$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)classFile -> (Seq)Definition$textProcessor$.MODULE$.markPosition((File)classFile, sym$2).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Tuple4<File, Object, Object, Object>, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x14;
                    if (A1 != null) {
                        File file = (File)A1._1();
                        long line = BoxesRunTime.unboxToLong((Object)A1._2());
                        long from = BoxesRunTime.unboxToLong((Object)A1._3());
                        long to = BoxesRunTime.unboxToLong((Object)A1._4());
                        object = Location$.MODULE$.apply(IO$.MODULE$.toURI(file).toString(), Range$.MODULE$.apply(Position$.MODULE$.apply(line, from), Position$.MODULE$.apply(line, to)));
                    } else {
                        object = function1.apply(x14);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple4<File, Object, Object, Object> x14) {
                    Tuple4<File, Object, Object, Object> tuple4 = x14;
                    boolean bl = tuple4 != null;
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom());
        }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).seq();
        log$1.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append(LspDefinitionLogHead$1).append(" locations ").append(locations).toString());
        MODULE$.send(commandSource$1, requestId$1, (Object)locations.toArray(ClassTag$.MODULE$.apply(Location.class)), (JsonFormat)JsonProtocol$.MODULE$.arrayFormat(JsonProtocol$.MODULE$.LocationFormat(), ClassTag$.MODULE$.apply(Location.class)));
    }

    private Definition$() {
        MODULE$ = this;
    }
}

