/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.DoorOrWindow;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomeObject;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Light;
import com.eteks.sweethome3d.model.PieceOfFurniture;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.HomeFurnitureController;
import com.eteks.sweethome3d.viewcontroller.ImportedFurnitureWizardController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private View furnitureView;
    private HomePieceOfFurniture leadSelectedPieceOfFurniture;

    public FurnitureController(Home home, UserPreferences userPreferences, ViewFactory viewFactory) {
        this(home, userPreferences, viewFactory, null, null);
    }

    public FurnitureController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.contentManager = contentManager;
        this.addModelListeners();
    }

    @Override
    public View getView() {
        if (this.furnitureView == null) {
            this.furnitureView = this.viewFactory.createFurnitureView(this.home, this.preferences, this);
        }
        return this.furnitureView;
    }

    private void addModelListeners() {
        this.home.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                List<HomePieceOfFurniture> list = Home.getFurnitureSubList(FurnitureController.this.home.getSelectedItems());
                if (list.isEmpty()) {
                    FurnitureController.this.leadSelectedPieceOfFurniture = null;
                } else if (FurnitureController.this.leadSelectedPieceOfFurniture == null || list.size() == 1 || list.indexOf(FurnitureController.this.leadSelectedPieceOfFurniture) == -1) {
                    FurnitureController.this.leadSelectedPieceOfFurniture = list.get(0);
                }
            }
        });
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (HomePieceOfFurniture.Property.MOVABLE.name().equals(propertyChangeEvent.getPropertyName())) {
                    List<Selectable> list;
                    HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)propertyChangeEvent.getSource();
                    if (FurnitureController.this.home.isBasePlanLocked() && FurnitureController.this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurniture) && (list = FurnitureController.this.home.getSelectedItems()).contains(homePieceOfFurniture)) {
                        list = new ArrayList<Selectable>(list);
                        list.remove(homePieceOfFurniture);
                        FurnitureController.this.home.setSelectedItems(list);
                    }
                }
            }
        };
        for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
            homePieceOfFurniture.addPropertyChangeListener(propertyChangeListener);
        }
        this.home.addFurnitureListener(new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener);
                }
            }
        });
    }

    public void addFurniture(List<HomePieceOfFurniture> list) {
        this.addFurniture(list, null);
    }

    public void addFurnitureToGroup(List<HomePieceOfFurniture> list, HomeFurnitureGroup homeFurnitureGroup) {
        if (homeFurnitureGroup == null) {
            throw new IllegalArgumentException("Group shouldn't be null");
        }
        this.addFurniture(list, homeFurnitureGroup);
    }

    private void addFurniture(List<HomePieceOfFurniture> list, HomeFurnitureGroup homeFurnitureGroup) {
        boolean bl;
        final boolean bl2 = this.home.isBasePlanLocked();
        final boolean bl3 = this.home.isAllLevelsSelection();
        final List<Selectable> list2 = this.home.getSelectedItems();
        final HomePieceOfFurniture[] homePieceOfFurnitureArray = list.toArray(new HomePieceOfFurniture[list.size()]);
        final int[] nArray = new int[list.size()];
        final HomeFurnitureGroup[] homeFurnitureGroupArray = homeFurnitureGroup != null ? new HomeFurnitureGroup[list.size()] : null;
        int n = homeFurnitureGroup == null ? this.home.getFurniture().size() : homeFurnitureGroup.getFurniture().size();
        boolean bl4 = bl2;
        for (bl = false; bl < nArray.length; bl += 1) {
            nArray[bl] = n++;
            bl4 &= !this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurnitureArray[bl]);
            if (homeFurnitureGroupArray == null) continue;
            homeFurnitureGroupArray[bl] = homeFurnitureGroup;
        }
        bl = bl4;
        final Level level = this.home.getSelectedLevel();
        this.doAddFurniture(homePieceOfFurnitureArray, homeFurnitureGroupArray, nArray, level, null, bl, false);
        if (this.undoSupport != null) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                public void undo() throws CannotUndoException {
                    super.undo();
                    FurnitureController.this.doDeleteFurniture(homePieceOfFurnitureArray, bl2, bl3);
                    FurnitureController.this.home.setSelectedItems(list2);
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    FurnitureController.this.doAddFurniture(homePieceOfFurnitureArray, homeFurnitureGroupArray, nArray, level, null, bl, false);
                }

                public String getPresentationName() {
                    return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoAddFurnitureName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void doAddFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, HomeFurnitureGroup[] homeFurnitureGroupArray, int[] nArray, Level level, Level[] levelArray, boolean bl, boolean bl2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (homeFurnitureGroupArray != null && homeFurnitureGroupArray[i] != null) {
                this.home.addPieceOfFurnitureToGroup(homePieceOfFurnitureArray[i], homeFurnitureGroupArray[i], nArray[i]);
                homePieceOfFurnitureArray[i].setVisible(homeFurnitureGroupArray[i].isVisible());
            } else {
                this.home.addPieceOfFurniture(homePieceOfFurnitureArray[i], nArray[i]);
            }
            homePieceOfFurnitureArray[i].setLevel(levelArray != null ? levelArray[i] : level);
        }
        this.home.setBasePlanLocked(bl);
        this.home.setSelectedItems(Arrays.asList(homePieceOfFurnitureArray));
        this.home.setAllLevelsSelection(bl2);
    }

    public void deleteSelection() {
        this.deleteFurniture(Home.getFurnitureSubList(this.home.getSelectedItems()));
    }

    public void deleteFurniture(List<HomePieceOfFurniture> list) {
        Object object;
        Object object2;
        Object object4;
        boolean bl;
        boolean bl2 = this.home.isBasePlanLocked();
        boolean bl3 = this.home.isAllLevelsSelection();
        List<Selectable> list2 = this.home.getSelectedItems();
        List<HomePieceOfFurniture> list3 = this.home.getFurniture();
        list = new ArrayList<HomePieceOfFurniture>(list);
        ArrayList<HomeFurnitureGroup> arrayList = new ArrayList<HomeFurnitureGroup>();
        this.searchGroups(list3, arrayList);
        do {
            bl = false;
            for (HomeFurnitureGroup homeFurnitureGroup : arrayList) {
                object4 = homeFurnitureGroup.getFurniture();
                if (!list.containsAll((Collection<?>)object4)) continue;
                list.removeAll((Collection<?>)object4);
                list.add(homeFurnitureGroup);
                bl = true;
            }
        } while (bl);
        HashMap hashMap = new HashMap();
        int n = 0;
        for (HomePieceOfFurniture object32 : list) {
            if (!this.isPieceOfFurnitureDeletable(object32)) continue;
            object2 = this.getPieceOfFurnitureGroup(object32, null, list3);
            object = (Map)hashMap.get(object2);
            if (object == null) {
                object = new TreeMap();
                hashMap.put(object2, object);
            }
            if (object2 == null) {
                object.put(list3.indexOf(object32), object32);
            } else {
                object.put(((HomeFurnitureGroup)object2).getFurniture().indexOf(object32), object32);
            }
            ++n;
        }
        object4 = new HomePieceOfFurniture[n];
        int[] nArray = new int[((HomePieceOfFurniture[])object4).length];
        object2 = new Level[((HomePieceOfFurniture[])object4).length];
        object = new HomeFurnitureGroup[((HomePieceOfFurniture[])object4).length];
        int n2 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                object4[n2] = (HomePieceOfFurniture)entry2.getValue();
                nArray[n2] = (Integer)entry2.getKey();
                object2[n2] = object4[n2].getLevel();
                object[n2++] = (HomeFurnitureGroup)entry.getKey();
            }
        }
        this.doDeleteFurniture((HomePieceOfFurniture[])object4, bl2, false);
        if (this.undoSupport != null) {
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit((HomePieceOfFurniture[])object4, (HomeFurnitureGroup[])object, nArray, (Level[])object2, bl2, bl3, list2){
                final /* synthetic */ HomePieceOfFurniture[] val$furniture;
                final /* synthetic */ HomeFurnitureGroup[] val$furnitureGroups;
                final /* synthetic */ int[] val$furnitureIndex;
                final /* synthetic */ Level[] val$furnitureLevels;
                final /* synthetic */ boolean val$basePlanLocked;
                final /* synthetic */ boolean val$allLevelsSelection;
                final /* synthetic */ List val$oldSelection;
                {
                    this.val$furniture = homePieceOfFurnitureArray;
                    this.val$furnitureGroups = homeFurnitureGroupArray;
                    this.val$furnitureIndex = nArray;
                    this.val$furnitureLevels = levelArray;
                    this.val$basePlanLocked = bl;
                    this.val$allLevelsSelection = bl2;
                    this.val$oldSelection = list;
                }

                public void undo() throws CannotUndoException {
                    super.undo();
                    FurnitureController.this.doAddFurniture(this.val$furniture, this.val$furnitureGroups, this.val$furnitureIndex, null, this.val$furnitureLevels, this.val$basePlanLocked, this.val$allLevelsSelection);
                    FurnitureController.this.home.setSelectedItems(this.val$oldSelection);
                }

                public void redo() throws CannotRedoException {
                    super.redo();
                    FurnitureController.this.home.setSelectedItems(Arrays.asList(this.val$furniture));
                    FurnitureController.this.doDeleteFurniture(this.val$furniture, this.val$basePlanLocked, false);
                }

                public String getPresentationName() {
                    return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoDeleteSelectionName", new Object[0]);
                }
            };
            this.undoSupport.postEdit(abstractUndoableEdit);
        }
    }

    private void doDeleteFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, boolean bl, boolean bl2) {
        for (HomePieceOfFurniture homePieceOfFurniture : homePieceOfFurnitureArray) {
            this.home.deletePieceOfFurniture(homePieceOfFurniture);
        }
        this.home.setBasePlanLocked(bl);
        this.home.setAllLevelsSelection(bl2);
    }

    private void searchGroups(List<HomePieceOfFurniture> list, List<HomeFurnitureGroup> list2) {
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
            list2.add((HomeFurnitureGroup)homePieceOfFurniture);
            this.searchGroups(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture(), list2);
        }
    }

    private HomeFurnitureGroup getPieceOfFurnitureGroup(HomePieceOfFurniture homePieceOfFurniture, HomeFurnitureGroup homeFurnitureGroup, List<HomePieceOfFurniture> list) {
        for (HomePieceOfFurniture homePieceOfFurniture2 : list) {
            HomeFurnitureGroup homeFurnitureGroup2;
            if (homePieceOfFurniture2.equals(homePieceOfFurniture)) {
                return homeFurnitureGroup;
            }
            if (!(homePieceOfFurniture2 instanceof HomeFurnitureGroup) || (homeFurnitureGroup2 = this.getPieceOfFurnitureGroup(homePieceOfFurniture, (HomeFurnitureGroup)homePieceOfFurniture2, ((HomeFurnitureGroup)homePieceOfFurniture2).getFurniture())) == null) continue;
            return homeFurnitureGroup2;
        }
        return null;
    }

    public void setSelectedFurniture(List<HomePieceOfFurniture> list) {
        if (this.home.isBasePlanLocked()) {
            list = this.getFurnitureNotPartOfBasePlan(list);
        }
        this.home.setSelectedItems(list);
        this.home.setAllLevelsSelection(false);
    }

    public void selectAll() {
        this.setSelectedFurniture(this.home.getFurniture());
    }

    protected boolean isPieceOfFurniturePartOfBasePlan(HomePieceOfFurniture homePieceOfFurniture) {
        return !homePieceOfFurniture.isMovable() || homePieceOfFurniture.isDoorOrWindow();
    }

    protected boolean isPieceOfFurnitureMovable(HomePieceOfFurniture homePieceOfFurniture) {
        return true;
    }

    protected boolean isPieceOfFurnitureDeletable(HomePieceOfFurniture homePieceOfFurniture) {
        return true;
    }

    public HomePieceOfFurniture createHomePieceOfFurniture(PieceOfFurniture pieceOfFurniture) {
        if (pieceOfFurniture instanceof DoorOrWindow) {
            return new HomeDoorOrWindow((DoorOrWindow)pieceOfFurniture);
        }
        if (pieceOfFurniture instanceof Light) {
            return new HomeLight((Light)pieceOfFurniture);
        }
        return new HomePieceOfFurniture(pieceOfFurniture);
    }

    private List<HomePieceOfFurniture> getFurnitureNotPartOfBasePlan(List<HomePieceOfFurniture> list) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurniture)) continue;
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    public void toggleFurnitureSort(HomePieceOfFurniture.SortableProperty sortableProperty) {
        if (sortableProperty.equals((Object)this.home.getFurnitureSortedProperty())) {
            this.home.setFurnitureSortedProperty(null);
        } else {
            this.home.setFurnitureSortedProperty(sortableProperty);
        }
    }

    public void toggleFurnitureSortOrder() {
        this.home.setFurnitureDescendingSorted(!this.home.isFurnitureDescendingSorted());
    }

    public void sortFurniture(HomePieceOfFurniture.SortableProperty sortableProperty) {
        HomePieceOfFurniture.SortableProperty sortableProperty2 = this.home.getFurnitureSortedProperty();
        boolean bl = this.home.isFurnitureDescendingSorted();
        boolean bl2 = false;
        if (sortableProperty.equals((Object)sortableProperty2)) {
            if (bl) {
                sortableProperty = null;
            } else {
                bl2 = true;
            }
        }
        this.home.setFurnitureSortedProperty(sortableProperty);
        this.home.setFurnitureDescendingSorted(bl2);
    }

    public void setFurnitureVisibleProperties(List<HomePieceOfFurniture.SortableProperty> list) {
        this.home.setFurnitureVisibleProperties(list);
    }

    public void toggleFurnitureVisibleProperty(HomePieceOfFurniture.SortableProperty sortableProperty) {
        ArrayList<HomePieceOfFurniture.SortableProperty> arrayList = new ArrayList<HomePieceOfFurniture.SortableProperty>(this.home.getFurnitureVisibleProperties());
        if (arrayList.contains((Object)sortableProperty)) {
            arrayList.remove((Object)sortableProperty);
            if (arrayList.isEmpty()) {
                arrayList.add(HomePieceOfFurniture.SortableProperty.NAME);
            }
        } else {
            List<HomePieceOfFurniture.SortableProperty> list = Arrays.asList(HomePieceOfFurniture.SortableProperty.CATALOG_ID, HomePieceOfFurniture.SortableProperty.NAME, HomePieceOfFurniture.SortableProperty.CREATOR, HomePieceOfFurniture.SortableProperty.WIDTH, HomePieceOfFurniture.SortableProperty.DEPTH, HomePieceOfFurniture.SortableProperty.HEIGHT, HomePieceOfFurniture.SortableProperty.X, HomePieceOfFurniture.SortableProperty.Y, HomePieceOfFurniture.SortableProperty.ELEVATION, HomePieceOfFurniture.SortableProperty.ANGLE, HomePieceOfFurniture.SortableProperty.LEVEL, HomePieceOfFurniture.SortableProperty.MODEL_SIZE, HomePieceOfFurniture.SortableProperty.COLOR, HomePieceOfFurniture.SortableProperty.TEXTURE, HomePieceOfFurniture.SortableProperty.MOVABLE, HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW, HomePieceOfFurniture.SortableProperty.VISIBLE, HomePieceOfFurniture.SortableProperty.PRICE, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX_PERCENTAGE, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX, HomePieceOfFurniture.SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED);
            int n = list.indexOf((Object)sortableProperty) - 1;
            if (n > 0) {
                while (n > 0) {
                    int n2 = arrayList.indexOf((Object)list.get(n));
                    if (n2 >= 0) {
                        n = n2 + 1;
                        break;
                    }
                    --n;
                }
            }
            if (n < 0) {
                n = 0;
            }
            arrayList.add(n, sortableProperty);
        }
        this.home.setFurnitureVisibleProperties(arrayList);
    }

    public void modifySelectedFurniture() {
        if (!Home.getFurnitureSubList(this.home.getSelectedItems()).isEmpty()) {
            new HomeFurnitureController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
        }
    }

    public void toggleSelectedFurnitureVisibility() {
        if (Home.getFurnitureSubList(this.home.getSelectedItems()).size() == 1) {
            HomeFurnitureController homeFurnitureController;
            homeFurnitureController.setVisible((homeFurnitureController = new HomeFurnitureController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport)).getVisible() == false);
            homeFurnitureController.modifyFurniture();
        }
    }

    public void groupSelectedFurniture() {
        List<HomePieceOfFurniture> list = this.getMovableSelectedFurniture();
        if (!list.isEmpty()) {
            HomeObject homeObject2;
            TreeMap treeMap;
            Level[] levelArray;
            final boolean bl = this.home.isBasePlanLocked();
            final boolean bl2 = this.home.isAllLevelsSelection();
            List<Selectable> list2 = this.home.getSelectedItems();
            List<HomePieceOfFurniture> list3 = this.home.getFurniture();
            HashMap<Level[], TreeMap<Integer, HomePieceOfFurniture>> hashMap = new HashMap<Level[], TreeMap<Integer, HomePieceOfFurniture>>();
            int n = 0;
            for (HomePieceOfFurniture object22 : list) {
                levelArray = this.getPieceOfFurnitureGroup(object22, null, list3);
                treeMap = (TreeMap)hashMap.get(levelArray);
                if (treeMap == null) {
                    treeMap = new TreeMap();
                    hashMap.put(levelArray, treeMap);
                }
                if (levelArray == null) {
                    treeMap.put(list3.indexOf(object22), object22);
                } else {
                    treeMap.put(levelArray.getFurniture().indexOf(object22), object22);
                }
                ++n;
            }
            final HomePieceOfFurniture[] homePieceOfFurnitureArray = new HomePieceOfFurniture[n];
            final int[] nArray = new int[homePieceOfFurnitureArray.length];
            levelArray = new Level[homePieceOfFurnitureArray.length];
            treeMap = (TreeMap)new float[homePieceOfFurnitureArray.length];
            boolean[] blArray = new boolean[homePieceOfFurnitureArray.length];
            final HomeFurnitureGroup[] homeFurnitureGroupArray = new HomeFurnitureGroup[homePieceOfFurnitureArray.length];
            Level level = this.home.getSelectedLevel();
            int n2 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                for (Map.Entry entry2 : ((TreeMap)entry.getValue()).entrySet()) {
                    HomePieceOfFurniture homePieceOfFurniture;
                    homePieceOfFurnitureArray[n2] = homePieceOfFurniture = (HomePieceOfFurniture)entry2.getValue();
                    nArray[n2] = (Integer)entry2.getKey();
                    levelArray[n2] = homePieceOfFurniture.getLevel();
                    treeMap[n2] = (TreeMap)homePieceOfFurniture.getElevation();
                    blArray[n2] = homePieceOfFurniture.isVisible();
                    homeFurnitureGroupArray[n2] = (HomeFurnitureGroup)entry.getKey();
                    if (levelArray[n2] != null && (level == null || levelArray[n2].getElevation() < level.getElevation())) {
                        level = levelArray[n2];
                    }
                    ++n2;
                }
            }
            final HomeFurnitureGroup homeFurnitureGroup = list.indexOf(this.leadSelectedPieceOfFurniture) > 0 ? this.createHomeFurnitureGroup(Arrays.asList(homePieceOfFurnitureArray), this.leadSelectedPieceOfFurniture) : this.createHomeFurnitureGroup(Arrays.asList(homePieceOfFurnitureArray));
            float[] fArray = new float[homePieceOfFurnitureArray.length];
            n2 = 0;
            for (HomeObject homeObject2 : homePieceOfFurnitureArray) {
                fArray[n2++] = homeObject2.getElevation();
            }
            TreeMap treeMap2 = (TreeMap)hashMap.get(null);
            int n3 = treeMap2 != null ? (Integer)treeMap2.lastKey() + 1 - homePieceOfFurnitureArray.length : list3.size();
            int n4 = homeFurnitureGroup.isMovable() ? 1 : 0;
            homeObject2 = level;
            this.doGroupFurniture(homePieceOfFurnitureArray, new HomeFurnitureGroup[]{homeFurnitureGroup}, null, new int[]{n3}, new Level[]{homeObject2}, bl, false);
            if (this.undoSupport != null) {
                AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit((float[])treeMap, blArray, list2, fArray, n4 != 0, n3, (Level)homeObject2){
                    final /* synthetic */ float[] val$groupPiecesElevation;
                    final /* synthetic */ boolean[] val$groupPiecesVisible;
                    final /* synthetic */ List val$oldSelection;
                    final /* synthetic */ float[] val$groupPiecesNewElevation;
                    final /* synthetic */ boolean val$movable;
                    final /* synthetic */ int val$groupIndex;
                    final /* synthetic */ Level val$groupLevel;
                    {
                        this.val$groupPiecesElevation = fArray;
                        this.val$groupPiecesVisible = blArray;
                        this.val$oldSelection = list;
                        this.val$groupPiecesNewElevation = fArray2;
                        this.val$movable = bl3;
                        this.val$groupIndex = n;
                        this.val$groupLevel = level;
                    }

                    public void undo() throws CannotUndoException {
                        super.undo();
                        FurnitureController.this.doUngroupFurniture(new HomeFurnitureGroup[]{homeFurnitureGroup}, homePieceOfFurnitureArray, homeFurnitureGroupArray, nArray, levelArray, bl, bl2);
                        for (int i = 0; i < homePieceOfFurnitureArray.length; ++i) {
                            homePieceOfFurnitureArray[i].setElevation(this.val$groupPiecesElevation[i]);
                            homePieceOfFurnitureArray[i].setVisible(this.val$groupPiecesVisible[i]);
                        }
                        FurnitureController.this.home.setSelectedItems(this.val$oldSelection);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        for (int i = 0; i < homePieceOfFurnitureArray.length; ++i) {
                            homePieceOfFurnitureArray[i].setElevation(this.val$groupPiecesNewElevation[i]);
                            homePieceOfFurnitureArray[i].setLevel(null);
                        }
                        homeFurnitureGroup.setMovable(this.val$movable);
                        homeFurnitureGroup.setVisible(true);
                        FurnitureController.this.doGroupFurniture(homePieceOfFurnitureArray, new HomeFurnitureGroup[]{homeFurnitureGroup}, null, new int[]{this.val$groupIndex}, new Level[]{this.val$groupLevel}, bl, false);
                    }

                    public String getPresentationName() {
                        return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoGroupName", new Object[0]);
                    }
                };
                this.undoSupport.postEdit(abstractUndoableEdit);
            }
        }
    }

    protected HomeFurnitureGroup createHomeFurnitureGroup(List<HomePieceOfFurniture> list) {
        return this.createHomeFurnitureGroup(list, list.get(0));
    }

    protected HomeFurnitureGroup createHomeFurnitureGroup(List<HomePieceOfFurniture> list, HomePieceOfFurniture homePieceOfFurniture) {
        String string = this.preferences.getLocalizedString(FurnitureController.class, "groupName", this.getFurnitureGroupCount(this.home.getFurniture()) + 1);
        HomeFurnitureGroup homeFurnitureGroup = new HomeFurnitureGroup(list, homePieceOfFurniture, string);
        return homeFurnitureGroup;
    }

    private int getFurnitureGroupCount(List<HomePieceOfFurniture> list) {
        int n = 0;
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
            n += 1 + this.getFurnitureGroupCount(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture());
        }
        return n;
    }

    private void doGroupFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, HomeFurnitureGroup[] homeFurnitureGroupArray, HomeFurnitureGroup[] homeFurnitureGroupArray2, int[] nArray, Level[] levelArray, boolean bl, boolean bl2) {
        this.doDeleteFurniture(homePieceOfFurnitureArray, bl, bl2);
        this.doAddFurniture(homeFurnitureGroupArray, homeFurnitureGroupArray2, nArray, null, levelArray, bl, bl2);
    }

    private void doUngroupFurniture(HomeFurnitureGroup[] homeFurnitureGroupArray, HomePieceOfFurniture[] homePieceOfFurnitureArray, HomeFurnitureGroup[] homeFurnitureGroupArray2, int[] nArray, Level[] levelArray, boolean bl, boolean bl2) {
        this.doDeleteFurniture(homeFurnitureGroupArray, bl, bl2);
        this.doAddFurniture(homePieceOfFurnitureArray, homeFurnitureGroupArray2, nArray, null, levelArray, bl, bl2);
    }

    public void ungroupSelectedFurniture() {
        ArrayList<HomeFurnitureGroup> arrayList = new ArrayList<HomeFurnitureGroup>();
        for (Selectable selectable : this.home.getSelectedItems()) {
            HomeFurnitureGroup homeFurnitureGroup;
            if (!(selectable instanceof HomeFurnitureGroup) || !this.isPieceOfFurnitureMovable(homeFurnitureGroup = (HomeFurnitureGroup)selectable)) continue;
            arrayList.add(homeFurnitureGroup);
        }
        if (!arrayList.isEmpty()) {
            Serializable serializable;
            Object object;
            Level[] levelArray;
            Object object2;
            List<HomePieceOfFurniture> list = this.home.getFurniture();
            boolean bl = this.home.isBasePlanLocked();
            boolean bl2 = this.home.isAllLevelsSelection();
            List<Selectable> list2 = this.home.getSelectedItems();
            HashMap<Object, Level[]> hashMap = new HashMap<Object, Level[]>();
            int n = 0;
            for (HomeFurnitureGroup homeFurnitureGroupArray22 : arrayList) {
                object2 = this.getPieceOfFurnitureGroup(homeFurnitureGroupArray22, null, list);
                levelArray = (Level[])hashMap.get(object2);
                if (levelArray == null) {
                    levelArray = new TreeMap();
                    hashMap.put(object2, levelArray);
                }
                if (object2 == null) {
                    levelArray.put(list.indexOf(homeFurnitureGroupArray22), homeFurnitureGroupArray22);
                } else {
                    levelArray.put(((HomeFurnitureGroup)object2).getFurniture().indexOf(homeFurnitureGroupArray22), homeFurnitureGroupArray22);
                }
                ++n;
            }
            final HomeFurnitureGroup[] homeFurnitureGroupArray3 = new HomeFurnitureGroup[n];
            final HomeFurnitureGroup[] homeFurnitureGroupArray = new HomeFurnitureGroup[homeFurnitureGroupArray3.length];
            object2 = new int[homeFurnitureGroupArray3.length];
            levelArray = new Level[homeFurnitureGroupArray3.length];
            int n2 = 0;
            ArrayList<HomePieceOfFurniture> arrayList2 = new ArrayList<HomePieceOfFurniture>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            ArrayList arrayList4 = new ArrayList();
            for (Map.Entry entry : hashMap.entrySet()) {
                object = (TreeMap)entry.getValue();
                int n3 = (Integer)((TreeMap)object).lastKey() + 1 - ((TreeMap)object).size();
                for (Map.Entry entry2 : ((TreeMap)object).entrySet()) {
                    homeFurnitureGroupArray3[n2] = serializable = (HomeFurnitureGroup)entry2.getValue();
                    homeFurnitureGroupArray[n2] = (HomeFurnitureGroup)entry.getKey();
                    object2[n2] = (Integer)entry2.getKey();
                    levelArray[n2++] = serializable.getLevel();
                    for (HomePieceOfFurniture homePieceOfFurniture : serializable.getFurniture()) {
                        arrayList2.add(homePieceOfFurniture);
                        arrayList4.add(entry.getKey());
                        arrayList3.add(n3++);
                    }
                }
            }
            final HomePieceOfFurniture[] homePieceOfFurnitureArray = arrayList2.toArray(new HomePieceOfFurniture[arrayList2.size()]);
            HomeFurnitureGroup[] homeFurnitureGroupArray2 = arrayList4.toArray(new HomeFurnitureGroup[arrayList4.size()]);
            object = new int[homePieceOfFurnitureArray.length];
            Level[] levelArray2 = new Level[homePieceOfFurnitureArray.length];
            boolean bl3 = bl;
            for (n2 = 0; n2 < homePieceOfFurnitureArray.length; ++n2) {
                object[n2] = (Integer)arrayList3.get(n2);
                levelArray2[n2] = homePieceOfFurnitureArray[n2].getLevel();
                bl3 &= !this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurnitureArray[n2]);
            }
            boolean bl4 = bl3;
            this.doUngroupFurniture(homeFurnitureGroupArray3, homePieceOfFurnitureArray, homeFurnitureGroupArray2, (int[])object, levelArray2, bl4, false);
            if (this.undoSupport != null) {
                serializable = new AbstractUndoableEdit((int[])object2, levelArray, bl, bl2, list2, homeFurnitureGroupArray2, (int[])object, levelArray2, bl4){
                    final /* synthetic */ int[] val$groupsIndex;
                    final /* synthetic */ Level[] val$groupsLevels;
                    final /* synthetic */ boolean val$oldBasePlanLocked;
                    final /* synthetic */ boolean val$allLevelsSelection;
                    final /* synthetic */ List val$oldSelection;
                    final /* synthetic */ HomeFurnitureGroup[] val$ungroupedPiecesGroups;
                    final /* synthetic */ int[] val$ungroupedPiecesIndex;
                    final /* synthetic */ Level[] val$ungroupedPiecesLevels;
                    final /* synthetic */ boolean val$newBasePlanLocked;
                    {
                        this.val$groupsIndex = nArray;
                        this.val$groupsLevels = levelArray;
                        this.val$oldBasePlanLocked = bl;
                        this.val$allLevelsSelection = bl2;
                        this.val$oldSelection = list;
                        this.val$ungroupedPiecesGroups = homeFurnitureGroupArray32;
                        this.val$ungroupedPiecesIndex = nArray2;
                        this.val$ungroupedPiecesLevels = levelArray2;
                        this.val$newBasePlanLocked = bl3;
                    }

                    public void undo() throws CannotUndoException {
                        super.undo();
                        FurnitureController.this.doGroupFurniture(homePieceOfFurnitureArray, homeFurnitureGroupArray3, homeFurnitureGroupArray, this.val$groupsIndex, this.val$groupsLevels, this.val$oldBasePlanLocked, this.val$allLevelsSelection);
                        FurnitureController.this.home.setSelectedItems(this.val$oldSelection);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        FurnitureController.this.doUngroupFurniture(homeFurnitureGroupArray3, homePieceOfFurnitureArray, this.val$ungroupedPiecesGroups, this.val$ungroupedPiecesIndex, this.val$ungroupedPiecesLevels, this.val$newBasePlanLocked, false);
                    }

                    public String getPresentationName() {
                        return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoUngroupName", new Object[0]);
                    }
                };
                this.undoSupport.postEdit((UndoableEdit)((Object)serializable));
            }
        }
    }

    public void importFurniture() {
        new ImportedFurnitureWizardController(this.home, this.preferences, this, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
    }

    public void importFurniture(String string) {
        new ImportedFurnitureWizardController(this.home, string, this.preferences, this, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
    }

    public void alignSelectedFurnitureOnTop() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float f = FurnitureController.this.getMinY(homePieceOfFurniture);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    HomePieceOfFurniture homePieceOfFurniture2 = alignedPieceOfFurniture.getPieceOfFurniture();
                    float f2 = FurnitureController.this.getMinY(homePieceOfFurniture2);
                    homePieceOfFurniture2.setY(homePieceOfFurniture2.getY() + f - f2);
                }
            }
        });
    }

    public void alignSelectedFurnitureOnBottom() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float f = FurnitureController.this.getMaxY(homePieceOfFurniture);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    HomePieceOfFurniture homePieceOfFurniture2 = alignedPieceOfFurniture.getPieceOfFurniture();
                    float f2 = FurnitureController.this.getMaxY(homePieceOfFurniture2);
                    homePieceOfFurniture2.setY(homePieceOfFurniture2.getY() + f - f2);
                }
            }
        });
    }

    public void alignSelectedFurnitureOnLeft() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float f = FurnitureController.this.getMinX(homePieceOfFurniture);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    HomePieceOfFurniture homePieceOfFurniture2 = alignedPieceOfFurniture.getPieceOfFurniture();
                    float f2 = FurnitureController.this.getMinX(homePieceOfFurniture2);
                    homePieceOfFurniture2.setX(homePieceOfFurniture2.getX() + f - f2);
                }
            }
        });
    }

    public void alignSelectedFurnitureOnRight() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float f = FurnitureController.this.getMaxX(homePieceOfFurniture);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    HomePieceOfFurniture homePieceOfFurniture2 = alignedPieceOfFurniture.getPieceOfFurniture();
                    float f2 = FurnitureController.this.getMaxX(homePieceOfFurniture2);
                    homePieceOfFurniture2.setX(homePieceOfFurniture2.getX() + f - f2);
                }
            }
        });
    }

    public void alignSelectedFurnitureOnFrontSide() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float[][] fArray = homePieceOfFurniture.getPoints();
                Line2D.Float float_ = new Line2D.Float(fArray[2][0], fArray[2][1], fArray[3][0], fArray[3][1]);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    FurnitureController.this.alignPieceOfFurnitureAlongSides(alignedPieceOfFurniture.getPieceOfFurniture(), homePieceOfFurniture, float_, true, null, 0.0f);
                }
            }
        });
    }

    public void alignSelectedFurnitureOnBackSide() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float[][] fArray = homePieceOfFurniture.getPoints();
                Line2D.Float float_ = new Line2D.Float(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    FurnitureController.this.alignPieceOfFurnitureAlongSides(alignedPieceOfFurniture.getPieceOfFurniture(), homePieceOfFurniture, float_, false, null, 0.0f);
                }
            }
        });
    }

    public void alignSelectedFurnitureOnLeftSide() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float[][] fArray = homePieceOfFurniture.getPoints();
                Line2D.Float float_ = new Line2D.Float(fArray[3][0], fArray[3][1], fArray[0][0], fArray[0][1]);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    FurnitureController.this.alignPieceOfFurnitureAlongLeftOrRightSides(alignedPieceOfFurniture.getPieceOfFurniture(), homePieceOfFurniture, float_, false);
                }
            }
        });
    }

    public void alignSelectedFurnitureOnRightSide() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                float[][] fArray = homePieceOfFurniture.getPoints();
                Line2D.Float float_ = new Line2D.Float(fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]);
                for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
                    FurnitureController.this.alignPieceOfFurnitureAlongLeftOrRightSides(alignedPieceOfFurniture.getPieceOfFurniture(), homePieceOfFurniture, float_, true);
                }
            }
        });
    }

    public void alignSelectedFurnitureSideBySide() {
        this.alignSelectedFurniture(new AlignmentAction(){

            public void alignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
                FurnitureController.this.alignFurnitureSideBySide(alignedPieceOfFurnitureArray, homePieceOfFurniture);
            }
        });
    }

    private void alignFurnitureSideBySide(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
        int n;
        float[][] fArray = homePieceOfFurniture.getPoints();
        Line2D.Float float_ = new Line2D.Float(homePieceOfFurniture.getX(), homePieceOfFurniture.getY(), (fArray[0][0] + fArray[1][0]) / 2.0f, (fArray[0][1] + fArray[1][1]) / 2.0f);
        List<HomePieceOfFurniture> list = this.sortFurniture(alignedPieceOfFurnitureArray, homePieceOfFurniture, float_);
        int n2 = list.indexOf(homePieceOfFurniture);
        Line2D.Float float_2 = new Line2D.Float(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
        float f = homePieceOfFurniture.getWidthInPlan() / 2.0f;
        for (n = n2 + 1; n < list.size(); ++n) {
            f = (float)((double)f + this.alignPieceOfFurnitureAlongSides(list.get(n), homePieceOfFurniture, float_2, false, float_, f));
        }
        f = -homePieceOfFurniture.getWidthInPlan() / 2.0f;
        for (n = n2 - 1; n >= 0; --n) {
            f = (float)((double)f - this.alignPieceOfFurnitureAlongSides(list.get(n), homePieceOfFurniture, float_2, false, float_, f));
        }
    }

    public List<HomePieceOfFurniture> sortFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture, final Line2D line2D) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(alignedPieceOfFurnitureArray.length + 1);
        if (homePieceOfFurniture != null) {
            arrayList.add(homePieceOfFurniture);
        }
        for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
            arrayList.add(alignedPieceOfFurniture.getPieceOfFurniture());
        }
        Collections.sort(arrayList, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return Double.compare(line2D.ptLineDistSq(homePieceOfFurniture2.getX(), homePieceOfFurniture2.getY()) * (double)line2D.relativeCCW(homePieceOfFurniture2.getX(), homePieceOfFurniture2.getY()), line2D.ptLineDistSq(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) * (double)line2D.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()));
            }
        });
        return arrayList;
    }

    private double alignPieceOfFurnitureAlongSides(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2, Line2D line2D, boolean bl, Line2D line2D2, float f) {
        double d = (double)line2D.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) * line2D.ptLineDist(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) + this.getPieceBoundingRectangleHeight(homePieceOfFurniture, -homePieceOfFurniture2.getAngle()) / 2.0;
        if (bl) {
            d = -d;
        }
        double d2 = Math.sin(homePieceOfFurniture2.getAngle());
        double d3 = Math.cos(homePieceOfFurniture2.getAngle());
        float f2 = (float)(-d * d2);
        float f3 = (float)(d * d3);
        double d4 = this.getPieceBoundingRectangleWidth(homePieceOfFurniture, -homePieceOfFurniture2.getAngle());
        if (line2D2 != null) {
            int n = line2D2.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY());
            if (n == 0) {
                n = bl ? 1 : -1;
            }
            d = (double)f + (double)n * (line2D2.ptLineDist(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) - d4 / 2.0);
            f2 += (float)(d * d3);
            f3 += (float)(d * d2);
        }
        homePieceOfFurniture.move(f2, f3);
        return d4;
    }

    private void alignPieceOfFurnitureAlongLeftOrRightSides(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2, Line2D line2D, boolean bl) {
        double d = (double)line2D.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) * line2D.ptLineDist(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) + this.getPieceBoundingRectangleWidth(homePieceOfFurniture, -homePieceOfFurniture2.getAngle()) / 2.0;
        if (bl) {
            d = -d;
        }
        homePieceOfFurniture.move((float)(d * Math.cos(homePieceOfFurniture2.getAngle())), (float)(d * Math.sin(homePieceOfFurniture2.getAngle())));
    }

    private double getPieceBoundingRectangleWidth(HomePieceOfFurniture homePieceOfFurniture, float f) {
        return Math.abs((double)homePieceOfFurniture.getWidthInPlan() * Math.cos(f + homePieceOfFurniture.getAngle())) + Math.abs((double)homePieceOfFurniture.getDepthInPlan() * Math.sin(f + homePieceOfFurniture.getAngle()));
    }

    private double getPieceBoundingRectangleHeight(HomePieceOfFurniture homePieceOfFurniture, float f) {
        return Math.abs((double)homePieceOfFurniture.getWidthInPlan() * Math.sin(f + homePieceOfFurniture.getAngle())) + Math.abs((double)homePieceOfFurniture.getDepthInPlan() * Math.cos(f + homePieceOfFurniture.getAngle()));
    }

    private void alignSelectedFurniture(final AlignmentAction alignmentAction) {
        final List<HomePieceOfFurniture> list = this.getMovableSelectedFurniture();
        if (list.size() >= 2) {
            final List<Selectable> list2 = this.home.getSelectedItems();
            final HomePieceOfFurniture homePieceOfFurniture = this.leadSelectedPieceOfFurniture;
            final AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray = AlignedPieceOfFurniture.getAlignedFurniture(list, homePieceOfFurniture);
            this.home.setSelectedItems(list);
            alignmentAction.alignFurniture(alignedPieceOfFurnitureArray, homePieceOfFurniture);
            if (this.undoSupport != null) {
                AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                    public void undo() throws CannotUndoException {
                        super.undo();
                        FurnitureController.this.undoAlignFurniture(alignedPieceOfFurnitureArray);
                        FurnitureController.this.home.setSelectedItems(list2);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        FurnitureController.this.home.setSelectedItems(list);
                        alignmentAction.alignFurniture(alignedPieceOfFurnitureArray, homePieceOfFurniture);
                    }

                    public String getPresentationName() {
                        return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoAlignName", new Object[0]);
                    }
                };
                this.undoSupport.postEdit(abstractUndoableEdit);
            }
        }
    }

    private List<HomePieceOfFurniture> getMovableSelectedFurniture() {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        for (Selectable selectable : this.home.getSelectedItems()) {
            HomePieceOfFurniture homePieceOfFurniture;
            if (!(selectable instanceof HomePieceOfFurniture) || !this.isPieceOfFurnitureMovable(homePieceOfFurniture = (HomePieceOfFurniture)selectable)) continue;
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    private void undoAlignFurniture(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray) {
        for (AlignedPieceOfFurniture alignedPieceOfFurniture : alignedPieceOfFurnitureArray) {
            HomePieceOfFurniture homePieceOfFurniture = alignedPieceOfFurniture.getPieceOfFurniture();
            homePieceOfFurniture.setX(alignedPieceOfFurniture.getX());
            homePieceOfFurniture.setY(alignedPieceOfFurniture.getY());
        }
    }

    private float getMinX(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.POSITIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.min(f, fArray2[0]);
        }
        return f;
    }

    private float getMaxX(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.NEGATIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.max(f, fArray2[0]);
        }
        return f;
    }

    private float getMinY(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.POSITIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.min(f, fArray2[1]);
        }
        return f;
    }

    private float getMaxY(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.NEGATIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.max(f, fArray2[1]);
        }
        return f;
    }

    public void distributeSelectedFurnitureHorizontally() {
        this.distributeSelectedFurniture(true);
    }

    public void distributeSelectedFurnitureVertically() {
        this.distributeSelectedFurniture(false);
    }

    public void distributeSelectedFurniture(final boolean bl) {
        final List<HomePieceOfFurniture> list = this.getMovableSelectedFurniture();
        if (list.size() >= 3) {
            final List<Selectable> list2 = this.home.getSelectedItems();
            final AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray = AlignedPieceOfFurniture.getAlignedFurniture(list, null);
            this.home.setSelectedItems(list);
            this.doDistributeFurnitureAlongAxis(alignedPieceOfFurnitureArray, bl);
            if (this.undoSupport != null) {
                AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                    public void undo() throws CannotUndoException {
                        super.undo();
                        FurnitureController.this.undoAlignFurniture(alignedPieceOfFurnitureArray);
                        FurnitureController.this.home.setSelectedItems(list2);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        FurnitureController.this.home.setSelectedItems(list);
                        FurnitureController.this.doDistributeFurnitureAlongAxis(alignedPieceOfFurnitureArray, bl);
                    }

                    public String getPresentationName() {
                        return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoDistributeName", new Object[0]);
                    }
                };
                this.undoSupport.postEdit(abstractUndoableEdit);
            }
        }
    }

    private void doDistributeFurnitureAlongAxis(AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray, boolean bl) {
        Line2D.Float float_ = bl ? new Line2D.Float(0.0f, 0.0f, 0.0f, -1.0f) : new Line2D.Float(0.0f, 0.0f, 1.0f, 0.0f);
        List<HomePieceOfFurniture> list = this.sortFurniture(alignedPieceOfFurnitureArray, null, float_);
        float f = (float)(bl ? 0.0 : 1.5707963267948966);
        HomePieceOfFurniture homePieceOfFurniture = list.get(0);
        double d = this.getPieceBoundingRectangleWidth(homePieceOfFurniture, f) / 2.0;
        HomePieceOfFurniture homePieceOfFurniture2 = list.get(list.size() - 1);
        double d2 = this.getPieceBoundingRectangleWidth(homePieceOfFurniture2, f) / 2.0;
        double d3 = Math.abs(float_.ptLineDist(homePieceOfFurniture2.getX(), homePieceOfFurniture2.getY()) * (double)float_.relativeCCW(homePieceOfFurniture2.getX(), homePieceOfFurniture2.getY()) - float_.ptLineDist(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) * (double)float_.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY())) - d2 - d;
        double[] dArray = new double[list.size() - 2];
        for (int i = 1; i < list.size() - 1; ++i) {
            HomePieceOfFurniture homePieceOfFurniture3 = list.get(i);
            dArray[i - 1] = this.getPieceBoundingRectangleWidth(homePieceOfFurniture3, f);
            d3 -= dArray[i - 1];
        }
        float f2 = (bl ? homePieceOfFurniture.getX() : homePieceOfFurniture.getY()) + (float)(d + (d3 /= (double)(list.size() - 1)));
        for (int i = 1; i < list.size() - 1; ++i) {
            HomePieceOfFurniture homePieceOfFurniture4 = list.get(i);
            if (bl) {
                homePieceOfFurniture4.setX((float)((double)f2 + dArray[i - 1] / 2.0));
            } else {
                homePieceOfFurniture4.setY((float)((double)f2 + dArray[i - 1] / 2.0));
            }
            f2 = (float)((double)f2 + (d3 + dArray[i - 1]));
        }
    }

    public void resetFurnitureElevation() {
        final List<HomePieceOfFurniture> list = this.getMovableSelectedFurniture();
        if (list.size() >= 1) {
            final List<Selectable> list2 = this.home.getSelectedItems();
            final float[] fArray = new float[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                fArray[i] = list.get(i).getElevation();
            }
            this.home.setSelectedItems(list);
            this.doResetFurnitureElevation(list);
            if (this.undoSupport != null) {
                AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                    public void undo() throws CannotUndoException {
                        super.undo();
                        for (int i = 0; i < list.size(); ++i) {
                            ((HomePieceOfFurniture)list.get(i)).setElevation(fArray[i]);
                        }
                        FurnitureController.this.home.setSelectedItems(list2);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        FurnitureController.this.home.setSelectedItems(list);
                        FurnitureController.this.doResetFurnitureElevation(list);
                    }

                    public String getPresentationName() {
                        return FurnitureController.this.preferences.getLocalizedString(FurnitureController.class, "undoResetElevation", new Object[0]);
                    }
                };
                this.undoSupport.postEdit(abstractUndoableEdit);
            }
        }
    }

    private void doResetFurnitureElevation(List<HomePieceOfFurniture> list) {
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            HomePieceOfFurniture homePieceOfFurniture2 = this.getHighestSurroundingPieceOfFurniture(homePieceOfFurniture, list);
            if (homePieceOfFurniture2 != null) {
                float f = homePieceOfFurniture2.getElevation() + homePieceOfFurniture2.getHeightInPlan() * homePieceOfFurniture2.getDropOnTopElevation();
                if (homePieceOfFurniture2.getLevel() != null) {
                    f += homePieceOfFurniture2.getLevel().getElevation() - homePieceOfFurniture.getLevel().getElevation();
                }
                homePieceOfFurniture.setElevation(Math.max(0.0f, f));
                continue;
            }
            homePieceOfFurniture.setElevation(0.0f);
        }
    }

    protected HomePieceOfFurniture getHighestSurroundingPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
        List<HomePieceOfFurniture> list = Collections.emptyList();
        return this.getHighestSurroundingPieceOfFurniture(homePieceOfFurniture, list);
    }

    private HomePieceOfFurniture getHighestSurroundingPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture, List<HomePieceOfFurniture> list) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Math.min(homePieceOfFurniture.getWidthInPlan(), homePieceOfFurniture.getDepthInPlan()) * 0.05f;
        HomePieceOfFurniture homePieceOfFurniture2 = null;
        float f2 = Float.MIN_VALUE;
        for (HomePieceOfFurniture homePieceOfFurniture3 : this.getFurnitureInSameGroup(homePieceOfFurniture)) {
            float f3;
            if (homePieceOfFurniture3 == homePieceOfFurniture || list.contains(homePieceOfFurniture3) || !this.isPieceOfFurnitureVisibleAtSelectedLevel(homePieceOfFurniture3) || !(homePieceOfFurniture3.getDropOnTopElevation() >= 0.0f)) continue;
            boolean bl = true;
            for (float[] fArray2 : fArray) {
                if (homePieceOfFurniture3.containsPoint(fArray2[0], fArray2[1], f)) continue;
                bl = false;
                break;
            }
            if (!bl || !((f3 = homePieceOfFurniture3.getElevation() + homePieceOfFurniture3.getHeightInPlan() * homePieceOfFurniture3.getDropOnTopElevation()) > f2)) continue;
            f2 = f3;
            homePieceOfFurniture2 = homePieceOfFurniture3;
        }
        return homePieceOfFurniture2;
    }

    protected List<HomePieceOfFurniture> getFurnitureInSameGroup(HomePieceOfFurniture homePieceOfFurniture) {
        List<HomePieceOfFurniture> list = this.home.getFurniture();
        List<HomePieceOfFurniture> list2 = this.getFurnitureInSameGroup(homePieceOfFurniture, list);
        if (list2 != null) {
            return list2;
        }
        return list;
    }

    private List<HomePieceOfFurniture> getFurnitureInSameGroup(HomePieceOfFurniture homePieceOfFurniture, List<HomePieceOfFurniture> list) {
        for (HomePieceOfFurniture homePieceOfFurniture2 : list) {
            List<HomePieceOfFurniture> list2;
            if (homePieceOfFurniture2 == homePieceOfFurniture) {
                return list;
            }
            if (!(homePieceOfFurniture2 instanceof HomeFurnitureGroup) || (list2 = this.getFurnitureInSameGroup(homePieceOfFurniture, ((HomeFurnitureGroup)homePieceOfFurniture2).getFurniture())) == null) continue;
            return list2;
        }
        return null;
    }

    protected boolean isPieceOfFurnitureVisibleAtSelectedLevel(HomePieceOfFurniture homePieceOfFurniture) {
        Level level = this.home.getSelectedLevel();
        return !(!homePieceOfFurniture.isVisible() || homePieceOfFurniture.getLevel() != null && !homePieceOfFurniture.getLevel().isViewable() || homePieceOfFurniture.getLevel() != level && !homePieceOfFurniture.isAtLevel(level));
    }

    public void setVisualProperty(String string, Object object) {
        this.home.setVisualProperty(string, object);
    }

    public void setHomeProperty(String string, String string2) {
        this.home.setProperty(string, string2);
    }

    private static interface AlignmentAction {
        public void alignFurniture(AlignedPieceOfFurniture[] var1, HomePieceOfFurniture var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlignedPieceOfFurniture {
        private HomePieceOfFurniture piece;
        private float x;
        private float y;

        public AlignedPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
            this.piece = homePieceOfFurniture;
            this.x = homePieceOfFurniture.getX();
            this.y = homePieceOfFurniture.getY();
        }

        public HomePieceOfFurniture getPieceOfFurniture() {
            return this.piece;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public static AlignedPieceOfFurniture[] getAlignedFurniture(List<HomePieceOfFurniture> list, HomePieceOfFurniture homePieceOfFurniture) {
            AlignedPieceOfFurniture[] alignedPieceOfFurnitureArray = new AlignedPieceOfFurniture[homePieceOfFurniture == null ? list.size() : list.size() - 1];
            int n = 0;
            for (HomePieceOfFurniture homePieceOfFurniture2 : list) {
                if (homePieceOfFurniture2 == homePieceOfFurniture) continue;
                alignedPieceOfFurnitureArray[n++] = new AlignedPieceOfFurniture(homePieceOfFurniture2);
            }
            return alignedPieceOfFurnitureArray;
        }
    }
}

