/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan.scanner;

import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.pscan.PassiveScanThread;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.utils.Stats;

public class StatsPassiveScanner
extends PluginPassiveScanner {
    public static final String CODE_STATS_PREFIX = "stats.code.";
    public static final String CONTENT_TYPE_STATS_PREFIX = "stats.contentType.";
    public static final String RESPONSE_TIME_STATS_PREFIX = "stats.responseTime.";

    @Override
    public String getName() {
        return Constant.messages.getString("pscan.stats.passivescanner.title");
    }

    @Override
    public int getPluginId() {
        return 50003;
    }

    @Override
    public void scanHttpRequestSend(HttpMessage msg, int id) {
    }

    @Override
    public void scanHttpResponseReceive(HttpMessage msg, int id, Source source) {
        try {
            String site = SessionStructure.getHostName(msg);
            Stats.incCounter(site, CODE_STATS_PREFIX + msg.getResponseHeader().getStatusCode());
            String contentType = msg.getResponseHeader().getHeader("Content-Type");
            if (contentType != null) {
                Stats.incCounter(site, CONTENT_TYPE_STATS_PREFIX + contentType);
            }
            Stats.incCounter(site, RESPONSE_TIME_STATS_PREFIX + Integer.highestOneBit(msg.getTimeElapsedMillis()) * 2);
        }
        catch (URIException uRIException) {
            // empty catch block
        }
    }

    @Override
    public boolean appliesToHistoryType(int historyType) {
        return true;
    }

    @Override
    public void setParent(PassiveScanThread parent) {
    }
}

