/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public enum ClassLoaderHelper {


    public static URL getResource(String resource2, Class<?> ... classes) {
        return ClassLoaderHelper.getResource(resource2, false, classes);
    }

    public static URL getResource(String resource2, boolean classesFirst, Class<?> ... classes) {
        URL url;
        if (classesFirst) {
            url = ClassLoaderHelper.getResourceViaClasses(resource2, classes);
            if (url == null) {
                url = ClassLoaderHelper.getResourceViaContext(resource2);
            }
        } else {
            url = ClassLoaderHelper.getResourceViaContext(resource2);
            if (url == null) {
                url = ClassLoaderHelper.getResourceViaClasses(resource2, classes);
            }
        }
        return url == null ? ClassLoaderHelper.class.getResource(resource2) : url;
    }

    private static URL getResourceViaClasses(String resource2, Class<?>[] classes) {
        if (classes != null) {
            for (Class<?> c : classes) {
                URL url = c.getResource(resource2);
                if (url == null) continue;
                return url;
            }
        }
        return null;
    }

    private static URL getResourceViaContext(String resource2) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader == null ? null : loader.getResource(resource2);
    }

    private static Class<?> loadClassViaClasses(String fqcn, Class<?>[] classes) {
        if (classes != null) {
            for (Class<?> c : classes) {
                ClassLoader loader = c.getClassLoader();
                if (loader == null) continue;
                try {
                    return loader.loadClass(fqcn);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static Class<?> loadClassViaContext(String fqcn) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return loader == null ? null : loader.loadClass(fqcn);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Class<?> loadClass(String fqcn, Class<?> ... classes) throws ClassNotFoundException {
        return ClassLoaderHelper.loadClass(fqcn, true, classes);
    }

    public static Class<?> loadClass(String fqcn, boolean classesFirst, Class<?> ... classes) throws ClassNotFoundException {
        Class<?> target = null;
        if (classesFirst) {
            target = ClassLoaderHelper.loadClassViaClasses(fqcn, classes);
            if (target == null) {
                target = ClassLoaderHelper.loadClassViaContext(fqcn);
            }
        } else {
            target = ClassLoaderHelper.loadClassViaContext(fqcn);
            if (target == null) {
                target = ClassLoaderHelper.loadClassViaClasses(fqcn, classes);
            }
        }
        return target == null ? Class.forName(fqcn) : target;
    }

    public static InputStream getResourceAsStream(String resource2, Class<?> ... classes) {
        return ClassLoaderHelper.getResourceAsStream(resource2, false, classes);
    }

    public static InputStream getResourceAsStream(String resource2, boolean classesFirst, Class<?> ... classes) {
        URL url = ClassLoaderHelper.getResource(resource2, classesFirst, classes);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e2) {
            return null;
        }
    }
}

