/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.IngestScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;

public final class ScriptProcessor
extends AbstractProcessor {
    public static final String TYPE = "script";
    private final Script script;
    private final ScriptService scriptService;

    ScriptProcessor(String tag, Script script, ScriptService scriptService) {
        super(tag);
        this.script = script;
        this.scriptService = scriptService;
    }

    public void execute(IngestDocument document) {
        IngestScript.Factory factory = (IngestScript.Factory)this.scriptService.compile(this.script, IngestScript.CONTEXT);
        factory.newInstance(this.script.getParams()).execute(document.getSourceAndMetadata());
    }

    public String getType() {
        return TYPE;
    }

    Script getScript() {
        return this.script;
    }

    public static final class Factory
    implements Processor.Factory {
        private final Logger logger = ESLoggerFactory.getLogger(Factory.class);
        private final DeprecationLogger deprecationLogger = new DeprecationLogger(this.logger);
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public ScriptProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String scriptPropertyUsed;
            Script script;
            boolean moreThanOneConfigured;
            boolean containsNoScript;
            String lang = ConfigurationUtils.readOptionalStringProperty((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"lang");
            String source = ConfigurationUtils.readOptionalStringProperty((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"source");
            String id = ConfigurationUtils.readOptionalStringProperty((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"id");
            Map params = ConfigurationUtils.readOptionalMap((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"params");
            if (source == null && (source = ConfigurationUtils.readOptionalStringProperty((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"inline")) != null) {
                this.deprecationLogger.deprecated("Specifying script source with [inline] is deprecated, use [source] instead.", new Object[0]);
            }
            boolean bl = containsNoScript = !Strings.hasLength((String)id) && !Strings.hasLength((String)source);
            if (containsNoScript) {
                throw ConfigurationUtils.newConfigurationException((String)ScriptProcessor.TYPE, (String)processorTag, null, (String)"Need [id] or [source] parameter to refer to scripts");
            }
            boolean bl2 = moreThanOneConfigured = Strings.hasLength((String)id) && Strings.hasLength((String)source);
            if (moreThanOneConfigured) {
                throw ConfigurationUtils.newConfigurationException((String)ScriptProcessor.TYPE, (String)processorTag, null, (String)"Only one of [id] or [source] may be configured");
            }
            if (lang == null) {
                lang = "painless";
            }
            if (params == null) {
                params = Collections.emptyMap();
            }
            if (Strings.hasLength((String)source)) {
                script = new Script(ScriptType.INLINE, lang, source, params);
                scriptPropertyUsed = "source";
            } else if (Strings.hasLength((String)id)) {
                script = new Script(ScriptType.STORED, null, id, params);
                scriptPropertyUsed = "id";
            } else {
                throw ConfigurationUtils.newConfigurationException((String)ScriptProcessor.TYPE, (String)processorTag, null, (String)"Could not initialize script");
            }
            try {
                this.scriptService.compile(script, IngestScript.CONTEXT);
            }
            catch (ScriptException e) {
                throw ConfigurationUtils.newConfigurationException((String)ScriptProcessor.TYPE, (String)processorTag, (String)scriptPropertyUsed, (Exception)((Object)e));
            }
            return new ScriptProcessor(processorTag, script, this.scriptService);
        }
    }
}

