/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.sql.expression.Alias;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.AttributeMap;
import org.elasticsearch.xpack.sql.expression.AttributeSet;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.LiteralAttribute;
import org.elasticsearch.xpack.sql.expression.NamedExpression;

public abstract class Expressions {
    public static List<NamedExpression> asNamed(List<? extends Expression> exp) {
        return exp.stream().map(NamedExpression.class::cast).collect(Collectors.toList());
    }

    public static NamedExpression wrapAsNamed(Expression exp) {
        return exp instanceof NamedExpression ? (NamedExpression)exp : new Alias(exp.location(), exp.nodeName(), exp);
    }

    public static List<Attribute> asAttributes(List<? extends NamedExpression> named) {
        if (named.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Attribute> list = new ArrayList<Attribute>(named.size());
        for (NamedExpression namedExpression : named) {
            list.add(namedExpression.toAttribute());
        }
        return list;
    }

    public static AttributeMap<Expression> asAttributeMap(List<? extends NamedExpression> named) {
        if (named.isEmpty()) {
            return new AttributeMap<Expression>(Collections.emptyMap());
        }
        AttributeMap<Expression> map = new AttributeMap<Expression>();
        for (NamedExpression namedExpression : named) {
            map.add(namedExpression.toAttribute(), namedExpression);
        }
        return map;
    }

    public static boolean anyMatch(List<? extends Expression> exps, Predicate<? super Expression> predicate) {
        for (Expression expression : exps) {
            if (!expression.anyMatch(predicate)) continue;
            return true;
        }
        return false;
    }

    public static boolean nullable(List<? extends Expression> exps) {
        for (Expression expression : exps) {
            if (expression.nullable()) continue;
            return false;
        }
        return true;
    }

    public static AttributeSet references(List<? extends Expression> exps) {
        if (exps.isEmpty()) {
            return AttributeSet.EMPTY;
        }
        AttributeSet set = new AttributeSet();
        for (Expression expression : exps) {
            set.addAll(expression.references());
        }
        return set;
    }

    public static String name(Expression e) {
        return e instanceof NamedExpression ? ((NamedExpression)e).name() : e.nodeName();
    }

    public static List<String> names(Collection<? extends Expression> e) {
        ArrayList<String> names = new ArrayList<String>(e.size());
        for (Expression expression : e) {
            names.add(Expressions.name(expression));
        }
        return names;
    }

    public static Attribute attribute(Expression e) {
        if (e instanceof NamedExpression) {
            return ((NamedExpression)e).toAttribute();
        }
        if (e != null && e.foldable()) {
            return new LiteralAttribute(Literal.of(e));
        }
        return null;
    }

    public static boolean equalsAsAttribute(Expression left, Expression right) {
        if (!left.semanticEquals(right)) {
            Attribute l = Expressions.attribute(left);
            return l != null && l.semanticEquals(Expressions.attribute(right));
        }
        return true;
    }

    public static Expression.TypeResolution typeMustBe(Expression e, Predicate<Expression> predicate, String message) {
        return predicate.test(e) ? Expression.TypeResolution.TYPE_RESOLVED : new Expression.TypeResolution(message, new Object[0]);
    }

    public static Expression.TypeResolution typeMustBeNumeric(Expression e) {
        return e.dataType().isNumeric() ? Expression.TypeResolution.TYPE_RESOLVED : new Expression.TypeResolution("Argument required to be numeric ('" + Expressions.name(e) + "' of type '" + e.dataType().esType + "')", new Object[0]);
    }
}

