/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.Controller;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.modes.LineAdapter;
import freemind.modes.MindMapLink;
import freemind.modes.MindMapNode;
import freemind.preferences.FreemindPropertyListener;
import java.awt.Color;

public abstract class LinkAdapter
extends LineAdapter
implements MindMapLink {
    public static final String RESOURCES_STANDARDLINKSTYLE = "standardlinkstyle";
    private static Color standardColor = null;
    private static String standardStyle = null;
    private static LinkAdapterListener listener = null;
    String destinationLabel;
    String referenceText;
    MindMapNode source;
    private String uniqueId;

    public LinkAdapter(MindMapNode source, MindMapNode target, FreeMindMain frame) {
        super(target, frame);
        this.source = source;
        this.destinationLabel = null;
        this.referenceText = null;
        if (listener == null) {
            listener = new LinkAdapterListener();
            Controller.addPropertyChangeListener(listener);
        }
    }

    @Override
    public String getDestinationLabel() {
        return this.destinationLabel;
    }

    @Override
    public String getReferenceText() {
        return this.referenceText;
    }

    @Override
    public MindMapNode getSource() {
        return this.source;
    }

    public void setSource(MindMapNode source) {
        this.source = source;
    }

    public void setDestinationLabel(String destinationLabel) {
        this.destinationLabel = destinationLabel;
    }

    public void setReferenceText(String referenceText) {
        this.referenceText = referenceText;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Override
    protected Color getStandardColor() {
        return standardColor;
    }

    @Override
    protected void setStandardColor(Color standardColor) {
        LinkAdapter.standardColor = standardColor;
    }

    @Override
    protected String getStandardStyle() {
        return standardStyle;
    }

    @Override
    protected void setStandardStyle(String standardStyle) {
        LinkAdapter.standardStyle = standardStyle;
    }

    @Override
    protected String getStandardColorPropertyString() {
        return "standardlinkcolor";
    }

    @Override
    protected String getStandardStylePropertyString() {
        return RESOURCES_STANDARDLINKSTYLE;
    }

    protected static class LinkAdapterListener
    implements FreemindPropertyListener {
        protected LinkAdapterListener() {
        }

        @Override
        public void propertyChanged(String propertyName, String newValue, String oldValue) {
            if (propertyName.equals("standardlinkcolor")) {
                standardColor = Tools.xmlToColor(newValue);
            }
            if (propertyName.equals(LinkAdapter.RESOURCES_STANDARDLINKSTYLE)) {
                standardStyle = newValue;
            }
        }
    }
}

