/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.internal;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.language.cpp.internal.DefaultUsageContext;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithExecutable;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithRuntimeUsage;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.swift.SwiftExecutable;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.internal.DefaultSwiftBinary;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultSwiftExecutable
extends DefaultSwiftBinary
implements SwiftExecutable,
ConfigurableComponentWithExecutable,
ConfigurableComponentWithRuntimeUsage,
SoftwareComponentInternal {
    private final RegularFileProperty executableFile;
    private final DirectoryProperty installDirectory;
    private final Property<Configuration> runtimeElementsProperty;
    private final Property<LinkExecutable> linkTaskProperty;
    private final Property<InstallExecutable> installTaskProperty;
    private final RegularFileProperty debuggerExecutableFile;
    private final ConfigurableFileCollection outputs;

    @Inject
    public DefaultSwiftExecutable(Names names, ProjectLayout projectLayout, ObjectFactory objectFactory, FileOperations fileOperations, Provider<String> module, boolean testable, FileCollection source, ConfigurationContainer configurations, Configuration implementation, SwiftPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider, NativeVariantIdentity identity) {
        super(names, projectLayout, objectFactory, module, testable, source, configurations, implementation, targetPlatform, toolChain, platformToolProvider, identity);
        this.executableFile = projectLayout.fileProperty();
        this.installDirectory = projectLayout.directoryProperty();
        this.linkTaskProperty = objectFactory.property(LinkExecutable.class);
        this.installTaskProperty = objectFactory.property(InstallExecutable.class);
        this.debuggerExecutableFile = projectLayout.fileProperty();
        this.runtimeElementsProperty = objectFactory.property(Configuration.class);
        this.outputs = fileOperations.configurableFiles();
    }

    @Override
    public ConfigurableFileCollection getOutputs() {
        return this.outputs;
    }

    public RegularFileProperty getExecutableFile() {
        return this.executableFile;
    }

    public DirectoryProperty getInstallDirectory() {
        return this.installDirectory;
    }

    @Override
    public Property<LinkExecutable> getLinkTask() {
        return this.linkTaskProperty;
    }

    @Override
    public Property<InstallExecutable> getInstallTask() {
        return this.installTaskProperty;
    }

    public RegularFileProperty getDebuggerExecutableFile() {
        return this.debuggerExecutableFile;
    }

    @Override
    public Property<Configuration> getRuntimeElements() {
        return this.runtimeElementsProperty;
    }

    @Override
    public Provider<RegularFile> getRuntimeFile() {
        return this.executableFile;
    }

    @Override
    @Nullable
    public Linkage getLinkage() {
        return null;
    }

    @Override
    public boolean hasRuntimeFile() {
        return true;
    }

    public Set<? extends UsageContext> getUsages() {
        Configuration runtimeElements = (Configuration)this.runtimeElementsProperty.get();
        return Collections.singleton(new DefaultUsageContext(this.getIdentity().getRuntimeUsageContext(), (Set<? extends PublishArtifact>)runtimeElements.getAllArtifacts(), runtimeElements));
    }

    @Override
    public AttributeContainer getRuntimeAttributes() {
        return this.getIdentity().getRuntimeUsageContext().getAttributes();
    }
}

