#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: esqueleto
version: 2.6.0
id: esqueleto-2.6.0-ETMnzQnn5GsLSG4DzsjhIV
key: esqueleto-2.6.0-ETMnzQnn5GsLSG4DzsjhIV
license: BSD-3-Clause
copyright: (c) 2012-2016 Felipe Almeida Lessa
maintainer: cma@bitemyapp.com
author: Felipe Lessa
homepage: https://github.com/bitemyapp/esqueleto
synopsis: Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries that works with unmodified @persistent@ SQL backends.  Its language closely resembles SQL, so you don'\''t have to learn new concepts, just new syntax, and it'\''s fairly easy to predict the generated SQL and optimize it for your backend. Most kinds of errors committed when writing SQL are caught as compile-time errors---although it is possible to write type-checked @esqueleto@ queries that fail at runtime.
    .
    @persistent@ is a library for type-safe data serialization.  It has many kinds of backends, such as SQL backends (@persistent-mysql@, @persistent-postgresql@, @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@). While @persistent@ is a nice library for storing and retrieving records, including with filters, it does not try to support some of the features that are specific to SQL backends.  In particular, @esqueleto@ is the recommended library for type-safe @JOIN@s on @persistent@ SQL backends.  (The alternative is using raw SQL, but that'\''s error prone and does not offer any composability.)
    .
    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported. Not all SQL features are available, but most of them can be easily added (especially functions), so please open an issue or send a pull request if you need anything that is not covered by @esqueleto@ on <https://github.com/bitemyapp/esqueleto>.
    .
    The name of this library means \"skeleton\" in Portuguese and contains all three SQL letters in the correct order =).  It was inspired by Scala'\''s Squeryl but created from scratch.
category: Database
abi: 1a5634702cd439684e9a62edf21627a5
exposed: True
exposed-modules:
    Database.Esqueleto Database.Esqueleto.Internal.Language
    Database.Esqueleto.Internal.Sql Database.Esqueleto.MySQL
    Database.Esqueleto.PostgreSQL Database.Esqueleto.SQLite
hidden-modules: Database.Esqueleto.Internal.PersistentImport
                Paths_esqueleto
import-dirs: /usr/lib/ghc-8.4.3/site-local/esqueleto-2.6.0
library-dirs: /usr/lib/ghc-8.4.3/site-local/esqueleto-2.6.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/esqueleto-2.6.0
hs-libraries: HSesqueleto-2.6.0-ETMnzQnn5GsLSG4DzsjhIV
depends:
    base-4.11.1.0 blaze-html-0.9.1.1-7NSQK15kZm4LYXM6mugOc0
    bytestring-0.10.8.2 conduit-1.3.0.3-2AyXnXwSwgrIP3ufotPqX5
    monad-logger-0.3.29-20hQ6t0g7hJ3DR8u99nLmu
    persistent-2.8.2-3YjrxnwTamwGalmoUuihmj
    resourcet-1.2.1-3KYZBJL4a2rBVLKWvBKB4Q
    tagged-0.8.6-8akQ1aZG2N2GFJpoB5eGXO text-1.2.3.0 time-1.8.0.2
    transformers-0.5.5.0 unliftio-0.2.8.1-Ljddp38SqI28O2vcrlqQlv
    unordered-containers-0.2.9.0-HkLL4IW6wFT9NZ9Hv37TSa
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             blaze-html-0.9.1.1-7NSQK15kZm4LYXM6mugOc0=b90977d0094d15b5bd9e12114444ef75
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             conduit-1.3.0.3-2AyXnXwSwgrIP3ufotPqX5=40dfc6daea5ec047296697db048db258
             monad-logger-0.3.29-20hQ6t0g7hJ3DR8u99nLmu=6eec060106560fec5bc4c6102d0dfea1
             persistent-2.8.2-3YjrxnwTamwGalmoUuihmj=86f74fc88e07971f83963798393f503e
             resourcet-1.2.1-3KYZBJL4a2rBVLKWvBKB4Q=b5273090c64c1efd0c4504885cc2bdef
             tagged-0.8.6-8akQ1aZG2N2GFJpoB5eGXO=92d44612a64675b8cba7ce44e507a395
             text-1.2.3.0=9752fd647a108be49a4cb0c2a4456f2b
             time-1.8.0.2=042930fb6746cbaf3bc794f817f8a6b2
             transformers-0.5.5.0=4f41484af13f560f1d83ed79e1be4572
             unliftio-0.2.8.1-Ljddp38SqI28O2vcrlqQlv=11f6e5d65eb6493fda62f01f2af568e3
             unordered-containers-0.2.9.0-HkLL4IW6wFT9NZ9Hv37TSa=81e1d2b217f05c2ba43642acf6d96f3b
haddock-interfaces: /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html: /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

