/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.net.URI;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.editorkit.EditorKitFactoryPlugin;
import org.protege.editor.core.ui.OpenFromURLPanel;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.core.ui.util.OpenRequestHandler;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;

public class OpenFromURLAction
extends ProtegeOWLAction
implements OpenRequestHandler {
    public void actionPerformed(ActionEvent e) {
        try {
            UIUtil.openRequest((OpenRequestHandler)this);
        }
        catch (Exception e1) {
            ErrorLogPanel.showErrorDialog((Throwable)e1);
        }
    }

    private URI getPhysicalURI() {
        return OpenFromURLPanel.showDialog();
    }

    public void dispose() {
    }

    public void initialise() throws Exception {
    }

    public Workspace getCurrentWorkspace() {
        return this.getWorkspace();
    }

    public void openInNewWorkspace() throws Exception {
        URI uri = this.getPhysicalURI();
        if (uri != null) {
            for (EditorKitFactoryPlugin plugin : ProtegeManager.getInstance().getEditorKitFactoryPlugins()) {
                if (!plugin.getId().equals(this.getEditorKit().getEditorKitFactory().getId())) continue;
                ProtegeManager.getInstance().loadAndSetupEditorKitFromURI(plugin, uri);
                break;
            }
        }
    }

    public void openInCurrentWorkspace() throws Exception {
        URI uri = this.getPhysicalURI();
        if (uri != null) {
            this.getOWLEditorKit().handleLoadFrom(uri);
        }
    }
}

