/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

import java.io.Serializable;
import java.util.Locale;
import sbt.internal.util.ScalaKeywords$;
import sbt.internal.util.Types$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;

public final class Util$ {
    public static Util$ MODULE$;
    private Regex Hyphen;
    private Regex Camel;
    private boolean isWindows;
    private boolean isCygwin;
    private boolean isNonCygwinWindows;
    private boolean isCygwinWindows;
    private volatile byte bitmap$0;

    static {
        new Util$();
    }

    public <T> List<T> makeList(int size, T value) {
        return (List)List$.MODULE$.fill(size, (Function0 & Serializable & scala.Serializable)() -> value);
    }

    public <A, B> Tuple2<Seq<A>, Seq<B>> separateE(Seq<Either<A, B>> ps) {
        return this.separate(ps, Types$.MODULE$.idFun());
    }

    public <T, A, B> Tuple2<Seq<A>, Seq<B>> separate(Seq<T> ps, Function1<T, Either<A, B>> f) {
        Tuple2 tuple2 = new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$);
        Tuple2 tuple22 = (Tuple2)ps.$div$colon((Object)tuple2, (Function2 & Serializable & scala.Serializable)(xs, y) -> MODULE$.prependEither((Tuple2)xs, (Either)((Either)f.apply(y))));
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Seq a = (Seq)tuple22._1();
        Seq b = (Seq)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)a, (Object)b);
        Tuple2 tuple24 = tuple23;
        Seq a2 = (Seq)tuple24._1();
        Seq b2 = (Seq)tuple24._2();
        return new Tuple2(a2.reverse(), b2.reverse());
    }

    public <A, B> Tuple2<Seq<A>, Seq<B>> prependEither(Tuple2<Seq<A>, Seq<B>> acc, Either<A, B> next) {
        Tuple2 tuple2;
        Either<A, B> either = next;
        if (either instanceof Left) {
            Object l;
            Left left = (Left)either;
            Object object = l = left.value();
            tuple2 = new Tuple2(((SeqLike)acc._1()).$plus$colon(object, Seq$.MODULE$.canBuildFrom()), acc._2());
        } else if (either instanceof Right) {
            Object r;
            Right right = (Right)either;
            Object object = r = right.value();
            tuple2 = new Tuple2(acc._1(), ((SeqLike)acc._2()).$plus$colon(object, Seq$.MODULE$.canBuildFrom()));
        } else {
            throw new MatchError(either);
        }
        return tuple2;
    }

    public <A, B> Function2<A, B, Tuple2<A, B>> pairID() {
        return (Function2 & Serializable & scala.Serializable)(a, b) -> new Tuple2(a, b);
    }

    private Regex Hyphen$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.Hyphen = new StringOps(Predef$.MODULE$.augmentString("-(\\p{javaLowerCase})")).r();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.Hyphen;
    }

    private Regex Hyphen() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.Hyphen$lzycompute() : this.Hyphen;
    }

    public boolean hasHyphen(String s) {
        return s.indexOf(45) >= 0;
    }

    public String hyphenToCamel(String s) {
        return this.hasHyphen(s) ? this.Hyphen().replaceAllIn((CharSequence)s, (Function1 & Serializable & scala.Serializable)x$5 -> x$5.group(1).toUpperCase(Locale.ENGLISH)) : s;
    }

    private Regex Camel$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.Camel = new StringOps(Predef$.MODULE$.augmentString("(\\p{javaLowerCase})(\\p{javaUpperCase})")).r();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.Camel;
    }

    private Regex Camel() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.Camel$lzycompute() : this.Camel;
    }

    public String camelToHyphen(String s) {
        return this.Camel().replaceAllIn((CharSequence)s, (Function1 & Serializable & scala.Serializable)m -> new StringBuilder(1).append(m.group(1)).append("-").append(m.group(2).toLowerCase(Locale.ENGLISH)).toString());
    }

    public String quoteIfKeyword(String s) {
        return ScalaKeywords$.MODULE$.values().apply((Object)s) ? new StringBuilder(11).append('`').append(s).append('`').toString() : s;
    }

    private boolean isWindows$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.isWindows;
    }

    public boolean isWindows() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.isWindows$lzycompute() : this.isWindows;
    }

    private boolean isCygwin$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                boolean bl;
                Option os = Option$.MODULE$.apply((Object)System.getenv("OSTYPE"));
                Option option = os;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String x = (String)some.value();
                    bl = x.toLowerCase(Locale.ENGLISH).contains("cygwin");
                } else {
                    bl = false;
                }
                this.isCygwin = bl;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.isCygwin;
    }

    public boolean isCygwin() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.isCygwin$lzycompute() : this.isCygwin;
    }

    private boolean isNonCygwinWindows$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.isNonCygwinWindows = this.isWindows() && !this.isCygwin();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.isNonCygwinWindows;
    }

    public boolean isNonCygwinWindows() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.isNonCygwinWindows$lzycompute() : this.isNonCygwinWindows;
    }

    private boolean isCygwinWindows$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.isCygwinWindows = this.isWindows() && this.isCygwin();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.isCygwinWindows;
    }

    public boolean isCygwinWindows() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.isCygwinWindows$lzycompute() : this.isCygwinWindows;
    }

    private Util$() {
        MODULE$ = this;
    }
}

