/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsAbbrev;
import com.dickimawbooks.bib2gls.Bib2GlsBibParser;
import com.dickimawbooks.bib2gls.Bib2GlsBibTeXEntry;
import com.dickimawbooks.bib2gls.Bib2GlsContributor;
import com.dickimawbooks.bib2gls.Bib2GlsDualAbbrev;
import com.dickimawbooks.bib2gls.Bib2GlsDualAbbrevEntry;
import com.dickimawbooks.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.bib2gls.Bib2GlsDualEntryAbbrev;
import com.dickimawbooks.bib2gls.Bib2GlsDualIndexAbbrev;
import com.dickimawbooks.bib2gls.Bib2GlsDualIndexEntry;
import com.dickimawbooks.bib2gls.Bib2GlsDualIndexSymbol;
import com.dickimawbooks.bib2gls.Bib2GlsDualSymbol;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsIndex;
import com.dickimawbooks.bib2gls.Bib2GlsIndexPlural;
import com.dickimawbooks.bib2gls.Bib2GlsMultiEntry;
import com.dickimawbooks.bib2gls.Bib2GlsSymbol;
import com.dickimawbooks.bib2gls.Bib2GlsTertiaryIndexAbbrevEntry;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.At;
import com.dickimawbooks.texparserlib.bib.BibData;
import com.dickimawbooks.texparserlib.bib.BibEntry;
import com.dickimawbooks.texparserlib.bib.BibPreamble;
import com.dickimawbooks.texparserlib.bib.BibTeXSyntaxException;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;

public class Bib2GlsAt
extends At {
    private GlsResource resource;

    public Bib2GlsAt(GlsResource glsResource) {
        this.resource = glsResource;
    }

    @Override
    protected void process(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        BibData bibData;
        String string;
        if (!(teXObject instanceof TeXObjectList)) {
            throw new BibTeXSyntaxException(teXParser, "bibtex.error.expecting_or", "{", "(");
        }
        Bib2GlsBibParser bib2GlsBibParser = (Bib2GlsBibParser)teXParser.getListener();
        Bib2Gls bib2Gls = (Bib2Gls)bib2GlsBibParser.getTeXApp();
        String string2 = string = teXObjectList.toString(teXParser).trim().toLowerCase();
        if ((string = this.resource.mapEntryType(string)).equals("entry")) {
            bibData = new Bib2GlsEntry(bib2Gls);
        } else if (string.equals("index")) {
            bibData = new Bib2GlsIndex(bib2Gls);
        } else if (string.equals("indexplural")) {
            bibData = new Bib2GlsIndexPlural(bib2Gls);
        } else if (string.equals("acronym") || string.equals("abbreviation")) {
            bibData = new Bib2GlsAbbrev(bib2Gls, string);
        } else if (string.equals("symbol") || string.equals("number")) {
            bibData = new Bib2GlsSymbol(bib2Gls, string);
        } else if (string.equals("dualentry")) {
            bibData = new Bib2GlsDualEntry(bib2Gls);
        } else if (string.equals("dualentryabbreviation")) {
            bibData = new Bib2GlsDualEntryAbbrev(bib2Gls);
        } else if (string.equals("dualabbreviationentry")) {
            bibData = new Bib2GlsDualAbbrevEntry(bib2Gls);
        } else if (string.equals("dualindexentry")) {
            bibData = new Bib2GlsDualIndexEntry(bib2Gls);
        } else if (string.equals("dualindexsymbol")) {
            bibData = new Bib2GlsDualIndexSymbol(bib2Gls);
        } else if (string.equals("dualindexnumber")) {
            bibData = new Bib2GlsDualIndexSymbol(bib2Gls, string, "number");
        } else if (string.equals("dualindexabbreviation")) {
            bibData = new Bib2GlsDualIndexAbbrev(bib2Gls);
        } else if (string.equals("tertiaryindexabbreviationentry")) {
            bibData = new Bib2GlsTertiaryIndexAbbrevEntry(bib2Gls);
        } else if (string.equals("dualabbreviation") || string.equals("dualacronym")) {
            bibData = new Bib2GlsDualAbbrev(bib2Gls, string);
        } else if (string.equals("dualsymbol") || string.equals("dualnumber")) {
            bibData = new Bib2GlsDualSymbol(bib2Gls, string);
        } else if (string.equals("bibtexentry")) {
            bibData = new Bib2GlsBibTeXEntry(bib2Gls);
        } else if (string.equals("contributor")) {
            bibData = new Bib2GlsContributor(bib2Gls);
        } else {
            bibData = BibData.createBibData(string);
            if (bibData instanceof BibEntry) {
                bib2Gls.warning(teXParser, bib2Gls.getMessage("warning.ignoring.unknown.entry.type", string));
            }
        }
        try {
            ((BibData)bibData).parseContents(teXParser, (TeXObjectList)teXObject, teXObject2);
        }
        catch (BibTeXSyntaxException bibTeXSyntaxException) {
            String string3 = null;
            StringBuilder stringBuilder = null;
            if (bibData instanceof BibEntry) {
                string3 = ((BibEntry)bibData).getId();
                if (string3 == null) {
                    throw new IOException(bib2Gls.getMessage("error.invalid.id", bibTeXSyntaxException.getMessage(bib2Gls)), bibTeXSyntaxException);
                }
                if (this.containsSpecialChars(string3)) {
                    bib2Gls.warning(teXParser, bib2Gls.getMessage("warning.spchars.id", string3));
                }
                if (!bib2Gls.fontSpecLoaded() && this.containsExtendedChars(string3)) {
                    bib2Gls.warning(teXParser, bib2Gls.getMessage("warning.notbasiclatin.id", string3));
                }
            }
            stringBuilder = new StringBuilder();
            for (TeXObject teXObject3 : (TeXObjectList)teXObject) {
                stringBuilder.append(teXObject3.toString(teXParser));
                if (!(teXObject3 instanceof Group)) continue;
                break;
            }
            if (stringBuilder != null && stringBuilder.length() > 0) {
                if (string3 == null) {
                    throw new IOException(bib2Gls.getMessage("error.bib.contents.parse.before", ((BibData)bibData).getEntryType(), bibTeXSyntaxException.getMessage(bib2Gls), stringBuilder), bibTeXSyntaxException);
                }
                throw new IOException(bib2Gls.getMessage("error.bib.contents.parse.data.before", ((BibData)bibData).getEntryType(), string3, bibTeXSyntaxException.getMessage(bib2Gls), stringBuilder), bibTeXSyntaxException);
            }
            if (string3 != null) {
                throw new IOException(bib2Gls.getMessage("error.bib.contents.parse.data", ((BibData)bibData).getEntryType(), string3, bibTeXSyntaxException.getMessage(bib2Gls)), bibTeXSyntaxException);
            }
            throw new IOException(bib2Gls.getMessage("error.bib.contents.parse", ((BibData)bibData).getEntryType(), bibTeXSyntaxException.getMessage(bib2Gls)), bibTeXSyntaxException);
        }
        if (bibData instanceof BibPreamble) {
            BibValueList bibValueList = ((BibPreamble)bibData).getPreamble();
            TeXObjectList teXObjectList2 = bibValueList.expand(teXParser);
            this.resource.setPreamble(teXObjectList2.toString(teXParser), bibValueList);
        } else if (bibData instanceof Bib2GlsEntry) {
            bibData.setOriginalEntryType(string2);
            String string4 = bibData.getId();
            if (bib2GlsBibParser.getBibEntry(string4) != null) {
                throw new BibTeXSyntaxException(teXParser, "bibtex.error.repeated_entry", string4);
            }
            bibData.setBase(bib2GlsBibParser.getBase());
        }
        bib2GlsBibParser.addBibData(bibData);
        if (bibData instanceof Bib2GlsMultiEntry) {
            ((Bib2GlsMultiEntry)bibData).populate(bib2GlsBibParser);
        }
    }

    protected boolean containsSpecialChars(String string) {
        int n;
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (n != 36 && n != 94 && n != 126 && n != 35 && n != 123 && n != 125 && n != 95 && n != 38 && n != 92 && n != 37) continue;
            return true;
        }
        return false;
    }

    protected boolean containsExtendedChars(String string) {
        int n;
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (n <= 127) continue;
            return true;
        }
        return false;
    }
}

