/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import javaslang.collection.Iterator;
import javaslang.collection.List;
import javaslang.collection.Seq;
import javaslang.collection.Stream;
import javaslang.collection.Traversable;
import javaslang.collection.TreeModule;

public interface Tree<T>
extends Serializable,
Traversable<T> {
    public T getValue();

    public List<Node<T>> getChildren();

    public boolean isLeaf();

    @Override
    public int size();

    default public Seq<Node<T>> traverse(Order order) {
        Objects.requireNonNull(order, "order is null");
        if (this.isEmpty()) {
            return Stream.empty();
        }
        Node node = (Node)this;
        switch (order) {
            case PRE_ORDER: {
                return TreeModule.Traversal.preOrder(node);
            }
            case IN_ORDER: {
                return TreeModule.Traversal.inOrder(node);
            }
            case POST_ORDER: {
                return TreeModule.Traversal.postOrder(node);
            }
            case LEVEL_ORDER: {
                return TreeModule.Traversal.levelOrder(node);
            }
        }
        throw new IllegalStateException("Unknown order: " + order.name());
    }

    default public Seq<T> values() {
        return this.traverse(Order.PRE_ORDER).map(Node::getValue);
    }

    @Override
    default public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty tree");
        }
        return (T)this.iterator().next();
    }

    @Override
    default public boolean isTraversableAgain() {
        return true;
    }

    @Override
    default public Iterator<T> iterator() {
        return this.values().iterator();
    }

    @Override
    default public int length() {
        return this.size();
    }

    @Override
    default public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length(), 1040);
    }

    @Override
    default public String stringPrefix() {
        return "Tree";
    }

    @Override
    default public Seq<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty tree");
        }
        return this.values().tail();
    }

    @Override
    public String toString();

    public static enum Order {
        PRE_ORDER,
        IN_ORDER,
        POST_ORDER,
        LEVEL_ORDER;

    }

    public static final class Node<T>
    implements Serializable,
    Tree<T> {
        private final T value;
        private final List<Node<T>> children;

        @Override
        public List<Node<T>> getChildren() {
            return this.children;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        @Override
        public int size() {
            return 1 + this.children.foldLeft(0, (acc, child) -> acc + child.length());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Node) {
                Node that = (Node)o;
                return Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getChildren(), that.getChildren());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.value, this.children);
        }

        @Override
        public String toString() {
            return this.stringPrefix() + (this.isLeaf() ? "(" + this.value + ")" : Node.toLispString(this));
        }

        private static String toLispString(Tree<?> tree) {
            String value = String.valueOf(tree.getValue());
            if (tree.isLeaf()) {
                return value;
            }
            return String.format("(%s %s)", value, tree.getChildren().map(Node::toLispString).mkString(" "));
        }
    }
}

