/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative.tool;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.net.ssl.SSLException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.LoggingAwareMultiCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.support.Validation;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;
import org.elasticsearch.xpack.security.authc.esnative.tool.CommandLineHttpClient;
import org.elasticsearch.xpack.security.authc.esnative.tool.HttpResponse;

public class SetupPasswordTool
extends LoggingAwareMultiCommand {
    private static final char[] CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    public static final List<String> USERS = Arrays.asList("elastic", "kibana", "logstash_system", "beats_system");
    private final BiFunction<Environment, Settings, CommandLineHttpClient> clientFunction;
    private final CheckedFunction<Environment, KeyStoreWrapper, Exception> keyStoreFunction;
    private CommandLineHttpClient client;

    SetupPasswordTool() {
        this((environment, settings) -> new CommandLineHttpClient((Settings)settings, (Environment)environment), (CheckedFunction<Environment, KeyStoreWrapper, Exception>)((CheckedFunction)environment -> {
            KeyStoreWrapper keyStoreWrapper = KeyStoreWrapper.load((Path)environment.configFile());
            if (keyStoreWrapper == null) {
                throw new UserException(78, "Elasticsearch keystore file is missing [" + KeyStoreWrapper.keystorePath((Path)environment.configFile()) + "]");
            }
            return keyStoreWrapper;
        }));
    }

    SetupPasswordTool(BiFunction<Environment, Settings, CommandLineHttpClient> clientFunction, CheckedFunction<Environment, KeyStoreWrapper, Exception> keyStoreFunction) {
        super("Sets the passwords for reserved users");
        this.subcommands.put("auto", this.newAutoSetup());
        this.subcommands.put("interactive", this.newInteractiveSetup());
        this.clientFunction = clientFunction;
        this.keyStoreFunction = keyStoreFunction;
    }

    protected AutoSetup newAutoSetup() {
        return new AutoSetup();
    }

    protected InteractiveSetup newInteractiveSetup() {
        return new InteractiveSetup();
    }

    public static void main(String[] args) throws Exception {
        SetupPasswordTool.exit((int)new SetupPasswordTool().main(args, Terminal.DEFAULT));
    }

    OptionParser getParser() {
        return this.parser;
    }

    private String getErrorCause(HttpResponse httpResponse) {
        Object error = httpResponse.getResponseBody().get("error");
        if (error == null) {
            return null;
        }
        if (error instanceof Map) {
            Object reason = ((Map)error).get("reason");
            if (reason != null) {
                return reason.toString();
            }
            Object root = ((Map)error).get("root_cause");
            if (root != null && root instanceof Map) {
                reason = ((Map)root).get("reason");
                if (reason != null) {
                    return reason.toString();
                }
                Object type = ((Map)root).get("type");
                if (type != null) {
                    return (String)type;
                }
            }
            return String.valueOf(((Map)error).get("type"));
        }
        return error.toString();
    }

    private byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] internalBuffer = new byte[1024];
        int read = is.read(internalBuffer);
        while (read != -1) {
            baos.write(internalBuffer, 0, read);
            read = is.read(internalBuffer);
        }
        return baos.toByteArray();
    }

    static class XPackSecurityFeatureConfig {
        final boolean isAvailable;
        final boolean isEnabled;

        XPackSecurityFeatureConfig(boolean isAvailable, boolean isEnabled) {
            this.isAvailable = isAvailable;
            this.isEnabled = isEnabled;
        }
    }

    private abstract class SetupCommand
    extends EnvironmentAwareCommand {
        boolean shouldPrompt;
        private OptionSpec<String> urlOption;
        private OptionSpec<String> noPromptOption;
        private String elasticUser;
        private SecureString elasticUserPassword;
        private KeyStoreWrapper keyStoreWrapper;
        private URL url;

        SetupCommand(String description) {
            super(description);
            this.elasticUser = "elastic";
            this.setParser();
        }

        public void close() {
            if (this.keyStoreWrapper != null) {
                this.keyStoreWrapper.close();
            }
            if (this.elasticUserPassword != null) {
                this.elasticUserPassword.close();
            }
        }

        void setupOptions(OptionSet options, Environment env) throws Exception {
            this.keyStoreWrapper = (KeyStoreWrapper)SetupPasswordTool.this.keyStoreFunction.apply((Object)env);
            this.keyStoreWrapper.decrypt(new char[0]);
            Settings.Builder settingsBuilder = Settings.builder();
            settingsBuilder.put(env.settings(), true);
            if (settingsBuilder.getSecureSettings() == null) {
                settingsBuilder.setSecureSettings((SecureSettings)this.keyStoreWrapper);
            }
            Settings settings = settingsBuilder.build();
            this.elasticUserPassword = (SecureString)ReservedRealm.BOOTSTRAP_ELASTIC_PASSWORD.get(settings);
            SetupPasswordTool.this.client = (CommandLineHttpClient)SetupPasswordTool.this.clientFunction.apply(env, settings);
            String providedUrl = (String)this.urlOption.value(options);
            this.url = new URL(providedUrl == null ? SetupPasswordTool.this.client.getDefaultURL() : providedUrl);
            this.setShouldPrompt(options);
        }

        private void setParser() {
            this.urlOption = this.parser.acceptsAll(Arrays.asList("u", "url"), "The url for the change password request.").withRequiredArg();
            this.noPromptOption = this.parser.acceptsAll(Arrays.asList("b", "batch"), "If enabled, run the change password process without prompting the user.").withOptionalArg();
        }

        private void setShouldPrompt(OptionSet options) {
            String optionalNoPrompt = (String)this.noPromptOption.value(options);
            this.shouldPrompt = options.has(this.noPromptOption) ? optionalNoPrompt != null && !Booleans.parseBoolean((String)optionalNoPrompt) : true;
        }

        void checkElasticKeystorePasswordValid(Terminal terminal, Environment env) throws Exception {
            URL route = this.createURL(this.url, "/_xpack/security/_authenticate", "?pretty");
            terminal.println(Terminal.Verbosity.VERBOSE, "");
            terminal.println(Terminal.Verbosity.VERBOSE, "Testing if bootstrap password is valid for " + route.toString());
            try {
                HttpResponse httpResponse = SetupPasswordTool.this.client.execute("GET", route, this.elasticUser, this.elasticUserPassword, (CheckedSupplier<String, Exception>)((CheckedSupplier)() -> null), (CheckedFunction<InputStream, HttpResponse.HttpResponseBuilder, Exception>)((CheckedFunction)is -> this.responseBuilder((InputStream)is, terminal)));
                int httpCode = httpResponse.getHttpStatus();
                if (httpCode == 401) {
                    terminal.println("");
                    terminal.println("Failed to authenticate user '" + this.elasticUser + "' against " + route.toString());
                    terminal.println("Possible causes include:");
                    terminal.println(" * The password for the '" + this.elasticUser + "' user has already been changed on this cluster");
                    terminal.println(" * Your elasticsearch node is running against a different keystore");
                    terminal.println("   This tool used the keystore at " + KeyStoreWrapper.keystorePath((Path)env.configFile()));
                    terminal.println("");
                    throw new UserException(78, "Failed to verify bootstrap password");
                }
                if (httpCode != 200) {
                    terminal.println("");
                    terminal.println("Unexpected response code [" + httpCode + "] from calling GET " + route.toString());
                    XPackSecurityFeatureConfig xPackSecurityFeatureConfig = this.getXPackSecurityConfig(terminal);
                    if (!xPackSecurityFeatureConfig.isAvailable) {
                        terminal.println("It doesn't look like the X-Pack security feature is available on this Elasticsearch node.");
                        terminal.println("Please check if you have installed a license that allows access to X-Pack Security feature.");
                        terminal.println("");
                        throw new UserException(78, "X-Pack Security is not available.");
                    }
                    if (!xPackSecurityFeatureConfig.isEnabled) {
                        terminal.println("It doesn't look like the X-Pack security feature is enabled on this Elasticsearch node.");
                        terminal.println("Please check if you have enabled X-Pack security in your elasticsearch.yml configuration file.");
                        terminal.println("");
                        throw new UserException(78, "X-Pack Security is disabled by configuration.");
                    }
                    terminal.println("X-Pack security feature is available and enabled on this Elasticsearch node.");
                    terminal.println("Possible causes include:");
                    terminal.println(" * The relative path of the URL is incorrect. Is there a proxy in-between?");
                    terminal.println(" * The protocol (http/https) does not match the port.");
                    terminal.println(" * Is this really an Elasticsearch server?");
                    terminal.println("");
                    throw new UserException(78, "Unknown error");
                }
            }
            catch (SSLException e) {
                terminal.println("");
                terminal.println("SSL connection to " + route.toString() + " failed: " + e.getMessage());
                terminal.println("Please check the elasticsearch SSL settings under " + XPackSettings.HTTP_SSL_PREFIX);
                terminal.println(Terminal.Verbosity.VERBOSE, "");
                terminal.println(Terminal.Verbosity.VERBOSE, ExceptionsHelper.stackTrace((Throwable)e));
                terminal.println("");
                throw new UserException(78, "Failed to establish SSL connection to elasticsearch at " + route.toString() + ". ", (Throwable)e);
            }
            catch (IOException e) {
                terminal.println("");
                terminal.println("Connection failure to: " + route.toString() + " failed: " + e.getMessage());
                terminal.println(Terminal.Verbosity.VERBOSE, "");
                terminal.println(Terminal.Verbosity.VERBOSE, ExceptionsHelper.stackTrace((Throwable)e));
                terminal.println("");
                throw new UserException(78, "Failed to connect to elasticsearch at " + route.toString() + ". Is the URL correct and elasticsearch running?", (Throwable)e);
            }
        }

        private XPackSecurityFeatureConfig getXPackSecurityConfig(Terminal terminal) throws Exception {
            Map featureInfo;
            Map features;
            URL route = this.createURL(this.url, "/_xpack", "?categories=features&human=false&pretty");
            HttpResponse httpResponse = SetupPasswordTool.this.client.execute("GET", route, this.elasticUser, this.elasticUserPassword, (CheckedSupplier<String, Exception>)((CheckedSupplier)() -> null), (CheckedFunction<InputStream, HttpResponse.HttpResponseBuilder, Exception>)((CheckedFunction)is -> this.responseBuilder((InputStream)is, terminal)));
            if (httpResponse.getHttpStatus() != 200) {
                terminal.println("");
                terminal.println("Unexpected response code [" + httpResponse.getHttpStatus() + "] from calling GET " + route.toString());
                if (httpResponse.getHttpStatus() == 400) {
                    terminal.println("It doesn't look like the X-Pack is available on this Elasticsearch node.");
                    terminal.println("Please check that you have followed all installation instructions and that this tool");
                    terminal.println("   is pointing to the correct Elasticsearch server.");
                    terminal.println("");
                    throw new UserException(78, "X-Pack is not available on this Elasticsearch node.");
                }
                terminal.println("* Try running this tool again.");
                terminal.println("* Verify that the tool is pointing to the correct Elasticsearch server.");
                terminal.println("* Check the elasticsearch logs for additional error details.");
                terminal.println("");
                throw new UserException(75, "Failed to determine x-pack security feature configuration.");
            }
            if (httpResponse.getHttpStatus() == 200 && httpResponse.getResponseBody() != null && (features = (Map)httpResponse.getResponseBody().get("features")) != null && (featureInfo = (Map)features.get("security")) != null) {
                XPackSecurityFeatureConfig xPackSecurityFeatureConfig = new XPackSecurityFeatureConfig(Boolean.parseBoolean(featureInfo.get("available").toString()), Boolean.parseBoolean(featureInfo.get("enabled").toString()));
                return xPackSecurityFeatureConfig;
            }
            terminal.println("");
            terminal.println("Unexpected response from calling GET " + route.toString());
            terminal.println("* Try running this tool again.");
            terminal.println("* Verify that the tool is pointing to the correct Elasticsearch server.");
            terminal.println("* Check the elasticsearch logs for additional error details.");
            terminal.println("");
            throw new UserException(75, "Failed to determine x-pack security feature configuration.");
        }

        void checkClusterHealth(Terminal terminal) throws Exception {
            URL route = this.createURL(this.url, "/_cluster/health", "?pretty");
            terminal.println(Terminal.Verbosity.VERBOSE, "");
            terminal.println(Terminal.Verbosity.VERBOSE, "Checking cluster health: " + route.toString());
            HttpResponse httpResponse = SetupPasswordTool.this.client.execute("GET", route, this.elasticUser, this.elasticUserPassword, (CheckedSupplier<String, Exception>)((CheckedSupplier)() -> null), (CheckedFunction<InputStream, HttpResponse.HttpResponseBuilder, Exception>)((CheckedFunction)is -> this.responseBuilder((InputStream)is, terminal)));
            if (httpResponse.getHttpStatus() != 200) {
                terminal.println("");
                terminal.println("Failed to determine the health of the cluster running at " + this.url);
                terminal.println("Unexpected response code [" + httpResponse.getHttpStatus() + "] from calling GET " + route.toString());
                String cause = SetupPasswordTool.this.getErrorCause(httpResponse);
                if (cause != null) {
                    terminal.println("Cause: " + cause);
                }
            } else {
                String clusterStatus = Objects.toString(httpResponse.getResponseBody().get("status"), "");
                if (clusterStatus.isEmpty()) {
                    terminal.println("");
                    terminal.println("Failed to determine the health of the cluster running at " + this.url);
                    terminal.println("Could not find a 'status' value at " + route.toString());
                } else if ("red".equalsIgnoreCase(clusterStatus)) {
                    terminal.println("");
                    terminal.println("Your cluster health is currently RED.");
                    terminal.println("This means that some cluster data is unavailable and your cluster is not fully functional.");
                } else {
                    return;
                }
            }
            terminal.println("");
            terminal.println("It is recommended that you resolve the issues with your cluster before running elasticsearch-setup-passwords.");
            terminal.println("It is very likely that the password changes will fail when run against an unhealthy cluster.");
            terminal.println("");
            if (this.shouldPrompt) {
                boolean keepGoing = terminal.promptYesNo("Do you want to continue with the password setup process", false);
                if (!keepGoing) {
                    throw new UserException(0, "User cancelled operation");
                }
                terminal.println("");
            }
        }

        private void changeUserPassword(String user, SecureString password, Terminal terminal) throws Exception {
            URL route = this.createURL(this.url, "/_xpack/security/user/" + user + "/_password", "?pretty");
            terminal.println(Terminal.Verbosity.VERBOSE, "");
            terminal.println(Terminal.Verbosity.VERBOSE, "Trying user password change call " + route.toString());
            try {
                SecureString supplierPassword = password.clone();
                HttpResponse httpResponse = SetupPasswordTool.this.client.execute("PUT", route, this.elasticUser, this.elasticUserPassword, (CheckedSupplier<String, Exception>)((CheckedSupplier)() -> {
                    try {
                        XContentBuilder xContentBuilder = JsonXContent.contentBuilder();
                        xContentBuilder.startObject().field("password", supplierPassword.toString()).endObject();
                        String string = Strings.toString((XContentBuilder)xContentBuilder);
                        return string;
                    }
                    finally {
                        supplierPassword.close();
                    }
                }), (CheckedFunction<InputStream, HttpResponse.HttpResponseBuilder, Exception>)((CheckedFunction)is -> this.responseBuilder((InputStream)is, terminal)));
                if (httpResponse.getHttpStatus() != 200) {
                    terminal.println("");
                    terminal.println("Unexpected response code [" + httpResponse.getHttpStatus() + "] from calling PUT " + route.toString());
                    String cause = SetupPasswordTool.this.getErrorCause(httpResponse);
                    if (cause != null) {
                        terminal.println("Cause: " + cause);
                        terminal.println("");
                    }
                    terminal.println("Possible next steps:");
                    terminal.println("* Try running this tool again.");
                    terminal.println("* Try running with the --verbose parameter for additional messages.");
                    terminal.println("* Check the elasticsearch logs for additional error details.");
                    terminal.println("* Use the change password API manually. ");
                    terminal.println("");
                    throw new UserException(75, "Failed to set password for user [" + user + "].");
                }
            }
            catch (IOException e) {
                terminal.println("");
                terminal.println("Connection failure to: " + route.toString() + " failed: " + e.getMessage());
                terminal.println(Terminal.Verbosity.VERBOSE, "");
                terminal.println(Terminal.Verbosity.VERBOSE, ExceptionsHelper.stackTrace((Throwable)e));
                terminal.println("");
                throw new UserException(75, "Failed to set password for user [" + user + "].", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void changePasswords(CheckedFunction<String, SecureString, UserException> passwordFn, CheckedBiConsumer<String, SecureString, Exception> successCallback, Terminal terminal) throws Exception {
            HashMap<String, SecureString> passwordsMap = new HashMap<String, SecureString>(USERS.size());
            try {
                for (String user2 : USERS) {
                    passwordsMap.put(user2, (SecureString)passwordFn.apply((Object)user2));
                }
                Map.Entry superUserEntry = null;
                for (Map.Entry entry : passwordsMap.entrySet()) {
                    if (((String)entry.getKey()).equals(this.elasticUser)) {
                        superUserEntry = entry;
                        continue;
                    }
                    this.changeUserPassword((String)entry.getKey(), (SecureString)entry.getValue(), terminal);
                    successCallback.accept((Object)((String)entry.getKey()), (Object)((SecureString)entry.getValue()));
                }
                if (superUserEntry != null) {
                    this.changeUserPassword((String)superUserEntry.getKey(), (SecureString)superUserEntry.getValue(), terminal);
                    successCallback.accept((Object)((String)superUserEntry.getKey()), (Object)((SecureString)superUserEntry.getValue()));
                }
            }
            finally {
                passwordsMap.forEach((user, pass) -> pass.close());
            }
        }

        private HttpResponse.HttpResponseBuilder responseBuilder(InputStream is, Terminal terminal) throws IOException {
            HttpResponse.HttpResponseBuilder httpResponseBuilder = new HttpResponse.HttpResponseBuilder();
            if (is != null) {
                byte[] bytes = SetupPasswordTool.this.toByteArray(is);
                String responseBody = new String(bytes, StandardCharsets.UTF_8);
                terminal.println(Terminal.Verbosity.VERBOSE, responseBody);
                httpResponseBuilder.withResponseBody(responseBody);
            } else {
                terminal.println(Terminal.Verbosity.VERBOSE, "<Empty response>");
            }
            return httpResponseBuilder;
        }

        private URL createURL(URL url, String path, String query) throws MalformedURLException, URISyntaxException {
            return new URL(url, (url.toURI().getPath() + path).replaceAll("/+", "/") + query);
        }
    }

    class InteractiveSetup
    extends SetupCommand {
        InteractiveSetup() {
            super("Uses passwords entered by a user");
        }

        protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
            terminal.println(Terminal.Verbosity.VERBOSE, "Running with configuration path: " + env.configFile());
            this.setupOptions(options, env);
            this.checkElasticKeystorePasswordValid(terminal, env);
            this.checkClusterHealth(terminal);
            if (this.shouldPrompt) {
                terminal.println("Initiating the setup of passwords for reserved users " + String.join((CharSequence)",", USERS) + ".");
                terminal.println("You will be prompted to enter passwords as the process progresses.");
                boolean shouldContinue = terminal.promptYesNo("Please confirm that you would like to continue", false);
                terminal.println("\n");
                if (!shouldContinue) {
                    throw new UserException(0, "User cancelled operation");
                }
            }
            this.changePasswords((CheckedFunction<String, SecureString, UserException>)((CheckedFunction)user -> this.promptForPassword(terminal, (String)user)), (CheckedBiConsumer<String, SecureString, Exception>)((CheckedBiConsumer)(user, password) -> this.changedPasswordCallback(terminal, (String)user, (SecureString)password)), terminal);
        }

        private SecureString promptForPassword(Terminal terminal, String user) throws UserException {
            SecureString password1;
            while (true) {
                Validation.Error err;
                if ((err = Validation.Users.validatePassword((char[])(password1 = new SecureString(terminal.readSecret("Enter password for [" + user + "]: "))).getChars())) != null) {
                    terminal.println(err.toString());
                    terminal.println("Try again.");
                    password1.close();
                    continue;
                }
                SecureString password2 = new SecureString(terminal.readSecret("Reenter password for [" + user + "]: "));
                Throwable throwable = null;
                try {
                    if (password1.equals((Object)password2)) break;
                    terminal.println("Passwords do not match.");
                    terminal.println("Try again.");
                    password1.close();
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (throwable != null) {
                        try {
                            password2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    password2.close();
                    continue;
                }
                break;
            }
            return password1;
        }

        private void changedPasswordCallback(Terminal terminal, String user, SecureString password) {
            terminal.println("Changed password for user [" + user + "]");
        }
    }

    class AutoSetup
    extends SetupCommand {
        AutoSetup() {
            super("Uses randomly generated passwords");
        }

        protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
            terminal.println(Terminal.Verbosity.VERBOSE, "Running with configuration path: " + env.configFile());
            this.setupOptions(options, env);
            this.checkElasticKeystorePasswordValid(terminal, env);
            this.checkClusterHealth(terminal);
            if (this.shouldPrompt) {
                terminal.println("Initiating the setup of passwords for reserved users " + String.join((CharSequence)",", USERS) + ".");
                terminal.println("The passwords will be randomly generated and printed to the console.");
                boolean shouldContinue = terminal.promptYesNo("Please confirm that you would like to continue", false);
                terminal.println("\n");
                if (!shouldContinue) {
                    throw new UserException(0, "User cancelled operation");
                }
            }
            SecureRandom secureRandom = new SecureRandom();
            this.changePasswords((CheckedFunction<String, SecureString, UserException>)((CheckedFunction)user -> this.generatePassword(secureRandom, (String)user)), (CheckedBiConsumer<String, SecureString, Exception>)((CheckedBiConsumer)(user, password) -> this.changedPasswordCallback(terminal, (String)user, (SecureString)password)), terminal);
        }

        private SecureString generatePassword(SecureRandom secureRandom, String user) {
            int passwordLength = 20;
            char[] characters = new char[passwordLength];
            for (int i = 0; i < passwordLength; ++i) {
                characters[i] = CHARS[secureRandom.nextInt(CHARS.length)];
            }
            return new SecureString(characters);
        }

        private void changedPasswordCallback(Terminal terminal, String user, SecureString password) {
            terminal.println("Changed password for user " + user + "\nPASSWORD " + user + " = " + password + "\n");
        }
    }
}

