/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.saml.IdpConfiguration;
import org.elasticsearch.xpack.security.authc.saml.SamlAttributes;
import org.elasticsearch.xpack.security.authc.saml.SamlNameId;
import org.elasticsearch.xpack.security.authc.saml.SamlRequestHandler;
import org.elasticsearch.xpack.security.authc.saml.SamlToken;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.elasticsearch.xpack.security.authc.saml.SpConfiguration;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.EncryptedAttribute;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusDetail;
import org.opensaml.saml.saml2.core.StatusMessage;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class SamlAuthenticator
extends SamlRequestHandler {
    private static final String RESPONSE_TAG_NAME = "Response";

    SamlAuthenticator(RealmConfig realmConfig, Clock clock, IdpConfiguration idp, SpConfiguration sp, TimeValue maxSkew) {
        super(realmConfig, clock, idp, sp, maxSkew);
    }

    SamlAttributes authenticate(SamlToken token) {
        Element root = this.parseSamlMessage(token.getContent());
        if (RESPONSE_TAG_NAME.equals(root.getLocalName()) && "urn:oasis:names:tc:SAML:2.0:protocol".equals(root.getNamespaceURI())) {
            try {
                return this.authenticateResponse(root, token.getAllowedSamlRequestIds());
            }
            catch (ElasticsearchSecurityException e) {
                this.logger.trace("Rejecting SAML response {} because {}", (Object)SamlUtils.toString(root), (Object)e.getMessage());
                throw e;
            }
        }
        throw SamlUtils.samlException("SAML content [{}] should have a root element of Namespace=[{}] Tag=[{}]", root, "urn:oasis:names:tc:SAML:2.0:protocol", RESPONSE_TAG_NAME);
    }

    private SamlAttributes authenticateResponse(Element element, Collection<String> allowedSamlRequestIds) {
        boolean requireSignedAssertions;
        Response response = this.buildXmlObject(element, Response.class);
        if (response == null) {
            throw SamlUtils.samlException("Cannot convert element {} into Response object", element);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(SamlUtils.describeSamlObject((SAMLObject)response));
        }
        if (response.isSigned()) {
            this.validateSignature(response.getSignature());
            requireSignedAssertions = false;
        } else {
            requireSignedAssertions = true;
        }
        if (Strings.hasText((String)response.getInResponseTo()) && !allowedSamlRequestIds.contains(response.getInResponseTo())) {
            this.logger.debug("The SAML Response with ID {} is unsolicited. A user might have used a stale URL or the Identity Provider incorrectly populates the InResponseTo attribute", (Object)response.getID());
            throw SamlUtils.samlException("SAML content is in-response-to {} but expected one of {} ", response.getInResponseTo(), allowedSamlRequestIds);
        }
        Status status = response.getStatus();
        if (status == null || status.getStatusCode() == null) {
            throw SamlUtils.samlException("SAML Response has no status code", new Object[0]);
        }
        if (!this.isSuccess(status)) {
            throw SamlUtils.samlException("SAML Response is not a 'success' response: Code={} Message={} Detail={}", status.getStatusCode().getValue(), this.getMessage(status), this.getDetail(status));
        }
        this.checkIssuer(response.getIssuer(), (XMLObject)response);
        this.checkResponseDestination(response);
        Tuple<Assertion, List<Attribute>> details = this.extractDetails(response, allowedSamlRequestIds, requireSignedAssertions);
        Assertion assertion = (Assertion)details.v1();
        SamlNameId nameId = SamlNameId.forSubject(assertion.getSubject());
        String session = this.getSessionIndex(assertion);
        List<SamlAttributes.SamlAttribute> attributes = ((List)details.v2()).stream().map(SamlAttributes.SamlAttribute::new).collect(Collectors.toList());
        if (this.logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("The SAML Assertion contained the following attributes: \n");
            for (SamlAttributes.SamlAttribute attr : attributes) {
                sb.append(attr).append("\n");
            }
            this.logger.trace(sb.toString());
        }
        if (attributes.isEmpty() && nameId == null) {
            this.logger.debug("The Attribute Statements of SAML Response with ID {} contained no attributes and the SAML Assertion Subject didnot contain a SAML NameID. Please verify that the Identity Provider configuration with regards to attribute release is correct. ", (Object)response.getID());
            throw SamlUtils.samlException("Could not process any SAML attributes in {}", response.getElementQName());
        }
        return new SamlAttributes(nameId, session, attributes);
    }

    private String getMessage(Status status) {
        StatusMessage sm = status.getStatusMessage();
        return sm == null ? null : sm.getMessage();
    }

    private String getDetail(Status status) {
        StatusDetail sd = status.getStatusDetail();
        return sd == null ? null : SamlUtils.toString(sd.getDOM());
    }

    private boolean isSuccess(Status status) {
        return status.getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Success");
    }

    private String getSessionIndex(Assertion assertion) {
        return assertion.getAuthnStatements().stream().map(as -> as.getSessionIndex()).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private void checkResponseDestination(Response response) {
        String asc = this.getSpConfiguration().getAscUrl();
        if (!asc.equals(response.getDestination()) && (response.isSigned() || Strings.hasText((String)response.getDestination()))) {
            throw SamlUtils.samlException("SAML response " + response.getID() + " is for destination " + response.getDestination() + " but this realm uses " + asc, new Object[0]);
        }
    }

    private Tuple<Assertion, List<Attribute>> extractDetails(Response response, Collection<String> allowedSamlRequestIds, boolean requireSignedAssertions) {
        int assertionCount = response.getAssertions().size() + response.getEncryptedAssertions().size();
        if (assertionCount > 1) {
            throw SamlUtils.samlException("Expecting only 1 assertion, but response contains multiple (" + assertionCount + ")", new Object[0]);
        }
        Iterator iterator = response.getAssertions().iterator();
        if (iterator.hasNext()) {
            Assertion assertion = (Assertion)iterator.next();
            return new Tuple((Object)assertion, this.processAssertion(assertion, requireSignedAssertions, allowedSamlRequestIds));
        }
        iterator = response.getEncryptedAssertions().iterator();
        if (iterator.hasNext()) {
            EncryptedAssertion encrypted = (EncryptedAssertion)iterator.next();
            Assertion assertion = this.decrypt(encrypted);
            this.moveToNewDocument((XMLObject)assertion);
            assertion.getDOM().setIdAttribute("ID", true);
            return new Tuple((Object)assertion, this.processAssertion(assertion, requireSignedAssertions, allowedSamlRequestIds));
        }
        throw SamlUtils.samlException("No assertions found in SAML response", new Object[0]);
    }

    private void moveToNewDocument(XMLObject xmlObject) {
        Element element = xmlObject.getDOM();
        Document doc = element.getOwnerDocument().getImplementation().createDocument(null, null, null);
        doc.adoptNode(element);
        doc.appendChild(element);
    }

    private Assertion decrypt(EncryptedAssertion encrypted) {
        if (this.decrypter == null) {
            throw SamlUtils.samlException("SAML assertion [" + this.text((XMLObject)encrypted, 32) + "] is encrypted, but no decryption key is available", new Object[0]);
        }
        try {
            return this.decrypter.decrypt(encrypted);
        }
        catch (DecryptionException e) {
            this.logger.debug(() -> new ParameterizedMessage("Failed to decrypt SAML assertion [{}] with [{}]", (Object)this.text((XMLObject)encrypted, 512), (Object)this.describe(this.getSpConfiguration().getEncryptionCredentials())), (Throwable)e);
            throw SamlUtils.samlException("Failed to decrypt SAML assertion " + this.text((XMLObject)encrypted, 32), (Exception)((Object)e), new Object[0]);
        }
    }

    private List<Attribute> processAssertion(Assertion assertion, boolean requireSignature, Collection<String> allowedSamlRequestIds) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("(Possibly decrypted) Assertion: {}", (Object)SamlUtils.samlObjectToString((SAMLObject)assertion));
            this.logger.trace(SamlUtils.describeSamlObject((SAMLObject)assertion));
        }
        if (assertion.isSigned()) {
            this.validateSignature(assertion.getSignature());
        } else if (requireSignature) {
            throw SamlUtils.samlException("Assertion [{}] is not signed, but a signature is required", assertion.getElementQName());
        }
        this.checkConditions(assertion.getConditions());
        this.checkIssuer(assertion.getIssuer(), (XMLObject)assertion);
        this.checkSubject(assertion.getSubject(), (XMLObject)assertion, allowedSamlRequestIds);
        this.checkAuthnStatement(assertion.getAuthnStatements());
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (AttributeStatement statement : assertion.getAttributeStatements()) {
            this.logger.trace("SAML AttributeStatement has [{}] attributes and [{}] encrypted attributes", (Object)statement.getAttributes().size(), (Object)statement.getEncryptedAttributes().size());
            attributes.addAll(statement.getAttributes());
            for (EncryptedAttribute enc : statement.getEncryptedAttributes()) {
                Attribute attribute = this.decrypt(enc);
                if (attribute == null) continue;
                this.logger.trace("Successfully decrypted attribute: {}" + SamlUtils.samlObjectToString((SAMLObject)attribute));
                attributes.add(attribute);
            }
        }
        return attributes;
    }

    private void checkAuthnStatement(List<AuthnStatement> authnStatements) {
        if (authnStatements.size() != 1) {
            throw SamlUtils.samlException("SAML Assertion subject contains {} Authn Statements while exactly one was expected.", authnStatements.size());
        }
        AuthnStatement authnStatement = authnStatements.get(0);
        Instant now = this.now();
        Instant pastNow = now.minusMillis(this.maxSkewInMillis());
        if (authnStatement.getSessionNotOnOrAfter() != null && !pastNow.isBefore(this.toInstant(authnStatement.getSessionNotOnOrAfter()))) {
            throw SamlUtils.samlException("Rejecting SAML assertion's Authentication Statement because [{}] is on/after [{}]", pastNow, authnStatement.getSessionNotOnOrAfter());
        }
        List<String> reqAuthnCtxClassRef = this.getSpConfiguration().getReqAuthnCtxClassRef();
        if (!reqAuthnCtxClassRef.isEmpty()) {
            String authnCtxClassRefValue = null;
            if (authnStatement.getAuthnContext() != null && authnStatement.getAuthnContext().getAuthnContextClassRef() != null) {
                authnCtxClassRefValue = authnStatement.getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef();
            }
            if (Strings.isNullOrEmpty(authnCtxClassRefValue) || !reqAuthnCtxClassRef.contains(authnCtxClassRefValue)) {
                throw SamlUtils.samlException("Rejecting SAML assertion as the AuthnContextClassRef [{}] is not one of the ({}) that were requested in the corresponding AuthnRequest", authnCtxClassRefValue, reqAuthnCtxClassRef);
            }
        }
    }

    private Attribute decrypt(EncryptedAttribute encrypted) {
        if (this.decrypter == null) {
            this.logger.info("SAML message has encrypted attribute [" + this.text((XMLObject)encrypted, 32) + "], but no encryption key has been configured");
            return null;
        }
        try {
            return this.decrypter.decrypt(encrypted);
        }
        catch (DecryptionException e) {
            this.logger.info("Failed to decrypt SAML attribute " + this.text((XMLObject)encrypted, 32), (Throwable)e);
            return null;
        }
    }

    private void checkConditions(Conditions conditions) {
        if (conditions != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("SAML Assertion was intended for the following Service providers: {}", (Object)conditions.getAudienceRestrictions().stream().map(r -> this.text((XMLObject)r, 32)).collect(Collectors.joining(" | ")));
                this.logger.trace("SAML Assertion is only valid between: " + conditions.getNotBefore() + " and " + conditions.getNotOnOrAfter());
            }
            this.checkAudienceRestrictions(conditions.getAudienceRestrictions());
            this.checkLifetimeRestrictions(conditions);
        }
    }

    private void checkSubject(Subject assertionSubject, XMLObject parent, Collection<String> allowedSamlRequestIds) {
        if (assertionSubject == null) {
            throw SamlUtils.samlException("SAML Assertion ({}) has no Subject", this.text(parent, 16));
        }
        List confirmationData = assertionSubject.getSubjectConfirmations().stream().filter(data -> data.getMethod().equals("urn:oasis:names:tc:SAML:2.0:cm:bearer")).map(SubjectConfirmation::getSubjectConfirmationData).filter(Objects::nonNull).collect(Collectors.toList());
        if (confirmationData.size() != 1) {
            throw SamlUtils.samlException("SAML Assertion subject contains {} bearer SubjectConfirmation, while exactly one was expected.", confirmationData.size());
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("SAML Assertion Subject Confirmation intended recipient is: " + ((SubjectConfirmationData)confirmationData.get(0)).getRecipient());
            this.logger.trace("SAML Assertion Subject Confirmation is only valid before: " + ((SubjectConfirmationData)confirmationData.get(0)).getNotOnOrAfter());
            this.logger.trace("SAML Assertion Subject Confirmation is in response to: " + ((SubjectConfirmationData)confirmationData.get(0)).getInResponseTo());
        }
        this.checkRecipient((SubjectConfirmationData)confirmationData.get(0));
        this.checkLifetimeRestrictions((SubjectConfirmationData)confirmationData.get(0));
        this.checkInResponseTo((SubjectConfirmationData)confirmationData.get(0), allowedSamlRequestIds);
    }

    private void checkRecipient(SubjectConfirmationData subjectConfirmationData) {
        SpConfiguration sp = this.getSpConfiguration();
        if (!sp.getAscUrl().equals(subjectConfirmationData.getRecipient())) {
            throw SamlUtils.samlException("SAML Assertion SubjectConfirmationData Recipient {} does not match expected value {}", subjectConfirmationData.getRecipient(), sp.getAscUrl());
        }
    }

    private void checkInResponseTo(SubjectConfirmationData subjectConfirmationData, Collection<String> allowedSamlRequestIds) {
        if (Strings.hasText((String)subjectConfirmationData.getInResponseTo()) && !allowedSamlRequestIds.contains(subjectConfirmationData.getInResponseTo())) {
            throw SamlUtils.samlException("SAML Assertion SubjectConfirmationData is in-response-to {} but expected one of {} ", subjectConfirmationData.getInResponseTo(), allowedSamlRequestIds);
        }
    }

    private void checkAudienceRestrictions(List<AudienceRestriction> restrictions) {
        String spEntityId = this.getSpConfiguration().getEntityId();
        Predicate<AudienceRestriction> predicate = ar -> ar.getAudiences().stream().map(Audience::getAudienceURI).anyMatch(spEntityId::equals);
        if (!restrictions.stream().allMatch(predicate)) {
            throw SamlUtils.samlException("Conditions [{}] do not match required audience [{}]", restrictions.stream().map(r -> this.text((XMLObject)r, 32)).collect(Collectors.joining(" | ")), this.getSpConfiguration().getEntityId());
        }
    }

    private void checkLifetimeRestrictions(Conditions conditions) {
        Instant now = this.now();
        Instant futureNow = now.plusMillis(this.maxSkewInMillis());
        Instant pastNow = now.minusMillis(this.maxSkewInMillis());
        if (conditions.getNotBefore() != null && futureNow.isBefore(this.toInstant(conditions.getNotBefore()))) {
            throw SamlUtils.samlException("Rejecting SAML assertion because [{}] is before [{}]", futureNow, conditions.getNotBefore());
        }
        if (conditions.getNotOnOrAfter() != null && !pastNow.isBefore(this.toInstant(conditions.getNotOnOrAfter()))) {
            throw SamlUtils.samlException("Rejecting SAML assertion because [{}] is on/after [{}]", pastNow, conditions.getNotOnOrAfter());
        }
    }

    private void checkLifetimeRestrictions(SubjectConfirmationData subjectConfirmationData) {
        this.validateNotOnOrAfter(subjectConfirmationData.getNotOnOrAfter());
    }
}

