/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.accesscontrol;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;

public class IndicesAccessControl {
    public static final IndicesAccessControl ALLOW_ALL = new IndicesAccessControl(true, Collections.emptyMap());
    public static final IndicesAccessControl ALLOW_NO_INDICES = new IndicesAccessControl(true, Collections.singletonMap("-*", new IndexAccessControl(true, new FieldPermissions(), null)));
    private final boolean granted;
    private final Map<String, IndexAccessControl> indexPermissions;

    public IndicesAccessControl(boolean granted, Map<String, IndexAccessControl> indexPermissions) {
        this.granted = granted;
        this.indexPermissions = indexPermissions;
    }

    @Nullable
    public IndexAccessControl getIndexPermissions(String index) {
        return this.indexPermissions.get(index);
    }

    public boolean isGranted() {
        return this.granted;
    }

    public String toString() {
        return "IndicesAccessControl{granted=" + this.granted + ", indexPermissions=" + this.indexPermissions + '}';
    }

    public static class IndexAccessControl {
        private final boolean granted;
        private final FieldPermissions fieldPermissions;
        private final Set<BytesReference> queries;

        public IndexAccessControl(boolean granted, FieldPermissions fieldPermissions, Set<BytesReference> queries) {
            this.granted = granted;
            this.fieldPermissions = fieldPermissions;
            this.queries = queries;
        }

        public boolean isGranted() {
            return this.granted;
        }

        public FieldPermissions getFieldPermissions() {
            return this.fieldPermissions;
        }

        @Nullable
        public Set<BytesReference> getQueries() {
            return this.queries;
        }

        public String toString() {
            return "IndexAccessControl{granted=" + this.granted + ", fieldPermissions=" + this.fieldPermissions + ", queries=" + this.queries + '}';
        }
    }
}

