/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.planner;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.planner.Mapper;
import org.elasticsearch.xpack.sql.planner.PlanningException;
import org.elasticsearch.xpack.sql.planner.QueryFolder;
import org.elasticsearch.xpack.sql.planner.Verifier;
import org.elasticsearch.xpack.sql.tree.Node;

public class Planner {
    private final Mapper mapper = new Mapper();
    private final QueryFolder folder = new QueryFolder();

    public PhysicalPlan plan(LogicalPlan plan) {
        return this.plan(plan, true);
    }

    public PhysicalPlan plan(LogicalPlan plan, boolean verify) {
        return this.foldPlan(this.mapPlan(plan, verify), verify);
    }

    public PhysicalPlan mapPlan(LogicalPlan plan, boolean verify) {
        return verify ? this.verifyMappingPlan(this.mapper.map(plan)) : this.mapper.map(plan);
    }

    public PhysicalPlan foldPlan(PhysicalPlan mapped, boolean verify) {
        return verify ? this.verifyExecutingPlan(this.folder.fold(mapped)) : this.folder.fold(mapped);
    }

    public PhysicalPlan verifyMappingPlan(PhysicalPlan plan) {
        List<Verifier.Failure> failures = Verifier.verifyMappingPlan(plan);
        if (!failures.isEmpty()) {
            throw new PlanningException(failures);
        }
        return plan;
    }

    public Map<Node<?>, String> verifyMappingPlanFailures(PhysicalPlan plan) {
        List<Verifier.Failure> failures = Verifier.verifyMappingPlan(plan);
        return failures.stream().collect(Collectors.toMap(Verifier.Failure::source, Verifier.Failure::message));
    }

    public PhysicalPlan verifyExecutingPlan(PhysicalPlan plan) {
        List<Verifier.Failure> failures = Verifier.verifyExecutingPlan(plan);
        if (!failures.isEmpty()) {
            throw new PlanningException(failures);
        }
        return plan;
    }

    public Map<Node<?>, String> verifyExecutingPlanFailures(PhysicalPlan plan) {
        List<Verifier.Failure> failures = Verifier.verifyExecutingPlan(plan);
        return failures.stream().collect(Collectors.toMap(Verifier.Failure::source, Verifier.Failure::message));
    }
}

