/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.Locale;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.Params;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.function.scalar.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.querydsl.agg.AggFilter;
import org.elasticsearch.xpack.sql.type.DataType;

public class OrAggFilter
extends AggFilter {
    public OrAggFilter(AggFilter left, AggFilter right) {
        this(left.name() + "_|_" + right.name(), left, right);
    }

    public OrAggFilter(String name, AggFilter left, AggFilter right) {
        super(name, OrAggFilter.and(left.scriptTemplate(), right.scriptTemplate()));
    }

    private static ScriptTemplate and(ScriptTemplate left, ScriptTemplate right) {
        String template = String.format(Locale.ROOT, "( %s ) || ( %s )", left.template(), right.template());
        Params params = new ParamsBuilder().script(left.params()).script(right.params()).build();
        return new ScriptTemplate(template, params, DataType.BOOLEAN);
    }
}

