/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.Iterator;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.SelectOption;

public class RangeOption
extends SelectOption {
    private static final Logger logger = Logger.getLogger(RangeOption.class.getName());

    public RangeOption(Specification specification) {
        super(specification);
    }

    public int getValueRank() {
        int rank = 0;
        for (Integer i : this.getItemValues().keySet()) {
            if (i == this.getValue()) {
                return rank;
            }
            ++rank;
        }
        return 0;
    }

    public void setValueRank(int rank) {
        int curValue = Integer.MIN_VALUE;
        Iterator<Integer> iterator = this.getItemValues().keySet().iterator();
        while (rank >= 0 && iterator.hasNext()) {
            curValue = iterator.next();
            --rank;
        }
        this.setValue(curValue);
    }

    @Override
    public String getXMLItemElementTagName() {
        return "rangeValue";
    }

    @Override
    public String getXMLTagName() {
        return RangeOption.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "rangeOption";
    }
}

