/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.wagon;

import java.io.File;
import java.net.URI;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ReadableContent;

public class RepositoryTransportWagonAdapter {
    private final RepositoryTransport transport;
    private final URI rootUri;

    public RepositoryTransportWagonAdapter(RepositoryTransport transport, URI rootUri) {
        this.transport = transport;
        this.rootUri = rootUri;
    }

    public boolean getRemoteFile(File destination, String resourceName) throws ResourceException {
        ExternalResourceName location = this.getLocationForResource(resourceName);
        ExternalResource resource = this.transport.getRepository().resource(location);
        return resource.writeToIfPresent(destination) != null;
    }

    public void putRemoteFile(ReadableContent content, String resourceName) throws ResourceException {
        this.transport.getRepository().withProgressLogging().resource(this.getLocationForResource(resourceName)).put(content);
    }

    private ExternalResourceName getLocationForResource(String resource) {
        return new ExternalResourceName(this.rootUri, resource);
    }
}

