#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: psqueues
version: 0.2.7.0
id: psqueues-0.2.7.0-BPqM29kOUwk3wJsDqYO9jn
key: psqueues-0.2.7.0-BPqM29kOUwk3wJsDqYO9jn
license: BSD-3-Clause
maintainer: Jasper Van der Jeugt <jaspervdj@gmail.com>
synopsis: Pure priority search queues
description:
    The psqueues package provides
    <http://en.wikipedia.org/wiki/Priority_queue Priority Search Queues> in
    three different flavors.
    .
    * @OrdPSQ k p v@, which uses the @Ord k@ instance to provide fast insertion,
    deletion and lookup. This implementation is based on Ralf Hinze'\''s
    <http://citeseer.ist.psu.edu/hinze01simple.html A Simple Implementation Technique for Priority Search Queues>.
    Hence, it is similar to the
    <http://hackage.haskell.org/package/PSQueue PSQueue> library, although it is
    considerably faster and provides a slightly different API.
    .
    * @IntPSQ p v@ is a far more efficient implementation. It fixes the key type
    to @Int@ and uses a <http://en.wikipedia.org/wiki/Radix_tree radix tree>
    (like @IntMap@) with an additional min-heap property.
    .
    * @HashPSQ k p v@ is a fairly straightforward extension of @IntPSQ@: it
    simply uses the keys'\'' hashes as indices in the @IntPSQ@. If there are any
    hash collisions, it uses an @OrdPSQ@ to resolve those. The performance of
    this implementation is comparable to that of @IntPSQ@, but it is more widely
    applicable since the keys are not restricted to @Int@, but rather to any
    @Hashable@ datatype.
    .
    Each of the three implementations provides the same API, so they can be used
    interchangeably. The benchmarks show how they perform relative to one
    another, and also compared to the other Priority Search Queue
    implementations on Hackage:
    <http://hackage.haskell.org/package/PSQueue PSQueue>
    and
    <http://hackage.haskell.org/package/fingertree-psqueue fingertree-psqueue>.
    .
    <<http://i.imgur.com/KmbDKR6.png>>
    .
    <<http://i.imgur.com/ClT181D.png>>
    .
    Typical applications of Priority Search Queues include:
    .
    * Caches, and more specifically LRU Caches;
    .
    * Schedulers;
    .
    * Pathfinding algorithms, such as Dijkstra'\''s and A*.
category: Data Structures
abi: a25f782677851508655c9200f7ebfc2c
exposed: True
exposed-modules:
    Data.HashPSQ Data.IntPSQ Data.OrdPSQ
hidden-modules: Data.BitUtil Data.HashPSQ.Internal
                Data.IntPSQ.Internal Data.OrdPSQ.Internal
import-dirs: /usr/lib/ghc-8.4.3/site-local/psqueues-0.2.7.0
library-dirs: /usr/lib/ghc-8.4.3/site-local/psqueues-0.2.7.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/psqueues-0.2.7.0
hs-libraries: HSpsqueues-0.2.7.0-BPqM29kOUwk3wJsDqYO9jn
depends:
    base-4.11.1.0 deepseq-1.4.3.0
    hashable-1.2.7.0-KBRKfoLB8Vi3u8lTX7XQlg ghc-prim-0.5.2.0
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             deepseq-1.4.3.0=34da2d42d10eacba0aad99c95b538637
             hashable-1.2.7.0-KBRKfoLB8Vi3u8lTX7XQlg=0f14342a1ffe8710d31657335cf81134
             ghc-prim-0.5.2.0=387aa7e78e4e6c49e51798e4d6763c3f
haddock-interfaces: /usr/share/doc/haskell-psqueues/html/psqueues.haddock
haddock-html: /usr/share/doc/haskell-psqueues/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

