/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.BuildException;

public abstract class IvyCacheTask
extends IvyPostResolveTask {
    protected List<ArtifactDownloadReport> getArtifactReports() throws BuildException, ParseException, IOException {
        Collection<ArtifactDownloadReport> artifacts = this.getAllArtifactReports();
        ArrayList<ArtifactDownloadReport> ret = new ArrayList<ArtifactDownloadReport>();
        for (ArtifactDownloadReport artifactReport : artifacts) {
            if (!this.getArtifactFilter().accept(artifactReport.getArtifact())) continue;
            ret.add(artifactReport);
        }
        return ret;
    }

    private Collection<ArtifactDownloadReport> getAllArtifactReports() throws ParseException, IOException {
        String[] confs = this.splitConfs(this.getConf());
        LinkedHashSet<ArtifactDownloadReport> all = new LinkedHashSet<ArtifactDownloadReport>();
        ResolveReport report = this.getResolvedReport();
        if (report != null) {
            Message.debug("using internal report instance to get artifacts list");
            for (int i = 0; i < confs.length; ++i) {
                ConfigurationResolveReport configurationReport = report.getConfigurationReport(confs[i]);
                if (configurationReport == null) {
                    throw new BuildException("bad confs provided: " + confs[i] + " not found among " + Arrays.asList(report.getConfigurations()));
                }
                Set<ModuleRevisionId> revisions = configurationReport.getModuleRevisionIds();
                for (ModuleRevisionId revId : revisions) {
                    ArtifactDownloadReport[] aReports = configurationReport.getDownloadReports(revId);
                    all.addAll(Arrays.asList(aReports));
                }
            }
        } else {
            Message.debug("using stored report to get artifacts list");
            XmlReportParser parser = new XmlReportParser();
            ResolutionCacheManager cacheMgr = this.getIvyInstance().getResolutionCacheManager();
            String resolvedId = this.getResolveId();
            if (resolvedId == null) {
                resolvedId = ResolveOptions.getDefaultResolveId(this.getResolvedModuleId());
            }
            for (int i = 0; i < confs.length; ++i) {
                File reportFile = cacheMgr.getConfigurationResolveReportInCache(resolvedId, confs[i]);
                parser.parse(reportFile);
                ArtifactDownloadReport[] aReports = parser.getArtifactReports();
                all.addAll(Arrays.asList(aReports));
            }
        }
        return all;
    }
}

