/****************************************************************************
**
*W  objscoll.h                  GAP source                       Frank Celler
**
**
*Y  Copyright (C)  1996,  Lehrstuhl D für Mathematik,  RWTH Aachen,  Germany
*Y  (C) 1998 School Math and Comp. Sci., University of St Andrews, Scotland
*Y  Copyright (C) 2002 The GAP Group
*/

#ifndef libGAP_GAP_OBJSCOLL_H
#define libGAP_GAP_OBJSCOLL_H


/****************************************************************************
**
*D  SCP_SOMETHING
**
*/
#define libGAP_SCP_UNDERLYING_FAMILY       1   /* the family of our free grp elms */
#define libGAP_SCP_RWS_GENERATORS          2   /* the free grp generators used    */
#define libGAP_SCP_NUMBER_RWS_GENERATORS   3   /* number of generators            */
#define libGAP_SCP_DEFAULT_TYPE            4   /* default type of the result      */
#define libGAP_SCP_IS_DEFAULT_TYPE         5   /* tester for default type         */
#define libGAP_SCP_RELATIVE_ORDERS         6   /* list of relative orders         */
#define libGAP_SCP_POWERS                  7   /* list of power rhs               */
#define libGAP_SCP_CONJUGATES              8   /* list of list of conjugates rhs  */
#define libGAP_SCP_INVERSES                9   /* list of inverses of the gens    */
#define libGAP_SCP_COLLECTOR              10   /* collector to use                */
#define libGAP_SCP_AVECTOR                11   /* avector                         */
#define libGAP_SCP_LAST          libGAP_SCP_AVECTOR   /* last entry in a single coll.    */


/****************************************************************************
**
*D  SC_SOMETHING( <sc> )
**
**  WARNING: 'cwVector' and 'cw2Vector' must be cleaned after using them.
*/
#define libGAP_SC_AVECTOR(sc) \
    (libGAP_ADDR_OBJ(sc)[libGAP_SCP_AVECTOR])

#define libGAP_SC_COLLECTOR(sc) \
    (libGAP_FinPowConjCollectors[libGAP_INT_INTOBJ(libGAP_ADDR_OBJ(sc)[libGAP_SCP_COLLECTOR])])

#define libGAP_SC_CONJUGATES(sc) \
    (libGAP_ADDR_OBJ(sc)[libGAP_SCP_CONJUGATES])

#define libGAP_SC_DEFAULT_TYPE(sc) \
    (libGAP_ADDR_OBJ(sc)[libGAP_SCP_DEFAULT_TYPE])

#define libGAP_SC_INVERSES(sc) \
    (libGAP_ADDR_OBJ(sc)[libGAP_SCP_INVERSES])

#define libGAP_SC_NUMBER_RWS_GENERATORS(sc) \
    (libGAP_INT_INTOBJ((libGAP_ADDR_OBJ(sc)[libGAP_SCP_NUMBER_RWS_GENERATORS])))

#define libGAP_SC_POWERS(sc) \
    (libGAP_ADDR_OBJ(sc)[libGAP_SCP_POWERS])

#define libGAP_SC_RELATIVE_ORDERS(sc) \
    (libGAP_ADDR_OBJ(sc)[libGAP_SCP_RELATIVE_ORDERS])

#define libGAP_SC_RWS_GENERATORS(sc) \
    (libGAP_ADDR_OBJ(sc)[libGAP_SCP_RWS_GENERATORS])

extern libGAP_Obj libGAP_SC_NW_STACK;
extern libGAP_Obj libGAP_SC_LW_STACK;
extern libGAP_Obj libGAP_SC_PW_STACK;
extern libGAP_Obj libGAP_SC_EW_STACK;
extern libGAP_Obj libGAP_SC_GE_STACK;
extern libGAP_Obj libGAP_SC_CW_VECTOR;
extern libGAP_Obj libGAP_SC_CW2_VECTOR;
extern libGAP_UInt libGAP_SC_MAX_STACK_SIZE;

/****************************************************************************
**

*F  FuncFinPowConjCol_CollectWordOrFail( <self>, <sc>, <vv>, <w> )
*/
extern libGAP_Obj libGAP_FuncFinPowConjCol_CollectWordOrFail ( libGAP_Obj, libGAP_Obj, libGAP_Obj, libGAP_Obj );


/****************************************************************************
**
*F  FuncFinPowConjCol_ReducedComm( <self>, <sc>, <w>, <u> )
*/
extern libGAP_Obj libGAP_FuncFinPowConjCol_ReducedComm ( libGAP_Obj, libGAP_Obj, libGAP_Obj, libGAP_Obj );


/****************************************************************************
**
*F  FuncFinPowConjCol_ReducedForm( <self>, <sc>, <w> )
*/
extern libGAP_Obj libGAP_FuncFinPowConjCol_ReducedForm ( libGAP_Obj, libGAP_Obj, libGAP_Obj );


/****************************************************************************
**
*F  FuncFinPowConjCol_ReducedLeftQuotient( <self>, <sc>, <w>, <u> )
*/
extern libGAP_Obj libGAP_FuncFinPowConjCol_ReducedLeftQuotient ( libGAP_Obj, libGAP_Obj, libGAP_Obj, libGAP_Obj );


/****************************************************************************
**
*F  FuncFinPowConjCol_ReducedProduct( <self>, <sc>, <w>, <u> )
*/
extern libGAP_Obj libGAP_FuncFinPowConjCol_ReducedProduct ( libGAP_Obj, libGAP_Obj, libGAP_Obj, libGAP_Obj );


/****************************************************************************
**
*F  FuncFinPowConjCol_ReducedPowerSmallInt( <self>, <sc>, <w>, <pow> )
*/
extern libGAP_Obj libGAP_FuncFinPowConjCol_ReducedPowerSmallInt ( libGAP_Obj, libGAP_Obj, libGAP_Obj, libGAP_Obj);


/****************************************************************************
**
*F  FuncFinPowConjCol_ReducedQuotient( <self>, <sc>, <w>, <u> )
*/
extern libGAP_Obj libGAP_FuncFinPowConjCol_ReducedQuotient ( libGAP_Obj, libGAP_Obj, libGAP_Obj, libGAP_Obj );


/****************************************************************************
**

*F * * * * * * * * * * * * * initialize package * * * * * * * * * * * * * * *
*/


/****************************************************************************
**

*F  InitInfoSingleCollector() . . . . . . . . . . . . table of init functions
*/
libGAP_StructInitInfo * libGAP_InitInfoSingleCollector ( void );


#endif // GAP_OBJSCOLL_H

/****************************************************************************
**

*E  objscoll.h  . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
*/
