/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BC;
import javajs.util.MessagePackReader;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.jvxl.readers.MapFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class BCifDensityReader
extends MapFileReader {
    private int pt;
    float checkSum;
    protected float[] values;
    public Map<String, Object> cifData;
    public Map<String, Object> thisData;
    private boolean isDiff;

    BCifDensityReader() {
    }

    protected void getCifData(String fileName, Object data) {
        this.binarydoc = this.newBinaryDocument();
        if (AU.isAB(data)) {
            this.binarydoc.setStream(new BufferedInputStream(new ByteArrayInputStream((byte[])data)), true);
        } else {
            this.setStream(fileName, true);
        }
        this.nSurfaces = 1;
    }

    protected P3 readCifP3(String key, P3 p3) {
        float x;
        if (p3 == null) {
            p3 = new P3();
        }
        if (Float.isNaN(x = this.getCifFloat(key + "[0]"))) {
            p3.x = Float.NaN;
        } else {
            p3.x = x;
            p3.y = this.getCifFloat(key + "[1]");
            p3.z = this.getCifFloat(key + "[2]");
        }
        return p3;
    }

    protected Map<String, Object> getCifMap(String type) {
        if (this.cifData == null) {
            try {
                this.cifData = new MessagePackReader(this.binarydoc, true).readMap();
                System.out.println("BCifDensityReader BCIF encoder " + this.cifData.get("encoder") + " BCIF version " + this.cifData.get("version"));
            }
            catch (Exception e) {
                System.out.println("BCifDensityReader error " + e);
            }
        }
        Object[] dataBlocks = (Object[])this.cifData.get("dataBlocks");
        int i = dataBlocks.length;
        while (--i >= 0) {
            Map map = (Map)dataBlocks[i];
            if (!type.equalsIgnoreCase(map.get("header").toString())) continue;
            Object[] categories = (Object[])map.get("categories");
            int j = categories.length;
            while (--j >= 0) {
                Map cat = (Map)categories[j];
                String catName = (String)cat.get("name");
                Object[] columns = (Object[])cat.get("columns");
                int k = columns.length;
                while (--k >= 0) {
                    Map col = (Map)columns[k];
                    map.put(catName + "_" + col.get("name"), col.get("data"));
                }
            }
            map.remove("categories");
            this.thisData = map;
            return this.thisData;
        }
        return null;
    }

    protected String getCifString(String key) {
        Map map = (Map)this.thisData.get(key);
        byte[] data = (byte[])map.get("data");
        Map encoding = (Map)((Object[])map.get("encoding"))[0];
        Object o = encoding.get("offsetEncoding");
        return null;
    }

    protected float getCifFloat(String key) {
        Map map = (Map)this.thisData.get(key);
        byte[] data = (byte[])map.get("data");
        int encoding = (Integer)((Map)((Object[])map.get("encoding"))[0]).get("type");
        float f = Float.NaN;
        try {
            switch (encoding) {
                case 3: {
                    f = BC.bytesToInt(data, 0, false);
                    break;
                }
                case 33: {
                    f = BC.bytesToDoubleToFloat(data, 0, false);
                    break;
                }
                default: {
                    System.out.println("BCDensityReader: Number encoding not recognized: " + encoding);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return f;
    }

    protected float[] readCifFloats(String key, float[] values) {
        Map map = (Map)this.thisData.get(key);
        byte[] data = (byte[])map.get("data");
        Map encoding = (Map)((Object[])map.get("encoding"))[0];
        float min = ((Float)encoding.get("min")).floatValue();
        float max = ((Float)encoding.get("max")).floatValue();
        int numSteps = (Integer)encoding.get("numSteps");
        String kind = (String)encoding.get("kind");
        if ("IntervalQuantization".equals(kind)) {
            float delta = (max - min) / (float)(numSteps - 1);
            int i = data.length;
            while (--i >= 0) {
                values[i] = min + delta * (float)((data[i] + 256) % 256);
            }
        } else {
            System.out.println("BCifDensityReader: value encoding type? " + kind);
        }
        return values;
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.allowSigma = true;
        this.init2MFR(sg, br);
        Object[] o2 = (Object[])sg.getReaderData();
        String fileName = (String)o2[0];
        Object data = o2[1];
        this.isDiff = fileName != null && fileName.indexOf("&diff=1") >= 0 || data instanceof String && ((String)data).indexOf("#diff=1") >= 0;
        this.getCifData(fileName, data);
        this.nSurfaces = 1;
    }

    @Override
    protected void readParameters() throws Exception {
        this.getCifMap(this.isDiff ? "FO-FC" : "2FO-FC");
        String test = this.getCifString("_volume_data_3d_info_name");
        this.readCifP3("_volume_data_3d_info_axis_order", this.p3);
        P3 axis_order = this.readCifP3("_volume_data_3d_info_axis_order", null);
        P3 fracOrigin = this.readCifP3("_volume_data_3d_info_origin", null);
        P3 fracDimensions = this.readCifP3("_volume_data_3d_info_dimensions", null);
        P3 sampleCounts = this.readCifP3("_volume_data_3d_info_sample_count", this.p3);
        this.mapc = (int)axis_order.x + 1;
        this.mapr = (int)axis_order.y + 1;
        this.maps = (int)axis_order.z + 1;
        int[] crs2abc = new int[3];
        crs2abc[this.mapc - 1] = 0;
        crs2abc[this.mapr - 1] = 1;
        crs2abc[this.maps - 1] = 2;
        this.n0 = (int)sampleCounts.x;
        this.n1 = (int)sampleCounts.y;
        this.n2 = (int)sampleCounts.z;
        this.na = (int)this.getXYZ(sampleCounts, crs2abc[0]);
        this.nb = (int)this.getXYZ(sampleCounts, crs2abc[1]);
        this.nc = (int)this.getXYZ(sampleCounts, crs2abc[2]);
        this.readCifP3("_volume_data_3d_info_spacegroup_cell_size", this.p3);
        this.a = this.p3.x;
        this.b = this.p3.y;
        this.c = this.p3.z;
        float fa = this.getXYZ(fracDimensions, crs2abc[0]);
        float fb = this.getXYZ(fracDimensions, crs2abc[1]);
        float fc = this.getXYZ(fracDimensions, crs2abc[2]);
        this.xIndex = 0;
        this.xyzStart[0] = this.getXYZ(fracOrigin, crs2abc[0]) * (float)this.na / fa;
        this.yIndex = 1;
        this.xyzStart[1] = this.getXYZ(fracOrigin, crs2abc[1]) * (float)this.nb / fb;
        this.zIndex = 2;
        this.xyzStart[2] = this.getXYZ(fracOrigin, crs2abc[2]) * (float)this.nc / fc;
        this.a *= fa;
        this.b *= fb;
        this.c *= fc;
        this.readCifP3("_volume_data_3d_info_spacegroup_cell_angles", this.p3);
        this.alpha = this.p3.x;
        this.beta = this.p3.y;
        this.gamma = this.p3.z;
        this.values = this.readCifFloats("_volume_data_3d_values", new float[this.na * this.nb * this.nc]);
        this.getVectorsAndOrigin();
        if (this.params.thePlane == null && (this.params.cutoffAutomatic || !Float.isNaN(this.params.sigma))) {
            float sigma = this.params.sigma < 0.0f || Float.isNaN(this.params.sigma) ? 1.0f : this.params.sigma;
            this.dmean = this.getCifFloat("_volume_data_3d_info_mean_sampled");
            float rmsDeviation = this.getCifFloat("_volume_data_3d_info_sigma_sampled");
            this.params.cutoff = rmsDeviation * sigma + this.dmean;
            Logger.info("Cutoff set to (mean + rmsDeviation*" + sigma + " = " + this.params.cutoff + ")\n");
        }
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("CifDensity reader\n");
        this.jvxlFileHeaderBuffer.append("see http://www.ebi.ac.uk/pdbe/densities/x-ray/1cbs/dbox/\n");
    }

    private float getXYZ(P3 a, float x) {
        switch ((int)x) {
            case 0: {
                return a.x;
            }
            case 1: {
                return a.y;
            }
        }
        return a.z;
    }

    @Override
    protected float nextVoxel() throws Exception {
        float v = this.values[this.pt++];
        this.checkSum += v;
        return v;
    }

    @Override
    protected void skipData(int nPoints) throws Exception {
        this.pt += nPoints;
    }

    @Override
    protected void closeReader() {
        if (this.readerClosed) {
            return;
        }
        System.out.println("CifDensityReader checkSum=" + this.checkSum);
        super.closeReader();
    }
}

